/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Use ZoneOffset.UTC instead of ZoneId.of(\"Z\").", explanation="Avoid the magic constant (ZoneId.of(\"Z\")) in favor of a more descriptive API:  ZoneOffset.UTC", severity=BugPattern.SeverityLevel.ERROR)
public final class ZoneIdOfZ
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String ZONE_OFFSET = "java.time.ZoneOffset";
    private static final Matcher<ExpressionTree> ZONE_ID_OF = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.time.ZoneId").named("of"), Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.packageStartsWith((String)"java."), Matchers.packageStartsWith((String)"tck.java.")}))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String zone;
        if (ZONE_ID_OF.matches((Tree)tree, state) && (zone = (String)ASTHelpers.constValue((Tree)tree.getArguments().getFirst(), String.class)) != null && zone.equals("Z")) {
            SuggestedFix.Builder fix = SuggestedFix.builder().addImport(ZONE_OFFSET);
            fix.replace((Tree)tree, String.format("%s.UTC", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)ZONE_OFFSET)));
            return this.describeMatch(tree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }
}

