/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedBySymbolResolver;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByUtils;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Names;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Name;
import org.jspecify.annotations.Nullable;

public final class GuardedByBinder {
    static final Resolver ALREADY_BOUND_RESOLVER = new Resolver(){

        @Override
        public Symbol resolveIdentifier(IdentifierTree node) {
            return ASTHelpers.getSymbol((Tree)node);
        }

        @Override
        public Symbol.MethodSymbol resolveMethod(MethodInvocationTree node, Name name) {
            return ASTHelpers.getSymbol((MethodInvocationTree)node);
        }

        @Override
        public Symbol.MethodSymbol resolveMethod(MethodInvocationTree node, GuardedByExpression base, Name identifier) {
            return ASTHelpers.getSymbol((MethodInvocationTree)node);
        }

        @Override
        public Symbol resolveSelect(GuardedByExpression base, MemberSelectTree node) {
            return ASTHelpers.getSymbol((Tree)node);
        }

        @Override
        public Symbol resolveMemberReference(GuardedByExpression base, MemberReferenceTree node) {
            return ASTHelpers.getSymbol((MemberReferenceTree)node);
        }

        @Override
        public Symbol resolveTypeLiteral(ExpressionTree expression) {
            return ASTHelpers.getSymbol((Tree)expression);
        }

        @Override
        public Symbol resolveEnclosingClass(ExpressionTree expression) {
            return ASTHelpers.getSymbol((Tree)expression);
        }
    };
    private static final GuardedByExpression.Factory F = new GuardedByExpression.Factory();
    private static final SimpleTreeVisitor<GuardedByExpression, BinderContext> BINDER = new SimpleTreeVisitor<GuardedByExpression, BinderContext>(){

        @Override
        public GuardedByExpression visitMethodInvocation(MethodInvocationTree node, BinderContext context) {
            ExpressionTree methodSelect;
            IllegalGuardedBy.checkGuardedBy(node.getArguments().isEmpty() && node.getTypeArguments().isEmpty(), "Only nullary methods are allowed.");
            ExpressionTree expressionTree = methodSelect = node.getMethodSelect();
            Objects.requireNonNull(expressionTree);
            ExpressionTree expressionTree2 = expressionTree;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentifierTree.class, MemberSelectTree.class}, (Object)expressionTree2, n)) {
                case 0: {
                    IdentifierTree identifier = (IdentifierTree)expressionTree2;
                    Symbol.MethodSymbol method = context.resolver.resolveMethod(node, identifier.getName());
                    IllegalGuardedBy.checkGuardedBy(method != null, identifier.toString());
                    return this.bindSelect(this.computeBase(context, method), method);
                }
                case 1: {
                    MemberSelectTree select = (MemberSelectTree)expressionTree2;
                    GuardedByExpression base = (GuardedByExpression)this.visit(select.getExpression(), context);
                    IllegalGuardedBy.checkGuardedBy(base != null, select.getExpression().toString());
                    Symbol.MethodSymbol method = context.resolver.resolveMethod(node, base, select.getIdentifier());
                    IllegalGuardedBy.checkGuardedBy(method != null, select.toString());
                    return this.bindSelect(this.normalizeBase(context, method, base), method);
                }
            }
            throw new IllegalGuardedBy(methodSelect.getKind().toString());
        }

        @Override
        public GuardedByExpression visitMemberSelect(MemberSelectTree node, BinderContext context) {
            String name = node.getIdentifier().toString();
            if (name.equals("this")) {
                Symbol base = context.resolver.resolveEnclosingClass(node.getExpression());
                if (context.thisClass == base) {
                    return F.thisliteral();
                }
                return F.qualifiedThis(context.names, context.thisClass, base);
            }
            if (name.equals("class")) {
                Symbol base = context.resolver.resolveTypeLiteral(node.getExpression());
                return F.classLiteral(base);
            }
            GuardedByExpression base = (GuardedByExpression)this.visit(node.getExpression(), context);
            IllegalGuardedBy.checkGuardedBy(base != null, "Bad expression: %s", node.getExpression());
            Symbol sym = context.resolver.resolveSelect(base, node);
            IllegalGuardedBy.checkGuardedBy(sym != null, "Could not resolve: %s", node);
            boolean condition = sym instanceof Symbol.VarSymbol || sym instanceof Symbol.MethodSymbol;
            IllegalGuardedBy.checkGuardedBy(condition, "Bad member symbol: %s", sym.getClass());
            return this.bindSelect(this.normalizeBase(context, sym, base), sym);
        }

        @Override
        public GuardedByExpression visitMemberReference(MemberReferenceTree node, BinderContext context) {
            GuardedByExpression base = (GuardedByExpression)this.visit(node.getQualifierExpression(), context);
            IllegalGuardedBy.checkGuardedBy(base != null, node.getQualifierExpression().toString());
            Symbol method = context.resolver.resolveMemberReference(base, node);
            IllegalGuardedBy.checkGuardedBy(method != null, node.toString());
            return this.bindSelect(this.normalizeBase(context, method, base), method);
        }

        private GuardedByExpression bindSelect(GuardedByExpression base, Symbol sym) {
            if (base.kind().equals((Object)GuardedByExpression.Kind.TYPE_LITERAL) && !ASTHelpers.isStatic((Symbol)sym)) {
                throw new IllegalGuardedBy("Instance access on static: " + String.valueOf(base) + ", " + String.valueOf(sym));
            }
            return F.select(base, sym);
        }

        @Override
        public GuardedByExpression visitIdentifier(IdentifierTree node, BinderContext context) {
            Symbol symbol = context.resolver.resolveIdentifier(node);
            IllegalGuardedBy.checkGuardedBy(symbol != null, "Could not resolve %s", node);
            Symbol symbol2 = symbol;
            Objects.requireNonNull(symbol2);
            Symbol symbol3 = symbol2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Symbol.VarSymbol.class, Symbol.MethodSymbol.class, Symbol.ClassSymbol.class}, (Object)symbol3, n)) {
                case 0 -> {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol3;
                    switch (varSymbol.getKind()) {
                        case LOCAL_VARIABLE: 
                        case PARAMETER: 
                        case BINDING_VARIABLE: {
                            yield F.localVariable(varSymbol);
                        }
                        case FIELD: {
                            if (symbol.name.contentEquals("this")) {
                                yield F.thisliteral();
                            }
                            yield F.select(this.computeBase(context, varSymbol), varSymbol);
                        }
                    }
                    throw new IllegalGuardedBy(varSymbol.getKind().toString());
                }
                case 1 -> {
                    Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol3;
                    yield F.select(this.computeBase(context, symbol), methodSymbol);
                }
                case 2 -> {
                    Symbol.ClassSymbol unused = (Symbol.ClassSymbol)symbol3;
                    if (node.getName().contentEquals("this")) {
                        yield F.thisliteral();
                    }
                    yield F.typeLiteral(symbol);
                }
                default -> throw new IllegalGuardedBy(symbol.getClass().toString());
            };
        }

        @Override
        public GuardedByExpression visitParenthesized(ParenthesizedTree node, BinderContext context) {
            return node.getExpression().accept(this, context);
        }

        private GuardedByExpression computeBase(BinderContext context, Symbol symbol) {
            return this.normalizeBase(context, symbol, null);
        }

        private GuardedByExpression normalizeBase(BinderContext context, Symbol symbol, GuardedByExpression base) {
            if (ASTHelpers.isStatic((Symbol)symbol)) {
                return F.typeLiteral(ASTHelpers.enclosingClass((Symbol)symbol));
            }
            if (base != null && base.kind() != GuardedByExpression.Kind.THIS) {
                return base;
            }
            if (symbol.isMemberOf(context.thisClass.type.tsym, context.types)) {
                return F.thisliteral();
            }
            Symbol.ClassSymbol lexicalOwner = this.isEnclosedIn(context.thisClass, symbol, context.types);
            if (lexicalOwner != null) {
                return F.qualifiedThis(context.names, context.thisClass, lexicalOwner);
            }
            throw new IllegalGuardedBy("Could not find the implicit receiver.");
        }

        private @Nullable Symbol.ClassSymbol isEnclosedIn(Symbol.ClassSymbol startingClass, Symbol member, Types types) {
            Symbol.ClassSymbol scope = ASTHelpers.enclosingClass((Symbol)startingClass);
            while (scope != null) {
                if (member.isMemberOf(scope.type.tsym, types)) {
                    return scope;
                }
                scope = ASTHelpers.enclosingClass((Symbol)scope);
            }
            return null;
        }
    };

    public static Optional<GuardedByExpression> bindExpression(JCTree.JCExpression exp, VisitorState visitorState) {
        try {
            return Optional.of(GuardedByBinder.bind(exp, BinderContext.of(ALREADY_BOUND_RESOLVER, ASTHelpers.getSymbol((ClassTree)((ClassTree)visitorState.findEnclosing(new Class[]{ClassTree.class}))), visitorState.getTypes(), visitorState.getNames())));
        }
        catch (IllegalGuardedBy expected) {
            return Optional.empty();
        }
    }

    public static Optional<GuardedByExpression> bindString(String string, GuardedBySymbolResolver resolver) {
        try {
            return Optional.of(GuardedByBinder.bind(GuardedByUtils.parseString(string, resolver.context()), BinderContext.of(resolver, resolver.enclosingClass(), resolver.visitorState().getTypes(), resolver.visitorState().getNames())));
        }
        catch (IllegalGuardedBy expected) {
            return Optional.empty();
        }
    }

    private static GuardedByExpression bind(JCTree.JCExpression exp, BinderContext context) {
        GuardedByExpression expr = BINDER.visit(exp, context);
        IllegalGuardedBy.checkGuardedBy(expr != null, String.valueOf(exp));
        IllegalGuardedBy.checkGuardedBy(expr.kind() != GuardedByExpression.Kind.TYPE_LITERAL, "Raw type literal: %s", exp);
        return expr;
    }

    private GuardedByBinder() {
    }

    public static interface Resolver {
        public Symbol resolveIdentifier(IdentifierTree var1);

        public Symbol.MethodSymbol resolveMethod(MethodInvocationTree var1, Name var2);

        public Symbol.MethodSymbol resolveMethod(MethodInvocationTree var1, GuardedByExpression var2, Name var3);

        public Symbol resolveSelect(GuardedByExpression var1, MemberSelectTree var2);

        public Symbol resolveMemberReference(GuardedByExpression var1, MemberReferenceTree var2);

        public Symbol resolveTypeLiteral(ExpressionTree var1);

        public Symbol resolveEnclosingClass(ExpressionTree var1);
    }

    private static class BinderContext {
        final Resolver resolver;
        final Symbol.ClassSymbol thisClass;
        final Types types;
        final Names names;

        BinderContext(Resolver resolver, Symbol.ClassSymbol thisClass, Types types, Names names) {
            this.resolver = resolver;
            this.thisClass = thisClass;
            this.types = types;
            this.names = names;
        }

        static BinderContext of(Resolver resolver, Symbol.ClassSymbol thisClass, Types types, Names names) {
            return new BinderContext(resolver, thisClass, types, names);
        }
    }
}

