/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Null check on an expression that is statically determined to be non-null according to language semantics or nullness annotations.", severity=BugPattern.SeverityLevel.WARNING)
public class RedundantNullCheck
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> OBJECTS_REQUIRE_NON_NULL = MethodMatchers.staticMethod().onClass("java.util.Objects").named("requireNonNull");
    private final boolean checkRequireNonNull;

    @Inject
    RedundantNullCheck(ErrorProneFlags flags) {
        this.checkRequireNonNull = flags.getBoolean("RedundantNullCheck:CheckRequireNonNull").orElse(false);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol;
        Symbol.VarSymbol varSymbol;
        if (!this.checkRequireNonNull) {
            return Description.NO_MATCH;
        }
        if (!OBJECTS_REQUIRE_NON_NULL.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = tree.getArguments().get(0);
        Symbol symbol = ASTHelpers.getSymbol((Tree)arg);
        if (symbol instanceof Symbol.VarSymbol && !RedundantNullCheck.isEffectivelyNullable(varSymbol = (Symbol.VarSymbol)symbol, state)) {
            return this.describeMatch(tree);
        }
        if (symbol instanceof Symbol.MethodSymbol && !RedundantNullCheck.isEffectivelyNullable(methodSymbol = (Symbol.MethodSymbol)symbol, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        NullnessUtils.NullCheck nullCheck = NullnessUtils.getNullCheck(tree);
        if (nullCheck == null) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol varSymbol = nullCheck.varSymbolButUsuallyPreferBareIdentifier();
        if (varSymbol != null && !RedundantNullCheck.isEffectivelyNullable(varSymbol, state)) {
            return this.describeMatch(tree);
        }
        Symbol.MethodSymbol methodSymbol = nullCheck.methodSymbol();
        if (methodSymbol != null && !RedundantNullCheck.isEffectivelyNullable(methodSymbol, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean isEffectivelyNullable(Symbol.VarSymbol varSymbol, VisitorState state) {
        Optional varNullness;
        boolean isLocalOrResourceVariable;
        boolean bl = isLocalOrResourceVariable = varSymbol.getKind() == ElementKind.LOCAL_VARIABLE || varSymbol.getKind() == ElementKind.RESOURCE_VARIABLE;
        if (!isLocalOrResourceVariable && (varNullness = NullnessAnnotations.fromAnnotationsOn((Symbol)varSymbol)).isPresent()) {
            return varNullness.get() == Nullness.NULLABLE;
        }
        if (((Type)varSymbol.asType()).getKind() == TypeKind.TYPEVAR) {
            return true;
        }
        VariableTree varDecl = NullnessUtils.findDeclaration(state, varSymbol);
        if (varSymbol.getKind() == ElementKind.PARAMETER && ASTHelpers.hasImplicitType((VariableTree)varDecl, (VisitorState)state)) {
            return true;
        }
        if (isLocalOrResourceVariable) {
            if (varDecl.getInitializer() == null) {
                return true;
            }
            if (!ASTHelpers.isConsideredFinal((Symbol)varSymbol)) {
                return true;
            }
            ExpressionTree initializer = varDecl.getInitializer();
            if (initializer instanceof MethodInvocationTree) {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)initializer;
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocation);
                return methodSymbol == null || RedundantNullCheck.isEffectivelyNullable(methodSymbol, state);
            }
            if (initializer instanceof LiteralTree) {
                return initializer.getKind() == Tree.Kind.NULL_LITERAL;
            }
            return true;
        }
        return !NullnessUtils.isInNullMarkedScope(varSymbol, state);
    }

    private static boolean isEffectivelyNullable(Symbol.MethodSymbol methodSymbol, VisitorState state) {
        Optional returnTypeNullness = NullnessAnnotations.fromAnnotationsOn((Symbol)methodSymbol);
        if (returnTypeNullness.isPresent()) {
            return returnTypeNullness.get() == Nullness.NULLABLE;
        }
        if (methodSymbol.isConstructor()) {
            return false;
        }
        if (methodSymbol.getReturnType().getKind() == TypeKind.TYPEVAR) {
            return true;
        }
        return !NullnessUtils.isInNullMarkedScope(methodSymbol, state);
    }
}

