/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Name;
import org.jspecify.annotations.Nullable;

final class NullnessUtils {
    private static final Matcher<ExpressionTree> OPTIONAL_OR_NULL = Matchers.instanceMethod().onDescendantOf("com.google.common.base.Optional").named("orNull");
    private static final Matcher<ExpressionTree> OPTIONAL_OR_ELSE = Matchers.instanceMethod().onDescendantOf("java.util.Optional").named("orElse");
    private static final Matcher<ExpressionTree> EMPTY_TO_NULL = Matchers.staticMethod().onClass("com.google.common.base.Strings").named("emptyToNull");

    private NullnessUtils() {
    }

    static boolean nullnessChecksShouldBeConservative(ErrorProneFlags flags) {
        return flags.getBoolean("Nullness:Conservative").orElse(true);
    }

    static boolean isInNullMarkedScope(Symbol sym, VisitorState state) {
        while (sym != null) {
            boolean marked = ASTHelpers.hasAnnotation((Symbol)sym, (String)"org.jspecify.annotations.NullMarked", (VisitorState)state);
            boolean unmarked = ASTHelpers.hasAnnotation((Symbol)sym, (String)"org.jspecify.annotations.NullUnmarked", (VisitorState)state);
            if (marked && !unmarked) {
                return true;
            }
            if (unmarked && !marked) {
                return false;
            }
            sym = sym.getEnclosingElement();
        }
        return false;
    }

    static SuggestedFix fixByAddingNullableAnnotationToReturnType(VisitorState state, MethodTree method) {
        return NullnessUtils.fixByAddingNullableAnnotationToElementOrType(state, method, method.getReturnType(), "nullness:return");
    }

    static SuggestedFix fixByAddingNullableAnnotationToType(VisitorState state, VariableTree variable) {
        return NullnessUtils.fixByAddingNullableAnnotationToElementOrType(state, variable, variable.getType(), null);
    }

    private static SuggestedFix fixByAddingNullableAnnotationToElementOrType(VisitorState state, Tree elementTree, Tree typeTree, @Nullable String suppressionToRemove) {
        NullableAnnotationToUse nullableAnnotationToUse = NullnessUtils.pickNullableAnnotation(state);
        switch (NullnessUtils.applyOnlyIfAlreadyInScope(state).ordinal()) {
            case 2: {
                if (nullableAnnotationToUse.isAlreadyInScope()) break;
                return SuggestedFix.emptyFix();
            }
            case 0: {
                if (!nullableAnnotationToUse.isAlreadyInScope()) break;
                return SuggestedFix.emptyFix();
            }
        }
        if (!nullableAnnotationToUse.isTypeUse()) {
            return nullableAnnotationToUse.fixPrefixingOnto(elementTree, state, suppressionToRemove);
        }
        return NullnessUtils.fixByAddingKnownTypeUseNullableAnnotation(state, typeTree, nullableAnnotationToUse, suppressionToRemove);
    }

    static SuggestedFix fixByAnnotatingTypeUseOnlyLocationWithNullableAnnotation(VisitorState state, Tree typeTree) {
        NullableAnnotationToUse nullableAnnotationToUse = NullnessUtils.pickNullableAnnotation(state);
        if (!nullableAnnotationToUse.isTypeUse()) {
            return SuggestedFix.emptyFix();
        }
        return NullnessUtils.fixByAddingKnownTypeUseNullableAnnotation(state, typeTree, nullableAnnotationToUse, null);
    }

    private static SuggestedFix fixByAddingKnownTypeUseNullableAnnotation(VisitorState state, Tree typeTree, NullableAnnotationToUse nullableAnnotationToUse, @Nullable String suppressionToRemove) {
        if (typeTree instanceof ParameterizedTypeTree) {
            ParameterizedTypeTree ptt = (ParameterizedTypeTree)typeTree;
            typeTree = ptt.getType();
        }
        switch (typeTree.getKind()) {
            case ARRAY_TYPE: {
                Tree beforeBrackets = typeTree;
                while (true) {
                    Tree pastAnnotations;
                    if (beforeBrackets instanceof AnnotatedTypeTree) {
                        AnnotatedTypeTree att = (AnnotatedTypeTree)beforeBrackets;
                        v0 = att.getUnderlyingType();
                    } else {
                        v0 = pastAnnotations = beforeBrackets;
                    }
                    if (!(pastAnnotations instanceof ArrayTypeTree)) break;
                    ArrayTypeTree arrayTypeTree = (ArrayTypeTree)pastAnnotations;
                    beforeBrackets = arrayTypeTree.getType();
                }
                return nullableAnnotationToUse.fixPostfixingOnto(beforeBrackets, state, suppressionToRemove);
            }
            case MEMBER_SELECT: {
                int lastDot = Lists.reverse((List)state.getOffsetTokensForNode(typeTree)).stream().filter(t -> t.kind() == Tokens.TokenKind.DOT).findFirst().get().pos();
                return nullableAnnotationToUse.fixPostfixingOnto(lastDot, state, suppressionToRemove);
            }
            case ANNOTATED_TYPE: {
                return nullableAnnotationToUse.fixPrefixingOnto(((AnnotatedTypeTree)typeTree).getAnnotations().getFirst(), state, suppressionToRemove);
            }
            case IDENTIFIER: {
                return nullableAnnotationToUse.fixPrefixingOnto(typeTree, state, suppressionToRemove);
            }
        }
        throw new AssertionError((Object)("unexpected kind for type tree: " + String.valueOf((Object)typeTree.getKind()) + " for " + String.valueOf(typeTree)));
    }

    static boolean isAlreadyAnnotatedNullable(Symbol symbol) {
        return NullnessAnnotations.fromAnnotationsOn((Symbol)symbol).orElse(null) == Nullness.NULLABLE;
    }

    static boolean hasExtraParameterForEnclosingInstance(Symbol.MethodSymbol symbol) {
        if (!symbol.isConstructor()) {
            return false;
        }
        Symbol.ClassSymbol constructedClass = ASTHelpers.enclosingClass((Symbol)symbol);
        Objects.requireNonNull(constructedClass, symbol::toString);
        return ASTHelpers.enclosingClass((Symbol)constructedClass) != null && !constructedClass.isStatic();
    }

    private static NullableAnnotationToUse pickNullableAnnotation(VisitorState state) {
        Symbol sym = FindIdentifiers.findIdent((String)"Nullable", (VisitorState)state, (Kinds.KindSelector)Kinds.KindSelector.VAL_TYP);
        ErrorProneFlags flags = state.errorProneOptions().getFlags();
        String defaultType = flags.get("Nullness:DefaultNullnessAnnotation").orElse(state.isAndroidCompatible() ? "androidx.annotation.Nullable" : "org.jspecify.annotations.Nullable");
        if (sym != null) {
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)sym;
            if (classSym.isAnnotationType()) {
                return NullableAnnotationToUse.annotationWithoutImporting("Nullable", NullnessUtils.isTypeUse(classSym.className()), true);
            }
            return NullableAnnotationToUse.annotationWithoutImporting(defaultType, NullnessUtils.isTypeUse(defaultType), false);
        }
        return NullableAnnotationToUse.annotationToBeImported(defaultType, NullnessUtils.isTypeUse(defaultType));
    }

    private static boolean isTypeUse(String className) {
        return switch (className) {
            case "libcore.util.Nullable", "org.checkerframework.checker.nullness.compatqual.NullableType", "org.checkerframework.checker.nullness.qual.Nullable", "org.jspecify.annotations.NonNull", "org.jspecify.annotations.Nullable" -> true;
            default -> false;
        };
    }

    static @Nullable NullCheck getNullCheck(ExpressionTree tree) {
        Symbol.MethodSymbol ms;
        Symbol.VarSymbol vs;
        Name name;
        ExpressionTree nullChecked;
        NullCheck.Polarity polarity;
        tree = ASTHelpers.stripParentheses((ExpressionTree)tree);
        switch (tree.getKind()) {
            case EQUAL_TO: {
                polarity = NullCheck.Polarity.IS_NULL;
                break;
            }
            case NOT_EQUAL_TO: {
                polarity = NullCheck.Polarity.IS_NOT_NULL;
                break;
            }
            default: {
                return null;
            }
        }
        BinaryTree equalityTree = (BinaryTree)tree;
        if (equalityTree.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            nullChecked = equalityTree.getLeftOperand();
        } else if (equalityTree.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            nullChecked = equalityTree.getRightOperand();
        } else {
            return null;
        }
        if (nullChecked instanceof IdentifierTree) {
            IdentifierTree id = (IdentifierTree)nullChecked;
            name = id.getName();
        } else {
            name = null;
        }
        Name name2 = name;
        Symbol symbol = ASTHelpers.getSymbol((Tree)nullChecked);
        Symbol.VarSymbol varSymbol = symbol instanceof Symbol.VarSymbol ? (vs = (Symbol.VarSymbol)symbol) : null;
        Symbol.MethodSymbol methodSymbol = symbol instanceof Symbol.MethodSymbol ? (ms = (Symbol.MethodSymbol)symbol) : null;
        return new NullCheck(name2, varSymbol, methodSymbol, polarity);
    }

    static boolean hasDefinitelyNullBranch(ExpressionTree tree, final Set<Symbol.VarSymbol> definitelyNullVars, final ImmutableSet<Name> varsProvenNullByParentIf, final VisitorState stateForCompilationUnit) {
        return (Boolean)new SimpleTreeVisitor<Boolean, Void>(){

            @Override
            public Boolean visitAssignment(AssignmentTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
                return (Boolean)this.visit(tree.getTrueExpression(), null) != false || (Boolean)this.visit(tree.getFalseExpression(), null) != false || NullnessUtils.isTernaryXIfXIsNull(tree);
            }

            @Override
            public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
                return (Boolean)super.visitIdentifier(tree, null) != false || varsProvenNullByParentIf.contains((Object)tree.getName());
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                return (Boolean)super.visitMethodInvocation(tree, null) != false || this.isOptionalOrNull(tree) || this.isStringsEmptyToNull(tree);
            }

            @Override
            public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            protected Boolean defaultAction(Tree tree, Void unused) {
                return NullnessUtils.isVoid(ASTHelpers.getType((Tree)tree), stateForCompilationUnit) || definitelyNullVars.contains(ASTHelpers.getSymbol((Tree)tree)) || this.isSwitchExpressionWithDefinitelyNullBranch(tree);
            }

            boolean isOptionalOrNull(MethodInvocationTree tree) {
                return OPTIONAL_OR_NULL.matches((Tree)tree, stateForCompilationUnit) || OPTIONAL_OR_ELSE.matches((Tree)tree, stateForCompilationUnit) && tree.getArguments().getFirst().getKind() == Tree.Kind.NULL_LITERAL;
            }

            boolean isStringsEmptyToNull(MethodInvocationTree tree) {
                return EMPTY_TO_NULL.matches((Tree)tree, stateForCompilationUnit);
            }

            boolean isSwitchExpressionWithDefinitelyNullBranch(Tree tree) {
                SwitchExpressionTree switchExpressionTree;
                return tree instanceof SwitchExpressionTree && (switchExpressionTree = (SwitchExpressionTree)tree).getCases().stream().map(c -> c.getBody()).anyMatch(t -> Objects.equals(this.visit((Tree)t, null), Boolean.TRUE));
            }
        }.visit(tree, null);
    }

    private static boolean isTernaryXIfXIsNull(ConditionalExpressionTree tree) {
        NullCheck nullCheck = NullnessUtils.getNullCheck(tree.getCondition());
        if (nullCheck == null) {
            return false;
        }
        ExpressionTree needsToBeKnownNull = nullCheck.nullCase(tree);
        return nullCheck.bareIdentifierMatches(needsToBeKnownNull);
    }

    static boolean isVoid(Type type, VisitorState state) {
        return type != null && state.getTypes().isSubtype(type, (Type)Suppliers.JAVA_LANG_VOID_TYPE.get(state));
    }

    static ImmutableSet<Name> varsProvenNullByParentIf(TreePath path) {
        Tree parent = path.getParentPath().getLeaf();
        if (!(parent instanceof BlockTree)) {
            return ImmutableSet.of();
        }
        BlockTree blockTree = (BlockTree)parent;
        if (blockTree.getStatements().size() > 1) {
            return ImmutableSet.of();
        }
        Tree grandparent = path.getParentPath().getParentPath().getLeaf();
        if (!(grandparent instanceof IfTree)) {
            return ImmutableSet.of();
        }
        IfTree ifTree = (IfTree)grandparent;
        NullCheck nullCheck = NullnessUtils.getNullCheck(ifTree.getCondition());
        if (nullCheck == null) {
            return ImmutableSet.of();
        }
        if (parent != nullCheck.nullCase(ifTree)) {
            return ImmutableSet.of();
        }
        if (nullCheck.bareIdentifier() == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.of((Object)nullCheck.bareIdentifier());
    }

    public static ImmutableSet<Name> varsProvenNullByParentTernary(TreePath path) {
        Tree child = path.getLeaf();
        for (Tree tree : path.getParentPath()) {
            if (!(tree instanceof ExpressionTree)) break;
            if (tree instanceof ConditionalExpressionTree) {
                ConditionalExpressionTree ternary = (ConditionalExpressionTree)tree;
                NullCheck nullCheck = NullnessUtils.getNullCheck(ternary.getCondition());
                if (nullCheck == null) {
                    return ImmutableSet.of();
                }
                if (child != nullCheck.nullCase(ternary)) {
                    return ImmutableSet.of();
                }
                if (nullCheck.bareIdentifier() == null) {
                    return ImmutableSet.of();
                }
                return ImmutableSet.of((Object)nullCheck.bareIdentifier());
            }
            child = tree;
        }
        return ImmutableSet.of();
    }

    static @Nullable VariableTree findDeclaration(VisitorState state, Symbol sym) {
        Tree tree;
        TreePath declPath = JavacTrees.instance(state.context).getPath(sym);
        if (declPath != null && declPath.getCompilationUnit() == state.getPath().getCompilationUnit() && (tree = declPath.getLeaf()) instanceof VariableTree) {
            VariableTree variableTree = (VariableTree)tree;
            return variableTree;
        }
        return null;
    }

    private static OnlyIfInScope applyOnlyIfAlreadyInScope(VisitorState state) {
        return state.errorProneOptions().getFlags().getEnum("Nullness:OnlyIfAnnotationAlreadyInScope", OnlyIfInScope.class).orElse(OnlyIfInScope.FALSE);
    }

    private static boolean applyRemoveSuppressWarnings(VisitorState state) {
        return state.errorProneOptions().getFlags().getBoolean("Nullness:RemoveSuppressWarnings").orElse(false);
    }

    record NullableAnnotationToUse(@Nullable String importToAdd, String use, boolean isTypeUse, boolean isAlreadyInScope) {
        static NullableAnnotationToUse annotationToBeImported(String qualifiedName, boolean isTypeUse) {
            return new NullableAnnotationToUse(qualifiedName, qualifiedName.replaceFirst(".*[.]", ""), isTypeUse, false);
        }

        static NullableAnnotationToUse annotationWithoutImporting(String name, boolean isTypeUse, boolean isAlreadyInScope) {
            return new NullableAnnotationToUse(null, name, isTypeUse, isAlreadyInScope);
        }

        final SuggestedFix fixPostfixingOnto(int position, VisitorState state, @Nullable String suppressionToRemove) {
            return this.prepareBuilder(state, suppressionToRemove).replace(position + 1, position + 1, " @" + this.use() + " ").build();
        }

        final SuggestedFix fixPostfixingOnto(Tree tree, VisitorState state, @Nullable String suppressionToRemove) {
            return this.prepareBuilder(state, suppressionToRemove).postfixWith(tree, " @" + this.use() + " ").build();
        }

        final SuggestedFix fixPrefixingOnto(Tree tree, VisitorState state, @Nullable String suppressionToRemove) {
            return this.prepareBuilder(state, suppressionToRemove).prefixWith(tree, "@" + this.use() + " ").build();
        }

        private SuggestedFix.Builder prepareBuilder(VisitorState state, @Nullable String suppressionToRemove) {
            SuggestedFix.Builder builder = SuggestedFix.builder();
            if (this.importToAdd() != null) {
                builder.addImport(this.importToAdd());
            }
            if (NullnessUtils.applyRemoveSuppressWarnings(state)) {
                SuggestedFixes.removeSuppressWarnings((SuggestedFix.Builder)builder, (VisitorState)state, (String)suppressionToRemove);
            }
            return builder;
        }
    }

    private static enum OnlyIfInScope {
        IF_NOT,
        FALSE,
        TRUE;

    }

    record NullCheck(@Nullable Name bareIdentifier, @Nullable Symbol.VarSymbol varSymbolButUsuallyPreferBareIdentifier, @Nullable Symbol.MethodSymbol methodSymbol, Polarity polarity) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean bareIdentifierMatches(ExpressionTree other) {
            if (!(other instanceof IdentifierTree)) return false;
            IdentifierTree identifierTree = (IdentifierTree)other;
            if (this.bareIdentifier() == null) return false;
            if (!this.bareIdentifier().equals(identifierTree.getName())) return false;
            return true;
        }

        ExpressionTree nullCase(ConditionalExpressionTree tree) {
            return this.polarity() == Polarity.IS_NULL ? tree.getTrueExpression() : tree.getFalseExpression();
        }

        StatementTree nullCase(IfTree tree) {
            return this.polarity() == Polarity.IS_NULL ? tree.getThenStatement() : tree.getElseStatement();
        }

        static enum Polarity {
            IS_NULL,
            IS_NOT_NULL;

        }
    }
}

