/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Apply @NullMarked to this class", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class AddNullMarkedToClass
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree unit, VisitorState state) {
        for (Tree tree : unit.getTypeDecls()) {
            ClassTree classTree;
            if (!(tree instanceof ClassTree) || ASTHelpers.hasDirectAnnotationWithSimpleName((Tree)(classTree = (ClassTree)tree), (String)"NullMarked")) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String nullMarked = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"org.jspecify.annotations.NullMarked");
            fix.prefixWith((Tree)classTree, "@" + nullMarked + " ");
            state.reportMatch(this.describeMatch(classTree, (Fix)fix.build()));
        }
        return Description.NO_MATCH;
    }
}

