/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.guice;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(name="GuiceAssistedInjectScoping", summary="Scope annotation on implementation class of AssistedInject factory is not allowed", severity=BugPattern.SeverityLevel.ERROR)
public class AssistedInjectScoping
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final MultiMatcher<ClassTree, AnnotationTree> CLASS_TO_SCOPE_ANNOTATIONS = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.symbolHasAnnotation((String)"com.google.inject.ScopeAnnotation"), Matchers.symbolHasAnnotation((String)"javax.inject.Scope")}));
    private static final MultiMatcher<ClassTree, MethodTree> CLASS_TO_INJECTED_CONSTRUCTORS = Matchers.constructor((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)InjectMatchers.hasInjectAnnotation());
    private static final Matcher<ClassTree> HAS_ASSISTED_CONSTRUCTOR = new Matcher<ClassTree>(){

        public boolean matches(ClassTree classTree, VisitorState state) {
            MultiMatcher.MultiMatchResult injectedConstructors = CLASS_TO_INJECTED_CONSTRUCTORS.multiMatchResult((Tree)classTree, state);
            if (injectedConstructors.matches()) {
                return Matchers.methodHasParameters((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasAnnotation((String)"com.google.inject.assistedinject.Assisted")).matches((Tree)((MethodTree)injectedConstructors.matchingNodes().getFirst()), state);
            }
            return Matchers.constructor((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasAnnotation((String)"com.google.inject.assistedinject.AssistedInject")).matches((Tree)classTree, state);
        }
    };

    public final Description matchClass(ClassTree classTree, VisitorState state) {
        MultiMatcher.MultiMatchResult hasScopeAnnotations = CLASS_TO_SCOPE_ANNOTATIONS.multiMatchResult((Tree)classTree, state);
        if (!hasScopeAnnotations.matches() || !HAS_ASSISTED_CONSTRUCTOR.matches((Tree)classTree, state)) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotationWithScopeAnnotation = (AnnotationTree)hasScopeAnnotations.matchingNodes().getFirst();
        if (annotationWithScopeAnnotation == null) {
            throw new IllegalStateException("Expected to find an annotation that was annotated with @ScopeAnnotation");
        }
        return this.describeMatch(annotationWithScopeAnnotation, (Fix)SuggestedFix.delete((Tree)annotationWithScopeAnnotation));
    }
}

