/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.FormatStringUtils;
import com.google.errorprone.bugpatterns.formatstring.LenientFormatStringUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.List;

@BugPattern(summary="Using a format string avoids string concatenation in the common case.", explanation="It usually hurts performance to eagerly generate error messages with +, as you pay the cost of the string conversion whether or not the condition fails. It's usually more efficient to use %s as a placeholder and to pass the additional variables as further arguments.", severity=BugPattern.SeverityLevel.WARNING)
public class FormatStringShouldUsePlaceholders
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final TreeVisitor<Void, List<ExpressionTree>> CONCATENATIONS = new SimpleTreeVisitor<Void, List<ExpressionTree>>(){

        @Override
        protected Void defaultAction(Tree tree, List<ExpressionTree> concats) {
            concats.add((ExpressionTree)tree);
            return null;
        }

        @Override
        public Void visitBinary(BinaryTree tree, List<ExpressionTree> concats) {
            if (tree.getKind() == Tree.Kind.PLUS) {
                tree.getLeftOperand().accept(this, concats);
                tree.getRightOperand().accept(this, concats);
                return null;
            }
            return (Void)super.visitBinary(tree, concats);
        }
    };

    private static ImmutableList<ExpressionTree> formatArguments(MethodInvocationTree tree, VisitorState state) {
        ImmutableList<ExpressionTree> args = FormatStringUtils.formatMethodArguments(tree, state);
        if (!args.isEmpty()) {
            return args;
        }
        int index = LenientFormatStringUtils.getLenientFormatStringPosition(tree, state);
        if (index != -1) {
            return ImmutableList.copyOf(tree.getArguments().subList(index, tree.getArguments().size()));
        }
        return ImmutableList.of();
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        int numberArgs;
        ImmutableList<ExpressionTree> arguments = FormatStringShouldUsePlaceholders.formatArguments(tree, state);
        if (arguments.isEmpty()) {
            return Description.NO_MATCH;
        }
        if (arguments.size() == 2 && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)((Tree)arguments.get(1))), (Type)((Type)Suppliers.OBJECT_TYPE_ARRAY.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree formatString = (ExpressionTree)arguments.getFirst();
        if (ASTHelpers.constValue((Tree)formatString, String.class) != null) {
            return Description.NO_MATCH;
        }
        ArrayList concats = new ArrayList();
        formatString.accept(CONCATENATIONS, concats);
        if (concats.size() <= 1) {
            return Description.NO_MATCH;
        }
        StringBuilder newMessage = new StringBuilder("\"");
        StringBuilder newArgs = new StringBuilder();
        int lastAddedArgPosition = 0;
        for (ExpressionTree concat : concats) {
            if (concat.getKind() == Tree.Kind.STRING_LITERAL) {
                String sourceString = state.getSourceForNode((Tree)concat);
                newMessage.append(sourceString.subSequence(1, sourceString.length() - 1));
                int len = sourceString.length();
                for (int i = 0; i < len; ++i) {
                    char c = sourceString.charAt(i);
                    if (c != '%' || i >= len - 1 || sourceString.charAt(++i) != 's' || lastAddedArgPosition >= arguments.size() - 1) continue;
                    newArgs.append(", ").append(state.getSourceForNode((Tree)arguments.get(++lastAddedArgPosition)));
                }
                continue;
            }
            newMessage.append("%s");
            newArgs.append(", ").append(state.getSourceForNode((Tree)concat));
        }
        if (lastAddedArgPosition < arguments.size() - 1) {
            return Description.NO_MATCH;
        }
        if (newArgs.length() == 0) {
            return Description.NO_MATCH;
        }
        int numberPercentS = newMessage.toString().split("%s", -1).length - 1;
        if (numberPercentS == (numberArgs = newArgs.toString().split(",", -1).length - 1) + 1 && newMessage.toString().endsWith("%s")) {
            newMessage.delete(newMessage.length() - 2, newMessage.length());
        } else if (numberArgs != numberPercentS) {
            return Description.NO_MATCH;
        }
        int start = ASTHelpers.getStartPosition((Tree)((Tree)arguments.getFirst()));
        int end = state.getEndPosition((Tree)arguments.getLast());
        String replacement = new StringBuilder(newMessage).append("\"").append((CharSequence)newArgs).toString();
        SuggestedFix fix = SuggestedFix.replace((int)start, (int)end, (String)replacement);
        return this.describeMatch(tree, (Fix)fix);
    }
}

