/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.FormatStringUtils;
import com.google.errorprone.bugpatterns.formatstring.FormatStringValidation;
import com.google.errorprone.bugpatterns.formatstring.StrictFormatStringValidation;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;

@BugPattern(name="FormatStringAnnotation", summary="Invalid format string passed to formatting method.", severity=BugPattern.SeverityLevel.ERROR)
public final class FormatStringAnnotationChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private Description matchInvocation(ExpressionTree tree, Symbol.MethodSymbol symbol, List<? extends ExpressionTree> args, VisitorState state) {
        ImmutableList<ExpressionTree> formatArgs = FormatStringUtils.formatMethodAnnotationArguments(tree, symbol, args, state);
        if (formatArgs.isEmpty()) {
            return Description.NO_MATCH;
        }
        FormatStringValidation.ValidationResult result = StrictFormatStringValidation.validate((ExpressionTree)formatArgs.get(0), (List<? extends ExpressionTree>)formatArgs.subList(1, formatArgs.size()), state);
        if (result != null) {
            return this.buildDescription(tree).setMessage(result.message()).build();
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.matchInvocation(tree, ASTHelpers.getSymbol((MethodInvocationTree)tree), tree.getArguments(), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.matchInvocation(tree, ASTHelpers.getSymbol((NewClassTree)tree), tree.getArguments(), state);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Type stringType = state.getSymtab().stringType;
        boolean isFormatMethod = ASTHelpers.hasAnnotation((Symbol)ASTHelpers.getSymbol((MethodTree)tree), (String)"com.google.errorprone.annotations.FormatMethod", (VisitorState)state);
        boolean foundFormatString = false;
        boolean foundString = false;
        for (VariableTree variableTree : tree.getParameters()) {
            Symbol.VarSymbol paramSymbol = ASTHelpers.getSymbol((VariableTree)variableTree);
            boolean isStringParam = ASTHelpers.isSameType((Type)paramSymbol.type, (Type)stringType, (VisitorState)state);
            if (isStringParam) {
                foundString = true;
            }
            if (!ASTHelpers.hasAnnotation((Symbol)paramSymbol, (String)"com.google.errorprone.annotations.FormatString", (VisitorState)state)) continue;
            if (!isFormatMethod) {
                return this.buildDescription(tree).setMessage("A parameter can only be annotated @FormatString in a method annotated @FormatMethod: " + state.getSourceForNode((Tree)variableTree)).build();
            }
            if (!isStringParam) {
                return this.buildDescription(variableTree).setMessage("Only strings can be annotated @FormatString.").build();
            }
            if (foundFormatString) {
                return this.buildDescription(tree).setMessage("A method cannot have more than one @FormatString parameter.").build();
            }
            foundFormatString = true;
        }
        if (isFormatMethod && !foundString) {
            return this.buildDescription(tree).setMessage("An @FormatMethod must contain at least one String parameter.").build();
        }
        return Description.NO_MATCH;
    }
}

