/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.FormatStringUtils;
import com.google.errorprone.bugpatterns.formatstring.LenientFormatStringUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This method uses a pair of parameters as a format string and its arguments, but the enclosing method wasn't annotated. Doing so gives compile-time rather than run-time protection against malformed format strings.", tags={"FragileCode"}, severity=BugPattern.SeverityLevel.WARNING)
public final class AnnotateFormatMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String REORDER = " (The parameters of this method would need to be reordered to make the format string and arguments the final parameters before the @FormatMethod annotation can be used.)";

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        FormatMethodArguments args = AnnotateFormatMethod.getFormatMethodArguments(tree, state);
        if (args == null) {
            return Description.NO_MATCH;
        }
        if (args.arguments().size() < 2) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol formatString = AnnotateFormatMethod.asSymbol((ExpressionTree)args.arguments().get(0));
        if (formatString == null) {
            return Description.NO_MATCH;
        }
        for (Tree enclosing : state.getPath()) {
            MethodTree methodTree;
            Description description;
            if (!(enclosing instanceof MethodTree) || (description = this.matchEnclosingMethod(state, methodTree = (MethodTree)enclosing, formatString, args)) == Description.NO_MATCH) continue;
            return description;
        }
        return Description.NO_MATCH;
    }

    private static @Nullable FormatMethodArguments getFormatMethodArguments(MethodInvocationTree tree, VisitorState state) {
        ImmutableList<ExpressionTree> args = FormatStringUtils.formatMethodArguments(tree, state);
        if (!args.isEmpty()) {
            return new FormatMethodArguments(false, args);
        }
        int index = LenientFormatStringUtils.getLenientFormatStringPosition(tree, state);
        if (index != -1) {
            return new FormatMethodArguments(true, (ImmutableList<ExpressionTree>)ImmutableList.copyOf(tree.getArguments().subList(index, tree.getArguments().size())));
        }
        return null;
    }

    private Description matchEnclosingMethod(VisitorState state, Tree node, Symbol.VarSymbol formatString, FormatMethodArguments args) {
        if (!(node instanceof MethodTree)) {
            return Description.NO_MATCH;
        }
        MethodTree methodTree = (MethodTree)node;
        if (ASTHelpers.hasAnnotation((Tree)methodTree, (String)"com.google.errorprone.annotations.FormatMethod", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        List<? extends VariableTree> enclosingParameters = methodTree.getParameters();
        VariableTree formatParameter = AnnotateFormatMethod.findParameterWithSymbol(enclosingParameters, formatString);
        if (formatParameter == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)formatParameter, (String)"com.google.errorprone.annotations.FormatString", (VisitorState)state) || ASTHelpers.hasAnnotation((Tree)formatParameter, (String)"com.google.errorprone.annotations.LenientFormatString", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (args.lenient()) {
            return this.handleLenient(state, (List<ExpressionTree>)args.arguments(), methodTree, formatParameter);
        }
        if (!ASTHelpers.getSymbol((MethodTree)methodTree).isVarArgs()) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol formatArgs = AnnotateFormatMethod.asSymbol((ExpressionTree)args.arguments().get(1));
        if (formatArgs == null) {
            return Description.NO_MATCH;
        }
        VariableTree argumentsParameter = AnnotateFormatMethod.findParameterWithSymbol(enclosingParameters, formatArgs);
        if (argumentsParameter == null) {
            return Description.NO_MATCH;
        }
        if (!argumentsParameter.equals(Iterables.getLast(enclosingParameters))) {
            return Description.NO_MATCH;
        }
        boolean fixable = formatParameter.equals(enclosingParameters.get(enclosingParameters.size() - 2));
        return this.buildDescription(methodTree).setMessage((String)(fixable ? this.message() : this.message() + REORDER)).build();
    }

    private Description handleLenient(VisitorState state, List<ExpressionTree> args, MethodTree methodTree, VariableTree formatParameter) {
        int formatParameterIndex = methodTree.getParameters().indexOf(formatParameter);
        if (args.size() != methodTree.getParameters().size() - formatParameterIndex) {
            return Description.NO_MATCH;
        }
        if (args.size() == 1) {
            return Description.NO_MATCH;
        }
        for (int i = 1; i < args.size(); ++i) {
            Symbol.VarSymbol vs;
            Symbol symbol = ASTHelpers.getSymbol((Tree)args.get(i));
            if (symbol instanceof Symbol.VarSymbol && (vs = (Symbol.VarSymbol)symbol).equals(ASTHelpers.getSymbol((VariableTree)methodTree.getParameters().get(formatParameterIndex + i)))) continue;
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String lenientFormatString = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.google.errorprone.annotations.LenientFormatString");
        fix.prefixWith((Tree)formatParameter, "@" + lenientFormatString + " ");
        return this.describeMatch(methodTree, (Fix)fix.build());
    }

    private static @Nullable VariableTree findParameterWithSymbol(List<? extends VariableTree> parameters, Symbol symbol) {
        return ((Optional)parameters.stream().filter(parameter -> symbol.equals(ASTHelpers.getSymbol((VariableTree)parameter))).collect(MoreCollectors.toOptional())).orElse(null);
    }

    private static @Nullable Symbol.VarSymbol asSymbol(ExpressionTree tree) {
        Symbol.VarSymbol varSymbol;
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.VarSymbol ? (varSymbol = (Symbol.VarSymbol)symbol) : null;
    }

    private record FormatMethodArguments(boolean lenient, ImmutableList<ExpressionTree> arguments) {
    }
}

