/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public final class Rules {
    static boolean returnsEnclosingType(Symbol.MethodSymbol method, VisitorState state) {
        return ASTHelpers.isSameType((Type)ASTHelpers.enclosingClass((Symbol)method).type, (Type)method.getReturnType(), (VisitorState)state);
    }

    public static ResultUseRule<VisitorState, Symbol> globalDefault(Optional<ResultUsePolicy> methodDefault, Optional<ResultUsePolicy> constructorDefault) {
        return new SimpleGlobalRule("GLOBAL_DEFAULT", methodDefault, constructorDefault);
    }

    public static ResultUseRule<VisitorState, Symbol> mapAnnotationSimpleName(String simpleName, ResultUsePolicy policy) {
        return new SimpleRule("ANNOTATION @" + simpleName, (sym, st) -> ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)sym, (String)simpleName), policy);
    }

    public static ResultUseRule<VisitorState, Symbol> mapInheritedAnnotationSimpleName(String simpleName, ResultUsePolicy policy) {
        return new SimpleRule("ANNOTATION @" + simpleName, (sym, st) -> {
            Stream stream;
            Stream[] streamArray = new Stream[2];
            streamArray[0] = Stream.of(sym);
            if (sym instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)sym;
                stream = ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)st.getTypes());
            } else {
                stream = Stream.empty();
            }
            streamArray[1] = stream;
            return Streams.concat((Stream[])streamArray).anyMatch(s -> ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)s, (String)simpleName));
        }, policy);
    }

    private Rules() {
    }

    private static final class SimpleGlobalRule
    extends ResultUseRule.GlobalRule<VisitorState, Symbol> {
        private final String id;
        private final Optional<ResultUsePolicy> methodDefault;
        private final Optional<ResultUsePolicy> constructorDefault;

        private SimpleGlobalRule(String id, Optional<ResultUsePolicy> methodDefault, Optional<ResultUsePolicy> constructorDefault) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
            this.methodDefault = methodDefault;
            this.constructorDefault = constructorDefault;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Optional<ResultUsePolicy> evaluate(Symbol symbol, VisitorState context) {
            return symbol.isConstructor() ? this.constructorDefault : this.methodDefault;
        }
    }

    private static final class SimpleRule
    extends ResultUseRule.SymbolRule<VisitorState, Symbol> {
        private final String name;
        private final BiPredicate<Symbol, VisitorState> predicate;
        private final ResultUsePolicy policy;

        private SimpleRule(String name, BiPredicate<Symbol, VisitorState> predicate, ResultUsePolicy policy) {
            this.name = name;
            this.predicate = predicate;
            this.policy = policy;
        }

        @Override
        public String id() {
            return this.name;
        }

        @Override
        public Optional<ResultUsePolicy> evaluate(Symbol symbol, VisitorState state) {
            return this.predicate.test(symbol, state) ? Optional.of(this.policy) : Optional.empty();
        }
    }

    static abstract class ErrorProneMethodRule
    extends ResultUseRule.MethodRule<VisitorState, Symbol, Symbol.MethodSymbol> {
        ErrorProneMethodRule() {
            super(Symbol.MethodSymbol.class);
        }
    }
}

