/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.names.NamingConventions;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Name;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

record Parameter(String name, Type type, int index, String text, Tree.Kind kind, boolean constant) {
    private static final ImmutableSet<String> METHODNAME_PREFIXES_TO_REMOVE = ImmutableSet.of((Object)"get", (Object)"set", (Object)"is");
    @VisibleForTesting
    static final String NAME_NULL = "*NULL*";
    @VisibleForTesting
    static final String NAME_NOT_PRESENT = "*NOT_PRESENT*";

    static ImmutableList<Parameter> createListFromVarSymbols(List<Symbol.VarSymbol> varSymbols) {
        return (ImmutableList)Streams.mapWithIndex(varSymbols.stream(), (s, i) -> new Parameter(((Name)s.getSimpleName()).toString(), (Type)s.asType(), (int)i, ((Name)s.getSimpleName()).toString(), Tree.Kind.IDENTIFIER, false)).collect(ImmutableList.toImmutableList());
    }

    static ImmutableList<Parameter> createListFromExpressionTrees(List<? extends Tree> trees) {
        return (ImmutableList)Streams.mapWithIndex(trees.stream(), (t, i) -> {
            Type type;
            String string = Parameter.getArgumentName(t);
            if (t instanceof ExpressionTree) {
                ExpressionTree expressionTree = (ExpressionTree)t;
                type = ASTHelpers.getResultType((ExpressionTree)expressionTree);
            } else {
                type = ASTHelpers.getType((Tree)t);
            }
            return new Parameter(string, Optional.ofNullable(type).orElse(Type.noType), (int)i, t.toString(), t.getKind(), ASTHelpers.constValue((Tree)t) != null);
        }).collect(ImmutableList.toImmutableList());
    }

    static ImmutableList<Parameter> createListFromVariableTrees(List<? extends VariableTree> trees) {
        return Parameter.createListFromVarSymbols((List)trees.stream().map(ASTHelpers::getSymbol).collect(ImmutableList.toImmutableList()));
    }

    boolean isAssignableTo(Parameter target, VisitorState state) {
        if (state.getTypes().isSameType(this.type(), Type.noType) || state.getTypes().isSameType(target.type(), Type.noType)) {
            return false;
        }
        try {
            return state.getTypes().isAssignable(this.type(), target.type());
        }
        catch (Symbol.CompletionFailure e) {
            Check.instance(state.context).completionError((JCDiagnostic.DiagnosticPosition)((Object)state.getPath().getLeaf()), e);
            return false;
        }
    }

    boolean isNullLiteral() {
        return this.name().equals(NAME_NULL);
    }

    boolean isUnknownName() {
        return this.name().equals(NAME_NOT_PRESENT);
    }

    private static String getClassName(Symbol.ClassSymbol s) {
        if (s.isAnonymous()) {
            return ((Name)s.getSuperclass().tsym.getSimpleName()).toString();
        }
        return s.getSimpleName().toString();
    }

    @VisibleForTesting
    static String getArgumentName(Tree tree) {
        String string;
        Tree tree2 = tree;
        Objects.requireNonNull(tree2);
        Tree tree3 = tree2;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableTree.class, MemberSelectTree.class, LiteralTree.class, IdentifierTree.class, MethodInvocationTree.class, NewClassTree.class}, (Object)tree3, n)) {
                case 0: {
                    VariableTree variableTree = (VariableTree)tree3;
                    string = variableTree.getName().toString();
                    break block8;
                }
                case 1: {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)tree3;
                    string = memberSelectTree.getIdentifier().toString();
                    break block8;
                }
                case 2: {
                    LiteralTree literalTree = (LiteralTree)tree3;
                    if (!tree.getKind().equals((Object)Tree.Kind.NULL_LITERAL)) {
                        n = 3;
                        continue block8;
                    }
                    string = NAME_NULL;
                    break block8;
                }
                case 3: {
                    IdentifierTree identifierTree = (IdentifierTree)tree3;
                    IdentifierTree idTree = (IdentifierTree)tree;
                    if (idTree.getName().contentEquals("this")) {
                        Symbol sym = ASTHelpers.getSymbol((Tree)idTree);
                        if (sym != null) {
                            string = Parameter.getClassName(ASTHelpers.enclosingClass((Symbol)sym));
                            break block8;
                        }
                        string = NAME_NOT_PRESENT;
                        break block8;
                    }
                    string = idTree.getName().toString();
                    break block8;
                }
                case 4: {
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree3;
                    Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree);
                    String name = ((Name)methodSym.getSimpleName()).toString();
                    ImmutableList terms = NamingConventions.splitToLowercaseTerms((String)name);
                    String firstTerm = (String)Iterables.getFirst((Iterable)terms, null);
                    if (METHODNAME_PREFIXES_TO_REMOVE.contains((Object)firstTerm)) {
                        if (terms.size() == 1) {
                            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
                            if (receiver == null) {
                                string = Parameter.getClassName(ASTHelpers.enclosingClass((Symbol)methodSym));
                                break block8;
                            }
                            string = Parameter.getArgumentName(receiver);
                            break block8;
                        }
                        string = name.substring(firstTerm.length());
                        break block8;
                    }
                    string = name;
                    break block8;
                }
                case 5: {
                    NewClassTree newClassTree = (NewClassTree)tree3;
                    Symbol.MethodSymbol constructorSym = ASTHelpers.getSymbol((NewClassTree)newClassTree);
                    if (constructorSym.owner != null) {
                        string = Parameter.getClassName((Symbol.ClassSymbol)constructorSym.owner);
                        break block8;
                    }
                    string = NAME_NOT_PRESENT;
                    break block8;
                }
                default: {
                    string = NAME_NOT_PRESENT;
                    break block8;
                }
            }
            break;
        }
        return string;
    }
}

