/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NamedParameterComment;
import com.google.errorprone.util.Commented;
import com.google.errorprone.util.Comments;
import com.sun.source.tree.DeconstructionPatternTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

final class NameInCommentHeuristic
implements Heuristic {
    NameInCommentHeuristic() {
    }

    @Override
    public boolean isAcceptableChange(Changes changes, Tree node, Symbol.MethodSymbol symbol, VisitorState state) {
        ImmutableList<Commented> comments = NameInCommentHeuristic.findCommentsForArguments(node, state);
        return changes.changedPairs().stream().noneMatch(p -> {
            NamedParameterComment.MatchType match = NamedParameterComment.match((Commented)comments.get(p.formal().index()), p.formal().name()).matchType();
            return match == NamedParameterComment.MatchType.EXACT_MATCH || match == NamedParameterComment.MatchType.APPROXIMATE_MATCH;
        });
    }

    private static ImmutableList<Commented> findCommentsForArguments(Tree tree, VisitorState state) {
        Tree tree2 = tree;
        Objects.requireNonNull(tree2);
        Tree tree3 = tree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodInvocationTree.class, NewClassTree.class, DeconstructionPatternTree.class}, (Object)tree3, n)) {
            case 0 -> {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree3;
                yield Comments.findCommentsForArguments((MethodInvocationTree)methodInvocationTree, (VisitorState)state);
            }
            case 1 -> {
                NewClassTree newClassTree = (NewClassTree)tree3;
                yield Comments.findCommentsForArguments((NewClassTree)newClassTree, (VisitorState)state);
            }
            case 2 -> {
                DeconstructionPatternTree deconstructionPatternTree = (DeconstructionPatternTree)tree3;
                yield Comments.findCommentsForArguments((DeconstructionPatternTree)deconstructionPatternTree, (VisitorState)state);
            }
            default -> throw new IllegalArgumentException("Only MethodInvocationTree or NewClassTree is supported, saw " + String.valueOf(tree.getClass()));
        };
    }
}

