/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ArgumentChangeFinder;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.CreatesDuplicateCallHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.EnclosedByReverseHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.InvocationInfo;
import com.google.errorprone.bugpatterns.argumentselectiondefects.LowInformationNameHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Matchers;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NameInCommentHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import com.google.errorprone.bugpatterns.argumentselectiondefects.PenaltyThresholdHeuristic;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.names.NamingConventions;
import com.google.errorprone.names.NeedlemanWunschEditDistance;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.DeconstructionPatternTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="Arguments are in the wrong order or could be commented for clarity.", severity=BugPattern.SeverityLevel.WARNING)
public class ArgumentSelectionDefectChecker
extends BugChecker
implements BugChecker.DeconstructionPatternTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private final ArgumentChangeFinder argumentChangeFinder;

    public ArgumentSelectionDefectChecker() {
        this(ArgumentChangeFinder.builder().setDistanceFunction(ArgumentSelectionDefectChecker::defaultDistanceFunction).addHeuristic(new LowInformationNameHeuristic()).addHeuristic(new PenaltyThresholdHeuristic()).addHeuristic(new EnclosedByReverseHeuristic()).addHeuristic(new CreatesDuplicateCallHeuristic()).addHeuristic(new NameInCommentHeuristic()).build());
    }

    @VisibleForTesting
    ArgumentSelectionDefectChecker(ArgumentChangeFinder argumentChangeFinder) {
        this.argumentChangeFinder = argumentChangeFinder;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (Matchers.ASSERT_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.visit(InvocationInfo.createFromMethodInvocation(tree, symbol, state));
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((NewClassTree)tree);
        if (Matchers.isAutoValueConstructor(tree)) {
            return Description.NO_MATCH;
        }
        return this.visit(InvocationInfo.createFromNewClass(tree, symbol, state));
    }

    public Description matchDeconstructionPattern(DeconstructionPatternTree tree, VisitorState state) {
        InvocationInfo deconstructor = InvocationInfo.createFromDeconstructionPattern(tree, state);
        return deconstructor == null ? Description.NO_MATCH : this.visit(deconstructor);
    }

    private Description visit(InvocationInfo invocationInfo) {
        Changes changes = this.argumentChangeFinder.findChanges(invocationInfo);
        if (changes.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(invocationInfo.tree()).setMessage(changes.describe(invocationInfo)).addFix((Fix)changes.buildCommentArgumentsFix(invocationInfo)).addFix((Fix)changes.buildPermuteArgumentsFix(invocationInfo)).build();
    }

    private static double defaultDistanceFunction(ParameterPair pair) {
        if (pair.formal().isNullLiteral() || pair.actual().isNullLiteral()) {
            return 0.0;
        }
        if (!pair.formal().isUnknownName() && !pair.actual().isUnknownName()) {
            String normalizedSource = NamingConventions.convertToLowerUnderscore((String)pair.formal().name());
            String normalizedTarget = NamingConventions.convertToLowerUnderscore((String)pair.actual().name());
            return NeedlemanWunschEditDistance.getNormalizedEditDistance((String)normalizedSource, (String)normalizedTarget, (boolean)false, (int)8, (int)8, (int)1);
        }
        return pair.formal().index() == pair.actual().index() ? 0.0 : Double.POSITIVE_INFINITY;
    }
}

