/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.apidiff;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffProto;
import java.util.Set;

public record ApiDiff(ImmutableSet<String> unsupportedClasses, ImmutableSetMultimap<String, ClassMemberKey> unsupportedMembersByClass) {
    boolean isClassUnsupported(String className) {
        return this.unsupportedClasses().contains((Object)className);
    }

    boolean isMemberUnsupported(String className, ClassMemberKey memberKey) {
        return this.unsupportedMembersByClass().containsEntry((Object)className, (Object)memberKey) || this.unsupportedMembersByClass().containsEntry((Object)className, (Object)ClassMemberKey.create(memberKey.identifier(), ""));
    }

    public static ApiDiff fromMembers(Set<String> unsupportedClasses, Multimap<String, ClassMemberKey> unsupportedMembersByClass) {
        return new ApiDiff((ImmutableSet<String>)ImmutableSet.copyOf(unsupportedClasses), (ImmutableSetMultimap<String, ClassMemberKey>)ImmutableSetMultimap.copyOf(unsupportedMembersByClass));
    }

    public static ApiDiff fromProto(ApiDiffProto.Diff diff) {
        ImmutableSet.Builder unsupportedClasses = ImmutableSet.builder();
        ImmutableSetMultimap.Builder unsupportedMembersByClass = ImmutableSetMultimap.builder();
        block4: for (ApiDiffProto.ClassDiff c : diff.getClassDiffList()) {
            switch (c.getDiffCase()) {
                case EVERYTHING_DIFF: {
                    unsupportedClasses.add((Object)c.getEverythingDiff().getClassName());
                    break;
                }
                case MEMBER_DIFF: {
                    ApiDiffProto.MemberDiff memberDiff = c.getMemberDiff();
                    for (ApiDiffProto.ClassMember member : memberDiff.getMemberList()) {
                        unsupportedMembersByClass.put((Object)memberDiff.getClassName(), (Object)ClassMemberKey.create(member.getIdentifier(), member.getMemberDescriptor()));
                    }
                    continue block4;
                }
                default: {
                    throw new AssertionError((Object)c.getDiffCase());
                }
            }
        }
        return new ApiDiff((ImmutableSet<String>)unsupportedClasses.build(), (ImmutableSetMultimap<String, ClassMemberKey>)unsupportedMembersByClass.build());
    }

    public ApiDiffProto.Diff toProto() {
        ApiDiffProto.Diff.Builder builder = ApiDiffProto.Diff.newBuilder();
        for (String className : this.unsupportedClasses()) {
            builder.addClassDiff(ApiDiffProto.ClassDiff.newBuilder().setEverythingDiff(ApiDiffProto.EverythingDiff.newBuilder().setClassName(className)));
        }
        for (String className : this.unsupportedMembersByClass().keySet()) {
            ApiDiffProto.MemberDiff.Builder memberDiff = ApiDiffProto.MemberDiff.newBuilder().setClassName(className);
            for (ClassMemberKey member : this.unsupportedMembersByClass().get((Object)className)) {
                memberDiff.addMember(ApiDiffProto.ClassMember.newBuilder().setIdentifier(member.identifier()).setMemberDescriptor(member.descriptor()));
            }
            builder.addClassDiff(ApiDiffProto.ClassDiff.newBuilder().setMemberDiff(memberDiff));
        }
        return builder.build();
    }

    public record ClassMemberKey(String identifier, String descriptor) {
        public static ClassMemberKey create(String identifier, String descriptor) {
            return new ClassMemberKey(identifier, descriptor);
        }

        @Override
        public final String toString() {
            return String.format("%s:%s", this.identifier(), this.descriptor());
        }
    }
}

