/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Converting a long or Long to an int to pass as a long parameter is usually not necessary. If this conversion is intentional, consider `Longs.constrainToRange()` instead.", severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryLongToIntConversion
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> LONG_TO_INT_STATIC_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.primitives.Ints").namedAnyOf(new String[]{"checkedCast", "saturatedCast"}), MethodMatchers.staticMethod().onClass("java.lang.Math").named("toIntExact")});
    private static final Matcher<ExpressionTree> LONG_TO_INT_INSTANCE_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass(Suppliers.JAVA_LANG_LONG_TYPE).named("intValue")});
    private static final Matcher<ExpressionTree> IS_LONG_TYPE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType((Supplier)Suppliers.LONG_TYPE), Matchers.isSameType((Supplier)Suppliers.JAVA_LANG_LONG_TYPE)});
    private static final Matcher<ExpressionTree> LONG_TO_INT_STATIC_METHOD_ON_LONG_VALUE_MATCHER = Matchers.methodInvocation(LONG_TO_INT_STATIC_METHODS, (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.ALL, IS_LONG_TYPE);
    private static final Matcher<ExpressionTree> LONG_TO_INT_INSTANCE_METHOD_ON_LONG_VALUE_MATCHER = Matchers.methodInvocation(LONG_TO_INT_INSTANCE_METHODS, (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.ALL, IS_LONG_TYPE);
    private static final Matcher<TypeCastTree> LONG_TO_INT_CAST = Matchers.typeCast((Matcher)Matchers.isSameType((Supplier)Suppliers.INT_TYPE), (Matcher)Matchers.isSameType((Supplier)Suppliers.LONG_TYPE));
    private static final String LONGS_CONSTRAIN_TO_RANGE_PREFIX = "Longs.constrainToRange(";
    private static final String LONGS_CONSTRAIN_TO_RANGE_SUFFIX = ", Integer.MIN_VALUE, Integer.MAX_VALUE)";
    private static final String LONGS_CONSTRAIN_TO_RANGE_IMPORT = "com.google.common.primitives.Longs";

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        for (ExpressionTree expressionTree : tree.getArguments()) {
            TypeCastTree typeCastTree;
            TargetType targetType;
            if (!ASTHelpers.getType((Tree)expressionTree).getKind().equals((Object)TypeKind.INT) || (targetType = TargetType.targetType((VisitorState)state.withPath(new TreePath(state.getPath(), expressionTree)))) == null || !targetType.type().getKind().equals((Object)TypeKind.LONG)) continue;
            if (expressionTree instanceof TypeCastTree && LONG_TO_INT_CAST.matches((Tree)(typeCastTree = (TypeCastTree)expressionTree), state)) {
                ExpressionTree castedExpression = typeCastTree.getExpression();
                return this.buildDescription(tree).addFix((Fix)SuggestedFix.replace((Tree)expressionTree, (String)state.getSourceForNode((Tree)castedExpression))).addFix((Fix)SuggestedFix.builder().replace((Tree)expressionTree, LONGS_CONSTRAIN_TO_RANGE_PREFIX + state.getSourceForNode((Tree)castedExpression) + LONGS_CONSTRAIN_TO_RANGE_SUFFIX).addImport(LONGS_CONSTRAIN_TO_RANGE_IMPORT).build()).build();
            }
            if (LONG_TO_INT_STATIC_METHOD_ON_LONG_VALUE_MATCHER.matches((Tree)expressionTree, state)) {
                ExpressionTree methodArgExpression = ((MethodInvocationTree)expressionTree).getArguments().getFirst();
                String methodArg = state.getSourceForNode((Tree)methodArgExpression);
                return this.buildDescription(tree).addFix((Fix)SuggestedFix.replace((Tree)expressionTree, (String)methodArg)).addFix((Fix)SuggestedFix.builder().replace((Tree)expressionTree, LONGS_CONSTRAIN_TO_RANGE_PREFIX + methodArg + LONGS_CONSTRAIN_TO_RANGE_SUFFIX).addImport(LONGS_CONSTRAIN_TO_RANGE_IMPORT).build()).build();
            }
            if (!LONG_TO_INT_INSTANCE_METHOD_ON_LONG_VALUE_MATCHER.matches((Tree)expressionTree, state)) continue;
            String receiver = state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)expressionTree));
            return this.buildDescription(tree).addFix((Fix)SuggestedFix.replace((Tree)expressionTree, (String)receiver)).addFix((Fix)SuggestedFix.builder().replace((Tree)expressionTree, LONGS_CONSTRAIN_TO_RANGE_PREFIX + receiver + LONGS_CONSTRAIN_TO_RANGE_SUFFIX).addImport(LONGS_CONSTRAIN_TO_RANGE_IMPORT).build()).build();
        }
        return Description.NO_MATCH;
    }
}

