/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.HashMap;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="This collection is already immutable (just not ImmutableList/ImmutableMap); copying it is unnecessary.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnnecessaryCopy
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> IMMUTABLE_COPY = Matchers.staticMethod().onClassAny(new String[]{"com.google.common.collect.ImmutableList", "com.google.common.collect.ImmutableMap"}).named("copyOf");
    private static final Matcher<ExpressionTree> PROTO_GETTER = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite");
    private static final Supplier<Type> MAP_TYPE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.util.Map"));

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final HashMap suspiciousVariables = new HashMap();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ UnnecessaryCopy this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitMethodInvocation(MethodInvocationTree mit, Void unused) {
                if (IMMUTABLE_COPY.matches((Tree)mit, this.state) && mit.getArguments().size() == 1 && PROTO_GETTER.matches((Tree)((ExpressionTree)Iterables.getOnlyElement(mit.getArguments())), this.state)) {
                    TargetType targetType = TargetType.targetType((VisitorState)this.state.withPath(this.getCurrentPath()));
                    if (targetType != null && UnnecessaryCopy.isSuperType(targetType.type(), this.state)) {
                        this.state.reportMatch(this.this$0.describe(mit, this.state));
                    } else {
                        VariableTree vt;
                        Tree tree = this.getCurrentPath().getParentPath().getLeaf();
                        if (tree instanceof VariableTree && (vt = (VariableTree)tree).getInitializer() == mit && ASTHelpers.getSymbol((VariableTree)vt).getKind().equals((Object)ElementKind.LOCAL_VARIABLE)) {
                            suspiciousVariables.put(ASTHelpers.getSymbol((VariableTree)vt), new Offender(vt, mit));
                        }
                    }
                }
                return (Void)super.visitMethodInvocation(mit, null);
            }
        }.scan((Tree)tree, null);
        new TreePathScanner<Void, Void>(this){

            @Override
            public Void visitIdentifier(IdentifierTree id, Void unused) {
                TargetType targetType;
                Symbol symbol = ASTHelpers.getSymbol((Tree)id);
                if (suspiciousVariables.containsKey(symbol) && (targetType = TargetType.targetType((VisitorState)state.withPath(this.getCurrentPath()))) != null && !UnnecessaryCopy.isSuperType(targetType.type(), state)) {
                    suspiciousVariables.remove(symbol);
                }
                return (Void)super.visitIdentifier(id, null);
            }
        }.scan(tree, null);
        for (Offender offender : suspiciousVariables.values()) {
            state.reportMatch(this.describe(offender.variableTree, offender.methodInvocationTree, state));
        }
        return Description.NO_MATCH;
    }

    private static boolean isSuperType(Type type, VisitorState state) {
        Type erased = state.getTypes().erasure(type);
        return state.getTypes().isSuperType(erased, state.getSymtab().listType) || state.getTypes().isSuperType(erased, (Type)MAP_TYPE.get(state));
    }

    private Description describe(MethodInvocationTree tree, VisitorState state) {
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)tree.getArguments().getFirst())));
    }

    private Description describe(VariableTree variableTree, MethodInvocationTree tree, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder().replace((Tree)tree, state.getSourceForNode((Tree)tree.getArguments().getFirst()));
        if (!ASTHelpers.hasImplicitType((VariableTree)variableTree, (VisitorState)state)) {
            String simpleName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)UnnecessaryCopy.replacementTypeName(variableTree, state));
            Tree tree2 = variableTree.getType();
            if (tree2 instanceof ParameterizedTypeTree) {
                ParameterizedTypeTree ptt = (ParameterizedTypeTree)tree2;
                fix.replace(ptt.getType(), simpleName);
            } else {
                fix.replace(variableTree.getType(), simpleName);
            }
        }
        return this.describeMatch(tree, (Fix)fix.build());
    }

    private static String replacementTypeName(VariableTree variableTree, VisitorState state) {
        if (ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)variableTree.getType()), (Type)state.getSymtab().listType, (VisitorState)state)) {
            return "java.util.List";
        }
        if (ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)variableTree.getType()), (Type)((Type)MAP_TYPE.get(state)), (VisitorState)state)) {
            return "java.util.Map";
        }
        throw new AssertionError((Object)"Unknown type");
    }

    private record Offender(VariableTree variableTree, MethodInvocationTree methodInvocationTree) {
    }
}

