/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Variables which are initialized and do not escape the current scope do not need to worry about concurrency. Using the non-concurrent type will reduce overhead and verbosity.")
public final class UnnecessaryAsync
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> NEW_SYNCHRONIZED_THING = Matchers.anyOf((Iterable)((Iterable)Stream.of("java.util.concurrent.atomic.AtomicBoolean", "java.util.concurrent.atomic.AtomicReference", "java.util.concurrent.atomic.AtomicInteger", "java.util.concurrent.atomic.AtomicLong", "java.util.concurrent.ConcurrentHashMap").map(x -> Matchers.constructor().forClass(x)).collect(ImmutableList.toImmutableList())));

    public Description matchVariable(VariableTree tree, VisitorState state) {
        final Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (!symbol.getKind().equals((Object)ElementKind.LOCAL_VARIABLE) || !ASTHelpers.isConsideredFinal((Symbol)symbol)) {
            return Description.NO_MATCH;
        }
        ExpressionTree initializer = tree.getInitializer();
        if (initializer == null || !NEW_SYNCHRONIZED_THING.matches((Tree)initializer, state)) {
            return Description.NO_MATCH;
        }
        final AtomicBoolean escapes = new AtomicBoolean(false);
        new TreePathScanner<Void, Void>(this){
            int lambdaDepth = 0;

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                ++this.lambdaDepth;
                Void ret = (Void)super.visitMethod(tree, null);
                --this.lambdaDepth;
                return null;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree tree, Void unused) {
                ++this.lambdaDepth;
                Void ret = (Void)super.visitLambdaExpression(tree, null);
                --this.lambdaDepth;
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (!ASTHelpers.getSymbol((Tree)tree).equals(symbol)) {
                    return (Void)super.visitIdentifier(tree, null);
                }
                if (this.lambdaDepth > 0) {
                    escapes.set(true);
                    return (Void)super.visitIdentifier(tree, null);
                }
                Tree parentTree = this.getCurrentPath().getParentPath().getLeaf();
                if (this.isVariableDeclarationItself(parentTree) || parentTree instanceof MemberSelectTree) {
                    return (Void)super.visitIdentifier(tree, null);
                }
                escapes.set(true);
                return (Void)super.visitIdentifier(tree, null);
            }

            private boolean isVariableDeclarationItself(Tree parentTree) {
                return parentTree instanceof VariableTree && ASTHelpers.getSymbol((Tree)parentTree).equals(symbol);
            }
        }.scan(state.getPath().getParentPath(), (Void)null);
        return escapes.get() ? Description.NO_MATCH : this.describeMatch(tree, (Fix)this.attemptFix(tree, state));
    }

    private SuggestedFix attemptFix(VariableTree tree, final VisitorState state) {
        final Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (!symbol.type.toString().startsWith("java.util.concurrent.atomic")) {
            return SuggestedFix.emptyFix();
        }
        final AtomicBoolean fixable = new AtomicBoolean(true);
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        NewClassTree constructor = (NewClassTree)tree.getInitializer();
        fix.replace((Tree)tree, String.format("%s %s = %s;", UnnecessaryAsync.getPrimitiveType(symbol.type, state.getTypes()), symbol.getSimpleName(), constructor.getArguments().isEmpty() ? UnnecessaryAsync.getDefaultInitializer(symbol, state.getTypes()) : state.getSourceForNode((Tree)constructor.getArguments().get(0))));
        new TreePathScanner<Void, Void>(this){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (!ASTHelpers.getSymbol((Tree)tree).equals(symbol)) {
                    return (Void)super.visitIdentifier(tree, null);
                }
                Tree parentTree = this.getCurrentPath().getParentPath().getLeaf();
                if (this.isVariableDeclarationItself(parentTree)) {
                    return (Void)super.visitIdentifier(tree, null);
                }
                if (parentTree instanceof MemberSelectTree) {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)parentTree;
                    MethodInvocationTree grandparent = (MethodInvocationTree)this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                    String methodName = memberSelectTree.getIdentifier().toString();
                    int receiverEndPos = state.getEndPosition((Tree)memberSelectTree.getExpression());
                    int endPos = state.getEndPosition((Tree)grandparent);
                    switch (methodName) {
                        case "set": {
                            ExpressionTree arg = grandparent.getArguments().getFirst();
                            fix.replace(receiverEndPos, ASTHelpers.getStartPosition((Tree)arg), " = ").replace(state.getEndPosition((Tree)arg), endPos, "");
                            break;
                        }
                        case "get": {
                            fix.replace(receiverEndPos, endPos, "");
                            break;
                        }
                        case "getAndIncrement": {
                            fix.replace(receiverEndPos, endPos, "++");
                            break;
                        }
                        case "getAndDecrement": {
                            fix.replace(receiverEndPos, endPos, "--");
                            break;
                        }
                        case "incrementAndGet": {
                            fix.prefixWith((Tree)memberSelectTree, "++").replace(receiverEndPos, endPos, "");
                            break;
                        }
                        case "decrementAndGet": {
                            fix.prefixWith((Tree)memberSelectTree, "--").replace(receiverEndPos, endPos, "");
                            break;
                        }
                        case "compareAndSet": {
                            ExpressionTree arg = grandparent.getArguments().get(1);
                            fix.replace(receiverEndPos, ASTHelpers.getStartPosition((Tree)arg), " = ").replace(state.getEndPosition((Tree)arg), endPos, "");
                            break;
                        }
                        case "addAndGet": {
                            ExpressionTree arg = (ExpressionTree)Iterables.getOnlyElement(grandparent.getArguments());
                            fix.replace(receiverEndPos, ASTHelpers.getStartPosition((Tree)arg), " += ").replace(state.getEndPosition((Tree)arg), endPos, "");
                            break;
                        }
                        default: {
                            fixable.set(false);
                            break;
                        }
                    }
                } else {
                    fixable.set(false);
                }
                return (Void)super.visitIdentifier(tree, null);
            }

            private boolean isVariableDeclarationItself(Tree parentTree) {
                return parentTree instanceof VariableTree && ASTHelpers.getSymbol((Tree)parentTree).equals(symbol);
            }
        }.scan(state.getPath().getParentPath(), (Void)null);
        return fixable.get() ? fix.build() : SuggestedFix.emptyFix();
    }

    private static String getPrimitiveType(Type type, Types types) {
        String name;
        return switch (name = types.erasure(type).toString()) {
            case "java.util.concurrent.atomic.AtomicBoolean" -> "boolean";
            case "java.util.concurrent.atomic.AtomicReference" -> {
                if (type.allparams().isEmpty()) {
                    yield "Object";
                }
                yield ((Name)type.allparams().get((int)0).tsym.getSimpleName()).toString();
            }
            case "java.util.concurrent.atomic.AtomicInteger" -> "int";
            case "java.util.concurrent.atomic.AtomicLong" -> "long";
            default -> throw new AssertionError((Object)name);
        };
    }

    private static String getDefaultInitializer(Symbol.VarSymbol symbol, Types types) {
        String name;
        return switch (name = types.erasure(symbol.type).toString()) {
            case "java.util.concurrent.atomic.AtomicBoolean" -> "false";
            case "java.util.concurrent.atomic.AtomicReference" -> "null";
            case "java.util.concurrent.atomic.AtomicInteger", "java.util.concurrent.atomic.AtomicLong" -> "0";
            default -> throw new AssertionError((Object)name);
        };
    }
}

