/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.FieldMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Production code should not print to standard out or standard error. Standard out and standard error should only be used for debugging.", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public final class SystemOut
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberSelectTreeMatcher {
    private static final Matcher<ExpressionTree> BAD_FIELDS = Matchers.anyOf((Matcher[])new Matcher[]{FieldMatchers.staticField((String)System.class.getName(), (String)"out"), FieldMatchers.staticField((String)System.class.getName(), (String)"err")});
    private static final Matcher<ExpressionTree> BAD_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.lang.IO").namedAnyOf(new String[]{"print", "println"}), Matchers.staticMethod().onClass(Thread.class.getName()).named("dumpStack").withNoParameters(), Matchers.instanceMethod().onDescendantOf(Throwable.class.getName()).named("printStackTrace").withNoParameters()});

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return BAD_FIELDS.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return BAD_METHODS.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

