/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.Reachability;
import com.google.errorprone.util.SourceVersion;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.PatternCaseLabelTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.util.Context;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.IntersectionType;
import org.jspecify.annotations.Nullable;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This statement switch can be converted to a new-style arrow switch")
public final class StatementSwitchToExpressionSwitch
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    private static final ImmutableSet<Tree.Kind> KINDS_CONVERTIBLE_WITHOUT_BRACES = ImmutableSet.of((Object)((Object)Tree.Kind.THROW), (Object)((Object)Tree.Kind.EXPRESSION_STATEMENT));
    private static final ImmutableSet<Tree.Kind> KINDS_RETURN_OR_THROW = ImmutableSet.of((Object)((Object)Tree.Kind.THROW), (Object)((Object)Tree.Kind.RETURN));
    private static final Pattern FALL_THROUGH_PATTERN = Pattern.compile("\\bfalls?.?(through|out)\\b", 2);
    private static final AssignmentSwitchAnalysisResult DEFAULT_ASSIGNMENT_SWITCH_ANALYSIS_RESULT = new AssignmentSwitchAnalysisResult(false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final AnalysisResult DEFAULT_ANALYSIS_RESULT = new AnalysisResult(false, false, false, DEFAULT_ASSIGNMENT_SWITCH_ANALYSIS_RESULT, (ImmutableList<Boolean>)ImmutableList.of(), (ImmutableBiMap<Symbol.VarSymbol, VariableTree>)ImmutableBiMap.of());
    private static final String EQUALS_STRING = "=";
    private static final Matcher<ExpressionTree> COMPILE_TIME_CONSTANT_MATCHER = CompileTimeConstantExpressionMatcher.instance();
    private static final String REMOVE_DEFAULT_CASE_SHORT_DESCRIPTION = "Remove default case because all enum values handled";
    private final boolean enableDirectConversion;
    private final boolean enableReturnSwitchConversion;
    private final boolean enableAssignmentSwitchConversion;

    @Inject
    StatementSwitchToExpressionSwitch(ErrorProneFlags flags) {
        this.enableDirectConversion = flags.getBoolean("StatementSwitchToExpressionSwitch:EnableDirectConversion").orElse(true);
        this.enableReturnSwitchConversion = flags.getBoolean("StatementSwitchToExpressionSwitch:EnableReturnSwitchConversion").orElse(true);
        this.enableAssignmentSwitchConversion = flags.getBoolean("StatementSwitchToExpressionSwitch:EnableAssignmentSwitchConversion").orElse(true);
    }

    public Description matchSwitch(SwitchTree switchTree, VisitorState state) {
        if (!SourceVersion.supportsSwitchExpressions((Context)state.context)) {
            return Description.NO_MATCH;
        }
        if (switchTree.getCases().isEmpty()) {
            return Description.NO_MATCH;
        }
        AnalysisResult analysisResult = StatementSwitchToExpressionSwitch.analyzeSwitchTree(switchTree, state);
        ArrayList<SuggestedFix> suggestedFixes = new ArrayList<SuggestedFix>();
        if (this.enableReturnSwitchConversion && analysisResult.canConvertToReturnSwitch()) {
            suggestedFixes.add(StatementSwitchToExpressionSwitch.convertToReturnSwitch(switchTree, state, analysisResult, false));
            if (analysisResult.canRemoveDefault()) {
                suggestedFixes.add(StatementSwitchToExpressionSwitch.convertToReturnSwitch(switchTree, state, analysisResult, true));
            }
        }
        if (this.enableAssignmentSwitchConversion && analysisResult.assignmentSwitchAnalysisResult().canConvertToAssignmentSwitch()) {
            suggestedFixes.add(StatementSwitchToExpressionSwitch.convertToAssignmentSwitch(switchTree, state, analysisResult, false));
            if (analysisResult.canRemoveDefault()) {
                suggestedFixes.add(StatementSwitchToExpressionSwitch.convertToAssignmentSwitch(switchTree, state, analysisResult, true));
            }
        }
        if (this.enableDirectConversion && analysisResult.canConvertDirectlyToExpressionSwitch()) {
            suggestedFixes.add(StatementSwitchToExpressionSwitch.convertDirectlyToExpressionSwitch(switchTree, state, analysisResult, false));
            if (analysisResult.canRemoveDefault()) {
                suggestedFixes.add(StatementSwitchToExpressionSwitch.convertDirectlyToExpressionSwitch(switchTree, state, analysisResult, true));
            }
        }
        return suggestedFixes.isEmpty() ? Description.NO_MATCH : this.buildDescription(switchTree).addAllFixes(suggestedFixes).build();
    }

    private static BiMap<Symbol.VarSymbol, VariableTree> extractSymbolsDefinedInStatementBlock(List<? extends StatementTree> statements) {
        HashBiMap symbolsDefinedInStatementBlock = HashBiMap.create();
        if (statements == null) {
            return symbolsDefinedInStatementBlock;
        }
        for (StatementTree statementTree : statements) {
            VariableTree variableTree;
            Symbol.VarSymbol symbol;
            if (!(statementTree instanceof VariableTree) || (symbol = ASTHelpers.getSymbol((VariableTree)(variableTree = (VariableTree)statementTree))) == null) continue;
            symbolsDefinedInStatementBlock.put((Object)symbol, (Object)variableTree);
        }
        return symbolsDefinedInStatementBlock;
    }

    private static AnalysisResult analyzeSwitchTree(SwitchTree switchTree, VisitorState state) {
        if (ASTHelpers.findEnclosingNode((TreePath)state.getPath(), SwitchTree.class) != null) {
            return DEFAULT_ANALYSIS_RESULT;
        }
        HashBiMap symbolsDefinedInPreviousCases = HashBiMap.create();
        HashBiMap symbolsToHoist = HashBiMap.create();
        List<? extends CaseTree> cases = switchTree.getCases();
        boolean allCasesHaveDefiniteControlFlow = true;
        ArrayList<Boolean> groupedWithNextCase = new ArrayList<Boolean>(Collections.nCopies(cases.size(), false));
        ArrayList<Boolean> isNullCase = new ArrayList<Boolean>(Collections.nCopies(cases.size(), false));
        HashSet<String> handledEnumValues = new HashSet<String>();
        CaseQualifications returnSwitchCaseQualifications = CaseQualifications.NO_CASES_ASSESSED;
        Optional<ExpressionTree> assignmentTargetOptional = Optional.empty();
        Optional<Tree.Kind> assignmentKindOptional = Optional.empty();
        AssignmentSwitchAnalysisState assignmentSwitchAnalysisState = new AssignmentSwitchAnalysisState(CaseQualifications.NO_CASES_ASSESSED, assignmentTargetOptional, assignmentKindOptional, Optional.empty());
        boolean hasDefaultCase = false;
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            NullDefaultKind nullDefaultKind = StatementSwitchToExpressionSwitch.analyzeCaseForNullAndDefault(caseTree);
            boolean isDefaultCase = nullDefaultKind.equals((Object)NullDefaultKind.KIND_DEFAULT) || nullDefaultKind.equals((Object)NullDefaultKind.KIND_NULL_AND_DEFAULT);
            isNullCase.set(caseIndex, nullDefaultKind.equals((Object)NullDefaultKind.KIND_NULL) || nullDefaultKind.equals((Object)NullDefaultKind.KIND_NULL_AND_DEFAULT));
            hasDefaultCase |= isDefaultCase;
            if (caseIndex > 0 && ((Boolean)groupedWithNextCase.get(caseIndex - 1)).booleanValue() && ((Boolean)isNullCase.get(caseIndex)).booleanValue()) {
                return DEFAULT_ANALYSIS_RESULT;
            }
            if (caseIndex > 0 && ((Boolean)groupedWithNextCase.get(caseIndex - 1)).booleanValue() && ((Boolean)isNullCase.get(caseIndex - 1)).booleanValue() && !isDefaultCase) {
                return DEFAULT_ANALYSIS_RESULT;
            }
            if (caseIndex > 0 && ((Boolean)isNullCase.get(caseIndex - 1)).booleanValue() && isDefaultCase && !SourceVersion.supportsPatternMatchingSwitch((Context)state.context)) {
                return DEFAULT_ANALYSIS_RESULT;
            }
            handledEnumValues.addAll((Collection)caseTree.getExpressions().stream().map(ASTHelpers::getSymbol).filter(x -> x != null).map(symbol -> symbol.getSimpleName().toString()).collect(ImmutableSet.toImmutableSet()));
            boolean isLastCaseInSwitch = caseIndex == cases.size() - 1;
            ImmutableList<StatementTree> statements = StatementSwitchToExpressionSwitch.getStatements(caseTree);
            BiMap<Symbol.VarSymbol, VariableTree> symbolsDefinedInThisCase = StatementSwitchToExpressionSwitch.extractSymbolsDefinedInStatementBlock(statements);
            CaseFallThru caseFallThru = CaseFallThru.MAYBE_FALLS_THRU;
            if (statements == null) {
                return DEFAULT_ANALYSIS_RESULT;
            }
            if (statements.isEmpty()) {
                caseFallThru = CaseFallThru.DEFINITELY_DOES_FALL_THRU;
                groupedWithNextCase.set(caseIndex, !isLastCaseInSwitch);
            } else {
                groupedWithNextCase.set(caseIndex, false);
                if (StatementSwitchToExpressionSwitch.areStatementsConvertibleToExpressionSwitch(statements, isLastCaseInSwitch)) {
                    caseFallThru = CaseFallThru.DEFINITELY_DOES_NOT_FALL_THRU;
                }
            }
            if (isDefaultCase) {
                boolean precedingCaseIsNull;
                boolean fallsIntoDefaultCase = caseIndex > 0 && (Boolean)groupedWithNextCase.get(caseIndex - 1) != false;
                boolean bl = precedingCaseIsNull = caseIndex > 0 && (Boolean)isNullCase.get(caseIndex - 1) != false;
                if (isLastCaseInSwitch) {
                    if (!precedingCaseIsNull) {
                        allCasesHaveDefiniteControlFlow &= !fallsIntoDefaultCase;
                    }
                } else {
                    allCasesHaveDefiniteControlFlow &= (precedingCaseIsNull || !fallsIntoDefaultCase) && caseFallThru.equals((Object)CaseFallThru.DEFINITELY_DOES_NOT_FALL_THRU);
                }
            } else {
                allCasesHaveDefiniteControlFlow &= !caseFallThru.equals((Object)CaseFallThru.MAYBE_FALLS_THRU);
            }
            ImmutableSet newSymbolsToHoist = (ImmutableSet)symbolsDefinedInPreviousCases.keySet().stream().filter(symbol -> StatementSwitchToExpressionSwitch.hasReadsOrWritesOfVariableInTree(symbol, caseTree)).collect(ImmutableSet.toImmutableSet());
            boolean hasNamingConflict = newSymbolsToHoist.stream().filter(symbol -> StatementSwitchToExpressionSwitch.declaresAnotherVariableNamed(symbol, switchTree)).findAny().isPresent();
            if (hasNamingConflict) {
                return DEFAULT_ANALYSIS_RESULT;
            }
            newSymbolsToHoist.forEach(arg_0 -> StatementSwitchToExpressionSwitch.lambda$analyzeSwitchTree$4((BiMap)symbolsToHoist, (BiMap)symbolsDefinedInPreviousCases, arg_0));
            returnSwitchCaseQualifications = StatementSwitchToExpressionSwitch.analyzeCaseForReturnSwitch(returnSwitchCaseQualifications, statements, isLastCaseInSwitch);
            assignmentSwitchAnalysisState = StatementSwitchToExpressionSwitch.analyzeCaseForAssignmentSwitch(assignmentSwitchAnalysisState, statements, isLastCaseInSwitch);
            symbolsDefinedInPreviousCases.putAll(symbolsDefinedInThisCase);
        }
        boolean exhaustive = StatementSwitchToExpressionSwitch.isSwitchExhaustive(hasDefaultCase, handledEnumValues, ASTHelpers.getType((Tree)switchTree.getExpression()));
        boolean canRemoveDefault = hasDefaultCase && StatementSwitchToExpressionSwitch.isSwitchExhaustiveWithoutDefault(handledEnumValues, ASTHelpers.getType((Tree)switchTree.getExpression()));
        boolean canConvertToReturnSwitch = allCasesHaveDefiniteControlFlow && symbolsToHoist.isEmpty() && returnSwitchCaseQualifications.equals((Object)CaseQualifications.ALL_CASES_QUALIFY) && exhaustive;
        boolean canConvertToAssignmentSwitch = allCasesHaveDefiniteControlFlow && symbolsToHoist.isEmpty() && assignmentSwitchAnalysisState.assignmentSwitchCaseQualifications().equals((Object)CaseQualifications.ALL_CASES_QUALIFY) && exhaustive;
        boolean canConvertDirectlyToExpressionSwitch = allCasesHaveDefiniteControlFlow && symbolsToHoist.keySet().stream().noneMatch(symbol -> state.getTypes().isArray(symbol.type)) && symbolsToHoist.keySet().stream().noneMatch(symbol -> symbol.type instanceof IntersectionType);
        ImmutableList<StatementTree> precedingStatements = StatementSwitchToExpressionSwitch.getPrecedingStatementsInBlock(state);
        Optional<ExpressionTree> assignmentTarget = assignmentSwitchAnalysisState.assignmentTargetOptional();
        Optional<VariableTree> combinableVariableTree = canConvertToAssignmentSwitch ? assignmentTarget.flatMap(target -> StatementSwitchToExpressionSwitch.findCombinableVariableTree(target, precedingStatements, state)) : Optional.empty();
        return new AnalysisResult(canConvertDirectlyToExpressionSwitch, canConvertToReturnSwitch, canRemoveDefault, new AssignmentSwitchAnalysisResult(canConvertToAssignmentSwitch, combinableVariableTree, assignmentSwitchAnalysisState.assignmentTargetOptional(), assignmentSwitchAnalysisState.assignmentExpressionKindOptional(), assignmentSwitchAnalysisState.assignmentTreeOptional().map(StatementSwitchToExpressionSwitch::renderJavaSourceOfAssignment)), (ImmutableList<Boolean>)ImmutableList.copyOf(groupedWithNextCase), (ImmutableBiMap<Symbol.VarSymbol, VariableTree>)ImmutableBiMap.copyOf((Map)symbolsToHoist));
    }

    private static Optional<VariableTree> findCombinableVariableTree(ExpressionTree assignmentTarget, ImmutableList<StatementTree> precedingStatements, VisitorState state) {
        if (precedingStatements.isEmpty() || !StatementSwitchToExpressionSwitch.precedingTwoStatementsNotInSameVariableDeclaratorList(precedingStatements)) {
            return Optional.empty();
        }
        Object object = Iterables.getLast(precedingStatements);
        if (!(object instanceof VariableTree)) {
            return Optional.empty();
        }
        VariableTree variableTree = (VariableTree)object;
        if (variableTree.getInitializer() != null && !COMPILE_TIME_CONSTANT_MATCHER.matches((Tree)variableTree.getInitializer(), state)) {
            return Optional.empty();
        }
        if (!StatementSwitchToExpressionSwitch.noReadsOfVariable(ASTHelpers.getSymbol((VariableTree)variableTree), state)) {
            return Optional.empty();
        }
        if (!StatementSwitchToExpressionSwitch.isVariableCompatibleWithAssignment(assignmentTarget, variableTree)) {
            return Optional.empty();
        }
        return Optional.of(variableTree);
    }

    private static boolean noReadsOfVariable(Symbol.VarSymbol symbol, VisitorState state) {
        final HashSet referencedLocalVariables = new HashSet();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                return (Void)this.scan(tree.getExpression(), null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelect, Void unused) {
                this.handle(memberSelect);
                return (Void)super.visitMemberSelect(memberSelect, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifier, Void unused) {
                this.handle(identifier);
                return (Void)super.visitIdentifier(identifier, null);
            }

            private void handle(Tree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (symbol instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                    referencedLocalVariables.add(varSymbol);
                }
            }
        }.scan(state.getPath(), (Void)null);
        return !referencedLocalVariables.contains(symbol);
    }

    private static boolean hasReadsOrWritesOfVariableInTree(Symbol.VarSymbol symbol, Tree tree) {
        final HashSet referencedLocalVariables = new HashSet();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelect, Void unused) {
                this.handle(memberSelect);
                return (Void)super.visitMemberSelect(memberSelect, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifier, Void unused) {
                this.handle(identifier);
                return (Void)super.visitIdentifier(identifier, null);
            }

            private void handle(Tree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (symbol instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                    referencedLocalVariables.add(varSymbol);
                }
            }
        }.scan(tree, null);
        return referencedLocalVariables.contains(symbol);
    }

    private static boolean declaresAnotherVariableNamed(final Symbol.VarSymbol symbol, SwitchTree switchTree) {
        return (Boolean)new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitVariable(VariableTree variableTree, Void unused) {
                Symbol.VarSymbol thisVarSymbol;
                if (variableTree.getName().contentEquals(symbol.name.toString()) && !(thisVarSymbol = ASTHelpers.getSymbol((VariableTree)variableTree)).equals(symbol)) {
                    return true;
                }
                return (Boolean)super.visitVariable(variableTree, null);
            }

            @Override
            public Boolean reduce(@Nullable Boolean left, @Nullable Boolean right) {
                return Objects.equals(left, true) || Objects.equals(right, true);
            }
        }.scan(switchTree, null);
    }

    private static String renderJavaSourceOfAssignment(ExpressionTree tree) {
        if (tree instanceof JCTree.JCAssign) {
            return EQUALS_STRING;
        }
        JCTree.JCAssignOp jcAssignOp = (JCTree.JCAssignOp)tree;
        Pretty pretty = new Pretty(new StringWriter(), true);
        return pretty.operatorName(jcAssignOp.getTag().noAssignOp()) + EQUALS_STRING;
    }

    private static String renderNullDefaultKindPrefix(NullDefaultKind nullDefaultKind, boolean removeDefault) {
        return switch (nullDefaultKind.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (removeDefault) {
                    yield "case null";
                }
                yield "case null, default";
            }
            case 2 -> "case null";
            case 1 -> {
                if (removeDefault) {
                    yield "";
                }
                yield "default";
            }
            case 3 -> "case ";
        };
    }

    private static CaseQualifications analyzeCaseForReturnSwitch(CaseQualifications previousCaseQualifications, List<? extends StatementTree> statements, boolean isLastCaseInSwitch) {
        if (statements.isEmpty() && !isLastCaseInSwitch) {
            return previousCaseQualifications;
        }
        if (statements.isEmpty()) {
            return CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY;
        }
        StatementTree lastStatement = (StatementTree)Iterables.getLast(statements);
        if (!statements.subList(0, statements.size() - 1).stream().allMatch(statement -> statement instanceof ExpressionStatementTree) || !KINDS_RETURN_OR_THROW.contains((Object)lastStatement.getKind())) {
            return CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY;
        }
        if (!(lastStatement instanceof ReturnTree)) {
            return previousCaseQualifications;
        }
        ReturnTree returnTree = (ReturnTree)lastStatement;
        if (!previousCaseQualifications.equals((Object)CaseQualifications.NO_CASES_ASSESSED)) {
            return previousCaseQualifications;
        }
        Type returnType = ASTHelpers.getType((Tree)returnTree.getExpression());
        return returnType == null ? CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY : CaseQualifications.ALL_CASES_QUALIFY;
    }

    private static AssignmentSwitchAnalysisState analyzeCaseForAssignmentSwitch(AssignmentSwitchAnalysisState previousAssignmentSwitchAnalysisState, List<? extends StatementTree> statements, boolean isLastCaseInSwitch) {
        boolean compatibleReference;
        BreakTree breakTree;
        StatementTree statementTree;
        boolean expressionOrExpressionBreak;
        CaseQualifications caseQualifications = previousAssignmentSwitchAnalysisState.assignmentSwitchCaseQualifications();
        Optional<Tree.Kind> assignmentExpressionKindOptional = previousAssignmentSwitchAnalysisState.assignmentExpressionKindOptional();
        Optional<ExpressionTree> assignmentTargetOptional = previousAssignmentSwitchAnalysisState.assignmentTargetOptional();
        Optional<ExpressionTree> assignmentTreeOptional = previousAssignmentSwitchAnalysisState.assignmentTreeOptional();
        if (statements.isEmpty()) {
            return isLastCaseInSwitch ? new AssignmentSwitchAnalysisState(CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY, assignmentTargetOptional, assignmentExpressionKindOptional, assignmentTreeOptional) : previousAssignmentSwitchAnalysisState;
        }
        StatementTree firstStatement = statements.get(0);
        Tree.Kind firstStatementKind = firstStatement.getKind();
        boolean bl = expressionOrExpressionBreak = statements.size() == 1 && KINDS_CONVERTIBLE_WITHOUT_BRACES.contains((Object)firstStatementKind) || KINDS_CONVERTIBLE_WITHOUT_BRACES.contains((Object)firstStatementKind) && (statementTree = statements.get(1)) instanceof BreakTree && (breakTree = (BreakTree)statementTree).getLabel() == null;
        if (!expressionOrExpressionBreak) {
            return new AssignmentSwitchAnalysisState(CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY, assignmentTargetOptional, assignmentExpressionKindOptional, assignmentTreeOptional);
        }
        if (!(firstStatement instanceof ExpressionStatementTree)) {
            return previousAssignmentSwitchAnalysisState;
        }
        ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)firstStatement;
        ExpressionTree expression = expressionStatementTree.getExpression();
        Optional<Object> caseAssignmentTargetOptional = Optional.empty();
        Optional<Object> caseAssignmentKindOptional = Optional.empty();
        Optional<Object> caseAssignmentTreeOptional = Optional.empty();
        if (expression instanceof CompoundAssignmentTree) {
            CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)expression;
            caseAssignmentTargetOptional = Optional.of(compoundAssignmentTree.getVariable());
            caseAssignmentKindOptional = Optional.of(compoundAssignmentTree.getKind());
            caseAssignmentTreeOptional = Optional.of(expression);
        } else if (expression instanceof AssignmentTree) {
            AssignmentTree assignmentTree = (AssignmentTree)expression;
            caseAssignmentTargetOptional = Optional.of(assignmentTree.getVariable());
            caseAssignmentKindOptional = Optional.of(Tree.Kind.ASSIGNMENT);
            caseAssignmentTreeOptional = Optional.of(expression);
        }
        boolean compatibleOperator = assignmentExpressionKindOptional.isEmpty() && caseAssignmentKindOptional.isPresent() || assignmentExpressionKindOptional.isPresent() && caseAssignmentKindOptional.isPresent() && assignmentExpressionKindOptional.get().equals(caseAssignmentKindOptional.get());
        boolean bl2 = compatibleReference = assignmentTargetOptional.isEmpty() && caseAssignmentTargetOptional.isPresent() || StatementSwitchToExpressionSwitch.isCompatibleWithFirstAssignment(assignmentTargetOptional, caseAssignmentTargetOptional);
        caseQualifications = compatibleOperator && compatibleReference ? (caseQualifications.equals((Object)CaseQualifications.NO_CASES_ASSESSED) ? CaseQualifications.ALL_CASES_QUALIFY : caseQualifications) : CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY;
        return new AssignmentSwitchAnalysisState(caseQualifications, assignmentTargetOptional.isEmpty() ? caseAssignmentTargetOptional : assignmentTargetOptional, assignmentExpressionKindOptional.isEmpty() ? caseAssignmentKindOptional : assignmentExpressionKindOptional, assignmentTreeOptional.isEmpty() ? caseAssignmentTreeOptional : assignmentTreeOptional);
    }

    private static boolean isCompatibleWithFirstAssignment(Optional<ExpressionTree> assignmentTargetOptional, Optional<ExpressionTree> caseAssignmentTargetOptional) {
        if (assignmentTargetOptional.isEmpty() || caseAssignmentTargetOptional.isEmpty()) {
            return false;
        }
        Symbol assignmentTargetSymbol = ASTHelpers.getSymbol((Tree)assignmentTargetOptional.get());
        if (assignmentTargetSymbol == null) {
            return false;
        }
        Symbol caseAssignmentTargetSymbol = ASTHelpers.getSymbol((Tree)caseAssignmentTargetOptional.get());
        return Objects.equals(assignmentTargetSymbol, caseAssignmentTargetSymbol);
    }

    private static boolean isVariableCompatibleWithAssignment(ExpressionTree assignmentTarget, VariableTree variableDefinition) {
        Symbol assignmentTargetSymbol = ASTHelpers.getSymbol((Tree)assignmentTarget);
        Symbol.VarSymbol definedSymbol = ASTHelpers.getSymbol((VariableTree)variableDefinition);
        return Objects.equals(assignmentTargetSymbol, definedSymbol);
    }

    private static boolean areStatementsConvertibleToExpressionSwitch(List<? extends StatementTree> statements, boolean isLastCaseInSwitch) {
        if (isLastCaseInSwitch) {
            return true;
        }
        if (statements.isEmpty()) {
            return true;
        }
        return !Reachability.canCompleteNormally((StatementTree)((StatementTree)Iterables.getLast(statements)));
    }

    private static ImmutableList<String> renderVariableTreeComments(VariableTree variableTree, VisitorState state) {
        return (ImmutableList)state.getTokensForNode((Tree)variableTree).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).filter(comment -> !comment.getText().isEmpty()).map(ErrorProneComment::getText).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<String> renderVariableTreeAnnotations(VariableTree variableTree, VisitorState state) {
        return (ImmutableList)variableTree.getModifiers().getAnnotations().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(ImmutableList.toImmutableList());
    }

    private static String renderVariableTreeFlags(VariableTree variableTree) {
        StringBuilder flagsBuilder = new StringBuilder();
        if (!variableTree.getModifiers().getFlags().isEmpty()) {
            flagsBuilder.append(variableTree.getModifiers().getFlags().stream().map(flag -> String.valueOf(flag) + " ").collect(Collectors.joining("")));
        }
        return flagsBuilder.toString();
    }

    private static boolean renderHoistedVariables(StringBuilder renderTo, AnalysisResult analysisResult, SwitchTree switchTree, VisitorState state) {
        LabeledStatementTree lst;
        Tree enclosing;
        TreePath pathToEnclosing;
        boolean wrapInBraces = false;
        if (!analysisResult.symbolsToHoist().isEmpty() && (pathToEnclosing = state.findPathToEnclosing(new Class[]{LabeledStatementTree.class})) != null && (enclosing = pathToEnclosing.getLeaf()) instanceof LabeledStatementTree && (lst = (LabeledStatementTree)enclosing).getStatement().equals(switchTree)) {
            wrapInBraces = true;
        }
        if (wrapInBraces) {
            renderTo.append("{\n");
        }
        for (VariableTree variableTree : analysisResult.symbolsToHoist().values()) {
            renderTo.append(Streams.concat((Stream[])new Stream[]{StatementSwitchToExpressionSwitch.renderVariableTreeComments(variableTree, state).stream(), StatementSwitchToExpressionSwitch.renderVariableTreeAnnotations(variableTree, state).stream(), Stream.of(StatementSwitchToExpressionSwitch.renderVariableTreeFlags(variableTree))}).collect(Collectors.joining("\n")));
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)analysisResult.symbolsToHoist().inverse().get((Object)variableTree);
            String sourceForType = ASTHelpers.hasImplicitType((VariableTree)variableTree, (VisitorState)state) ? SuggestedFixes.prettyType((Type)varSymbol.type, (VisitorState)state) : state.getSourceForNode(variableTree.getType());
            renderTo.append(sourceForType).append(" ").append(variableTree.getName()).append(";\n");
        }
        return wrapInBraces;
    }

    private static SuggestedFix convertDirectlyToExpressionSwitch(SwitchTree switchTree, VisitorState state, AnalysisResult analysisResult, boolean removeDefault) {
        List<? extends CaseTree> cases = switchTree.getCases();
        ImmutableList allSwitchComments = (ImmutableList)state.getTokensForNode((Tree)switchTree).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).collect(ImmutableList.toImmutableList());
        StringBuilder replacementCodeBuilder = new StringBuilder();
        boolean insertClosingBrace = StatementSwitchToExpressionSwitch.renderHoistedVariables(replacementCodeBuilder, analysisResult, switchTree, state);
        replacementCodeBuilder.append("switch ").append(state.getSourceForNode((Tree)switchTree.getExpression())).append(" {");
        StringBuilder groupedCaseCommentsAccumulator = null;
        boolean firstCaseInGroup = true;
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            NullDefaultKind nullDefaultKind = StatementSwitchToExpressionSwitch.analyzeCaseForNullAndDefault(caseTree);
            if (removeDefault && nullDefaultKind.equals((Object)NullDefaultKind.KIND_DEFAULT)) continue;
            ImmutableList<StatementTree> filteredStatements = StatementSwitchToExpressionSwitch.filterOutRedundantBreak(caseTree);
            String transformedBlockSource = StatementSwitchToExpressionSwitch.transformBlock(caseTree, state, filteredStatements, analysisResult.symbolsToHoist());
            if (firstCaseInGroup) {
                groupedCaseCommentsAccumulator = new StringBuilder(caseIndex == 0 ? StatementSwitchToExpressionSwitch.extractCommentsBeforeFirstCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments).orElse("") : "");
                replacementCodeBuilder.append("\n  ").append(StatementSwitchToExpressionSwitch.renderNullDefaultKindPrefix(nullDefaultKind, removeDefault));
            } else if (nullDefaultKind.equals((Object)NullDefaultKind.KIND_DEFAULT)) {
                replacementCodeBuilder.append("default");
            }
            if (nullDefaultKind.equals((Object)NullDefaultKind.KIND_NEITHER)) {
                replacementCodeBuilder.append(StatementSwitchToExpressionSwitch.printCaseExpressionsOrPatternAndGuard(caseTree, state));
            }
            Optional<String> commentsAfterCaseOptional = StatementSwitchToExpressionSwitch.extractCommentsAfterCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments, state, caseIndex);
            if (((Boolean)analysisResult.groupedWithNextCase().get(caseIndex)).booleanValue()) {
                firstCaseInGroup = false;
                replacementCodeBuilder.append(", ");
                if (!transformedBlockSource.trim().isEmpty()) {
                    String commentsToAppend = StatementSwitchToExpressionSwitch.removeFallThruLines(transformedBlockSource);
                    if (groupedCaseCommentsAccumulator.length() > 0) {
                        groupedCaseCommentsAccumulator.append("\n");
                    }
                    groupedCaseCommentsAccumulator.append(commentsToAppend);
                }
                if (!commentsAfterCaseOptional.isPresent()) continue;
                if (groupedCaseCommentsAccumulator.length() > 0) {
                    groupedCaseCommentsAccumulator.append("\n");
                }
                groupedCaseCommentsAccumulator.append(commentsAfterCaseOptional.get());
                continue;
            }
            Optional<String> commentsBeforeRemovedBreak = StatementSwitchToExpressionSwitch.extractCommentsBeforeRemovedBreak(caseTree, state, filteredStatements);
            transformedBlockSource = Joiner.on((String)"\n").skipNulls().join((Object)(groupedCaseCommentsAccumulator.length() == 0 ? null : groupedCaseCommentsAccumulator.toString()), (Object)(transformedBlockSource.isEmpty() ? null : transformedBlockSource.trim()), new Object[]{commentsBeforeRemovedBreak.orElse(null), commentsAfterCaseOptional.orElse(null)});
            replacementCodeBuilder.append(" -> ");
            if (filteredStatements.isEmpty()) {
                String trimmedTransformedBlockSource = transformedBlockSource.trim();
                if (trimmedTransformedBlockSource.isEmpty() || trimmedTransformedBlockSource.equals("break;")) {
                    replacementCodeBuilder.append("{}");
                } else {
                    replacementCodeBuilder.append("{\n").append(transformedBlockSource).append("\n}");
                }
            } else if (StatementSwitchToExpressionSwitch.shouldTransformCaseWithoutBraces(filteredStatements)) {
                replacementCodeBuilder.append("\n").append(transformedBlockSource);
            } else {
                replacementCodeBuilder.append("{\n").append(transformedBlockSource).append("\n}");
            }
            firstCaseInGroup = true;
        }
        replacementCodeBuilder.append("\n}");
        if (insertClosingBrace) {
            replacementCodeBuilder.append("\n}");
        }
        SuggestedFix.Builder suggestedFixBuilder = SuggestedFix.builder();
        if (removeDefault) {
            suggestedFixBuilder.setShortDescription(REMOVE_DEFAULT_CASE_SHORT_DESCRIPTION);
        }
        suggestedFixBuilder.replace((Tree)switchTree, replacementCodeBuilder.toString());
        return suggestedFixBuilder.build();
    }

    private static SuggestedFix convertToReturnSwitch(SwitchTree switchTree, VisitorState state, AnalysisResult analysisResult, boolean removeDefault) {
        SuggestedFix.Builder suggestedFixBuilder = SuggestedFix.builder();
        List<? extends CaseTree> cases = switchTree.getCases();
        ImmutableList allSwitchComments = (ImmutableList)state.getTokensForNode((Tree)switchTree).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).collect(ImmutableList.toImmutableList());
        StringBuilder replacementCodeBuilder = new StringBuilder();
        replacementCodeBuilder.append("return switch ").append(state.getSourceForNode((Tree)switchTree.getExpression())).append(" {");
        StringBuilder groupedCaseCommentsAccumulator = null;
        boolean firstCaseInGroup = true;
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            NullDefaultKind nullDefaultKind = StatementSwitchToExpressionSwitch.analyzeCaseForNullAndDefault(caseTree);
            if (removeDefault && nullDefaultKind.equals((Object)NullDefaultKind.KIND_DEFAULT)) continue;
            String transformedBlockSource = StatementSwitchToExpressionSwitch.transformReturnOrThrowBlock(caseTree, state, StatementSwitchToExpressionSwitch.getStatements(caseTree));
            if (firstCaseInGroup) {
                groupedCaseCommentsAccumulator = new StringBuilder(caseIndex == 0 ? StatementSwitchToExpressionSwitch.extractCommentsBeforeFirstCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments).orElse("") : "");
                replacementCodeBuilder.append("\n  ").append(StatementSwitchToExpressionSwitch.renderNullDefaultKindPrefix(nullDefaultKind, removeDefault));
            } else if (nullDefaultKind.equals((Object)NullDefaultKind.KIND_DEFAULT)) {
                replacementCodeBuilder.append("default");
            }
            if (nullDefaultKind.equals((Object)NullDefaultKind.KIND_NEITHER)) {
                replacementCodeBuilder.append(StatementSwitchToExpressionSwitch.printCaseExpressionsOrPatternAndGuard(caseTree, state));
            }
            Optional<String> commentsAfterCaseOptional = StatementSwitchToExpressionSwitch.extractCommentsAfterCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments, state, caseIndex);
            if (((Boolean)analysisResult.groupedWithNextCase().get(caseIndex)).booleanValue()) {
                firstCaseInGroup = false;
                replacementCodeBuilder.append(", ");
                if (!transformedBlockSource.trim().isEmpty()) {
                    String commentsToAppend = StatementSwitchToExpressionSwitch.removeFallThruLines(transformedBlockSource);
                    if (groupedCaseCommentsAccumulator.length() > 0) {
                        groupedCaseCommentsAccumulator.append("\n");
                    }
                    groupedCaseCommentsAccumulator.append(commentsToAppend);
                }
                if (!commentsAfterCaseOptional.isPresent()) continue;
                if (groupedCaseCommentsAccumulator.length() > 0) {
                    groupedCaseCommentsAccumulator.append("\n");
                }
                groupedCaseCommentsAccumulator.append(commentsAfterCaseOptional.get());
                continue;
            }
            transformedBlockSource = Joiner.on((String)"\n").skipNulls().join((Object)(groupedCaseCommentsAccumulator.length() == 0 ? null : groupedCaseCommentsAccumulator.toString()), (Object)(transformedBlockSource.isEmpty() ? null : transformedBlockSource), new Object[]{commentsAfterCaseOptional.orElse(null)});
            replacementCodeBuilder.append(" -> ");
            replacementCodeBuilder.append("\n").append(transformedBlockSource);
            firstCaseInGroup = true;
        }
        replacementCodeBuilder.append("\n};");
        StatementTree cannotCompleteNormallyTree = switchTree;
        Tree prev = state.getPath().getLeaf();
        for (Tree tree : state.getPath().getParentPath()) {
            if (tree instanceof BlockTree) {
                BlockTree blockTree = (BlockTree)tree;
                List<? extends StatementTree> statements = blockTree.getStatements();
                int indexInBlock = statements.indexOf(prev);
                boolean nextStatementReachable = Reachability.canCompleteNormally((StatementTree)statements.get(indexInBlock), (ImmutableMap)ImmutableMap.of((Object)cannotCompleteNormallyTree, (Object)false));
                cannotCompleteNormallyTree = blockTree;
                if (nextStatementReachable) break;
                if (indexInBlock < statements.size() - 1) {
                    String deletedRegion = state.getSourceCode().subSequence(state.getEndPosition((Tree)statements.get(indexInBlock)), state.getEndPosition((Tree)blockTree)).toString();
                    if (deletedRegion.contains("LINT.")) {
                        statements.subList(indexInBlock + 1, statements.size()).forEach(arg_0 -> ((SuggestedFix.Builder)suggestedFixBuilder).delete(arg_0));
                    } else {
                        suggestedFixBuilder.replace(state.getEndPosition((Tree)statements.get(indexInBlock)), state.getEndPosition((Tree)blockTree), "}");
                    }
                }
            }
            prev = tree;
        }
        if (removeDefault) {
            suggestedFixBuilder.setShortDescription(REMOVE_DEFAULT_CASE_SHORT_DESCRIPTION);
        }
        suggestedFixBuilder.replace((Tree)switchTree, replacementCodeBuilder.toString());
        return suggestedFixBuilder.build();
    }

    private static ImmutableList<StatementTree> getPrecedingStatementsInBlock(VisitorState state) {
        TreePath path = state.getPath();
        Tree tree = path.getParentPath().getLeaf();
        if (!(tree instanceof BlockTree)) {
            return ImmutableList.of();
        }
        BlockTree blockTree = (BlockTree)tree;
        List<? extends StatementTree> statements = blockTree.getStatements();
        return ImmutableList.copyOf(statements.subList(0, statements.indexOf(path.getLeaf())));
    }

    private static boolean precedingTwoStatementsNotInSameVariableDeclaratorList(List<StatementTree> precedingStatements) {
        VariableTree variableTree1;
        StatementTree lastStatement;
        block5: {
            block4: {
                if (precedingStatements.size() < 2) {
                    return true;
                }
                StatementTree secondToLastStatement = precedingStatements.get(precedingStatements.size() - 2);
                lastStatement = (StatementTree)Iterables.getLast(precedingStatements);
                if (!(secondToLastStatement instanceof VariableTree)) break block4;
                variableTree1 = (VariableTree)secondToLastStatement;
                if (lastStatement instanceof VariableTree) break block5;
            }
            return true;
        }
        VariableTree variableTree2 = (VariableTree)lastStatement;
        return ASTHelpers.getStartPosition((Tree)variableTree1) != ASTHelpers.getStartPosition((Tree)variableTree2);
    }

    private static SuggestedFix convertToAssignmentSwitch(SwitchTree switchTree, VisitorState state, AnalysisResult analysisResult, boolean removeDefault) {
        SuggestedFix.Builder suggestedFixBuilder = SuggestedFix.builder();
        StringBuilder replacementCodeBuilder = new StringBuilder();
        analysisResult.assignmentSwitchAnalysisResult().precedingVariableDeclaration().ifPresent(variableTree -> {
            suggestedFixBuilder.delete((Tree)variableTree);
            replacementCodeBuilder.append(Streams.concat((Stream[])new Stream[]{StatementSwitchToExpressionSwitch.renderVariableTreeComments(variableTree, state).stream(), StatementSwitchToExpressionSwitch.renderVariableTreeAnnotations(variableTree, state).stream(), Stream.of(StatementSwitchToExpressionSwitch.renderVariableTreeFlags(variableTree))}).collect(Collectors.joining("\n")));
            String sourceForType = ASTHelpers.hasImplicitType((VariableTree)variableTree, (VisitorState)state) ? "var" : state.getSourceForNode(variableTree.getType());
            replacementCodeBuilder.append(sourceForType).append(" ");
        });
        List<? extends CaseTree> cases = switchTree.getCases();
        ImmutableList allSwitchComments = (ImmutableList)state.getTokensForNode((Tree)switchTree).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).collect(ImmutableList.toImmutableList());
        replacementCodeBuilder.append(state.getSourceForNode((Tree)analysisResult.assignmentSwitchAnalysisResult().assignmentTargetOptional().get())).append(" ").append(analysisResult.assignmentSwitchAnalysisResult().assignmentSourceCodeOptional().get()).append(" ").append("switch ").append(state.getSourceForNode((Tree)switchTree.getExpression())).append(" {");
        StringBuilder groupedCaseCommentsAccumulator = null;
        boolean firstCaseInGroup = true;
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            NullDefaultKind nullDefaultKind = StatementSwitchToExpressionSwitch.analyzeCaseForNullAndDefault(caseTree);
            if (removeDefault && nullDefaultKind.equals((Object)NullDefaultKind.KIND_DEFAULT)) continue;
            ImmutableList<StatementTree> filteredStatements = StatementSwitchToExpressionSwitch.filterOutRedundantBreak(caseTree);
            String transformedBlockSource = StatementSwitchToExpressionSwitch.transformAssignOrThrowBlock(caseTree, state, filteredStatements);
            if (firstCaseInGroup) {
                groupedCaseCommentsAccumulator = new StringBuilder(caseIndex == 0 ? StatementSwitchToExpressionSwitch.extractCommentsBeforeFirstCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments).orElse("") : "");
                replacementCodeBuilder.append("\n  ").append(StatementSwitchToExpressionSwitch.renderNullDefaultKindPrefix(nullDefaultKind, removeDefault));
            } else if (nullDefaultKind.equals((Object)NullDefaultKind.KIND_DEFAULT)) {
                replacementCodeBuilder.append("default");
            }
            if (nullDefaultKind.equals((Object)NullDefaultKind.KIND_NEITHER)) {
                replacementCodeBuilder.append(StatementSwitchToExpressionSwitch.printCaseExpressionsOrPatternAndGuard(caseTree, state));
            }
            Optional<String> commentsAfterCaseOptional = StatementSwitchToExpressionSwitch.extractCommentsAfterCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments, state, caseIndex);
            if (((Boolean)analysisResult.groupedWithNextCase().get(caseIndex)).booleanValue()) {
                firstCaseInGroup = false;
                replacementCodeBuilder.append(", ");
                if (!transformedBlockSource.trim().isEmpty()) {
                    String commentsToAppend = StatementSwitchToExpressionSwitch.removeFallThruLines(transformedBlockSource);
                    if (groupedCaseCommentsAccumulator.length() > 0) {
                        groupedCaseCommentsAccumulator.append("\n");
                    }
                    groupedCaseCommentsAccumulator.append(commentsToAppend);
                }
                if (!commentsAfterCaseOptional.isPresent()) continue;
                if (groupedCaseCommentsAccumulator.length() > 0) {
                    groupedCaseCommentsAccumulator.append("\n");
                }
                groupedCaseCommentsAccumulator.append(commentsAfterCaseOptional.get());
                continue;
            }
            Optional<String> commentsBeforeRemovedBreak = StatementSwitchToExpressionSwitch.extractCommentsBeforeRemovedBreak(caseTree, state, filteredStatements);
            transformedBlockSource = Joiner.on((String)"\n").skipNulls().join((Object)(groupedCaseCommentsAccumulator.length() == 0 ? null : groupedCaseCommentsAccumulator.toString()), (Object)(transformedBlockSource.isEmpty() ? null : transformedBlockSource), new Object[]{commentsBeforeRemovedBreak.orElse(null), commentsAfterCaseOptional.orElse(null)});
            replacementCodeBuilder.append(" -> ");
            replacementCodeBuilder.append("\n").append(transformedBlockSource);
            firstCaseInGroup = true;
        }
        replacementCodeBuilder.append("\n};");
        if (removeDefault) {
            suggestedFixBuilder.setShortDescription(REMOVE_DEFAULT_CASE_SHORT_DESCRIPTION);
        }
        suggestedFixBuilder.replace((Tree)switchTree, replacementCodeBuilder.toString());
        return suggestedFixBuilder.build();
    }

    private static Optional<String> extractCommentsBeforeRemovedBreak(CaseTree caseTree, VisitorState state, ImmutableList<StatementTree> filteredStatements) {
        String commentsAfterNewLastStatement;
        if (!filteredStatements.isEmpty() && StatementSwitchToExpressionSwitch.getStatements(caseTree).size() > filteredStatements.size() && !(commentsAfterNewLastStatement = state.getSourceCode().subSequence(state.getEndPosition((Tree)Iterables.getLast(filteredStatements)), ASTHelpers.getStartPosition((Tree)((Tree)Iterables.getLast(StatementSwitchToExpressionSwitch.getStatements(caseTree))))).toString().trim()).isEmpty()) {
            return Optional.of(commentsAfterNewLastStatement);
        }
        return Optional.empty();
    }

    private static ImmutableList<StatementTree> filterOutRedundantBreak(CaseTree caseTree) {
        BreakTree bt;
        Object object;
        ImmutableList statements = StatementSwitchToExpressionSwitch.getStatements(caseTree);
        boolean caseEndsWithUnlabelledBreak = !statements.isEmpty() && (object = Iterables.getLast(statements)) instanceof BreakTree && (bt = (BreakTree)object).getLabel() == null;
        return caseEndsWithUnlabelledBreak ? statements.subList(0, statements.size() - 1) : statements;
    }

    private static @Nullable ImmutableList<StatementTree> getStatements(CaseTree caseTree) {
        ImmutableList immutableList;
        List<? extends StatementTree> statements = caseTree.getStatements();
        if (statements == null) {
            return null;
        }
        if (statements.size() != 1) {
            return ImmutableList.copyOf(statements);
        }
        Object object = Iterables.getOnlyElement(statements);
        if (object instanceof BlockTree) {
            BlockTree blockTree = (BlockTree)object;
            immutableList = ImmutableList.copyOf(blockTree.getStatements());
        } else {
            immutableList = ImmutableList.copyOf(statements);
        }
        return immutableList;
    }

    private static String transformBlock(CaseTree caseTree, VisitorState state, ImmutableList<StatementTree> filteredStatements, ImmutableBiMap<Symbol.VarSymbol, VariableTree> symbolsToHoist) {
        int codeBlockStart;
        StringBuilder transformedBlockBuilder = new StringBuilder();
        int codeBlockEnd = codeBlockStart = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
        if (!filteredStatements.isEmpty()) {
            for (int i = 0; i < filteredStatements.size(); ++i) {
                VariableTree variableTree;
                StatementTree statement = (StatementTree)filteredStatements.get(i);
                if (statement instanceof VariableTree && symbolsToHoist.containsValue((Object)(variableTree = (VariableTree)statement))) {
                    if (codeBlockEnd > codeBlockStart) {
                        transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart, codeBlockEnd);
                    }
                    int n = codeBlockStart = i < filteredStatements.size() - 1 ? ASTHelpers.getStartPosition((Tree)((Tree)filteredStatements.get(i + 1))) : state.getEndPosition((Tree)statement);
                    if (variableTree.getInitializer() != null) {
                        transformedBlockBuilder.append(variableTree.getName()).append(" = ");
                        transformedBlockBuilder.append(state.getSourceCode(), ASTHelpers.getStartPosition((Tree)variableTree.getInitializer()), state.getEndPosition((Tree)variableTree.getInitializer())).append(";\n");
                    }
                }
                codeBlockEnd = i < filteredStatements.size() - 1 ? ASTHelpers.getStartPosition((Tree)((Tree)filteredStatements.get(i + 1))) : state.getEndPosition((Tree)statement);
            }
            if (codeBlockEnd > codeBlockStart) {
                transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart, codeBlockEnd);
            }
        }
        return transformedBlockBuilder.toString();
    }

    private static int extractLhsComments(CaseTree caseTree, VisitorState state, StringBuilder stringBuilder) {
        int lhsStart = ASTHelpers.getStartPosition((Tree)caseTree);
        ImmutableList<StatementTree> statements = StatementSwitchToExpressionSwitch.getStatements(caseTree);
        int lhsEnd = statements.isEmpty() ? state.getEndPosition((Tree)caseTree) : ASTHelpers.getStartPosition((Tree)((Tree)statements.get(0)));
        state.getOffsetTokens(lhsStart, lhsEnd).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).forEach(comment -> stringBuilder.append(comment.getText()).append("\n"));
        return lhsEnd;
    }

    private static Optional<String> extractCommentsBeforeFirstCase(SwitchTree switchTree, ImmutableList<ErrorProneComment> allSwitchComments) {
        int switchStart = ASTHelpers.getStartPosition((Tree)switchTree);
        int firstCaseStartIndex = ASTHelpers.getStartPosition((Tree)switchTree.getCases().get(0)) - switchStart;
        return StatementSwitchToExpressionSwitch.filterAndRenderComments(allSwitchComments, comment -> comment.getPos() < firstCaseStartIndex);
    }

    private static Optional<String> extractCommentsAfterCase(SwitchTree switchTree, ImmutableList<ErrorProneComment> allSwitchComments, VisitorState state, int caseIndex) {
        int switchStart = ASTHelpers.getStartPosition((Tree)switchTree);
        int caseEndIndex = state.getEndPosition((Tree)switchTree.getCases().get(caseIndex)) - switchStart;
        int nextCaseStartIndex = caseIndex == switchTree.getCases().size() - 1 ? state.getEndPosition((Tree)switchTree) - switchStart : ASTHelpers.getStartPosition((Tree)switchTree.getCases().get(caseIndex + 1)) - switchStart;
        return StatementSwitchToExpressionSwitch.filterAndRenderComments(allSwitchComments, comment -> comment.getPos() >= caseEndIndex && comment.getPos() < nextCaseStartIndex);
    }

    private static Optional<String> filterAndRenderComments(ImmutableList<ErrorProneComment> comments, Predicate<ErrorProneComment> commentFilter) {
        String rendered = comments.stream().filter(commentFilter).map(ErrorProneComment::getText).map(commentText -> StatementSwitchToExpressionSwitch.removeFallThruLines(commentText)).filter(commentText -> !commentText.isEmpty()).collect(Collectors.joining("\n"));
        return rendered.isEmpty() ? Optional.empty() : Optional.of(rendered);
    }

    private static int getBlockEnd(VisitorState state, CaseTree caseTree) {
        List<? extends StatementTree> statements = caseTree.getStatements();
        if (statements == null || statements.size() != 1) {
            return state.getEndPosition((Tree)caseTree);
        }
        StatementTree onlyStatement = (StatementTree)Iterables.getOnlyElement(statements);
        if (!(onlyStatement instanceof BlockTree)) {
            return state.getEndPosition((Tree)caseTree);
        }
        BlockTree blockTree = (BlockTree)onlyStatement;
        List<? extends StatementTree> blockStatements = blockTree.getStatements();
        return blockStatements.isEmpty() ? state.getEndPosition((Tree)caseTree) : state.getEndPosition((Tree)blockStatements.getLast());
    }

    private static boolean shouldTransformCaseWithoutBraces(ImmutableList<StatementTree> statementTrees) {
        if (statementTrees.isEmpty()) {
            return false;
        }
        if (statementTrees.size() > 1) {
            return false;
        }
        StatementTree onlyStatementTree = (StatementTree)statementTrees.get(0);
        return KINDS_CONVERTIBLE_WITHOUT_BRACES.contains((Object)onlyStatementTree.getKind());
    }

    private static String removeFallThruLines(String comments) {
        String string;
        StringBuilder output = new StringBuilder();
        BufferedReader br = new BufferedReader(new CharArrayReader(comments.toCharArray()));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (FALL_THROUGH_PATTERN.matcher(line).find()) continue;
                output.append(line).append("\n");
            }
            string = output.length() > 0 ? output.substring(0, output.length() - 1) : "";
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return comments;
            }
        }
        br.close();
        return string;
    }

    private static boolean hasCasePattern(CaseTree caseTree) {
        return caseTree.getLabels().stream().anyMatch(caseLabelTree -> caseLabelTree instanceof PatternCaseLabelTree);
    }

    private static String printCaseExpressionsOrPatternAndGuard(CaseTree caseTree, VisitorState state) {
        if (!StatementSwitchToExpressionSwitch.hasCasePattern(caseTree)) {
            return caseTree.getExpressions().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", "));
        }
        StringBuilder sb = new StringBuilder(caseTree.getLabels().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", ")));
        if (caseTree.getGuard() != null) {
            sb.append(" when ").append(state.getSourceForNode((Tree)caseTree.getGuard())).append(" ");
        }
        return sb.toString();
    }

    private static boolean isSwitchExhaustive(boolean hasDefaultCase, Set<String> handledEnumValues, Type switchType) {
        if (hasDefaultCase) {
            return true;
        }
        return StatementSwitchToExpressionSwitch.isSwitchExhaustiveWithoutDefault(handledEnumValues, switchType);
    }

    private static boolean isSwitchExhaustiveWithoutDefault(Set<String> handledEnumValues, Type switchType) {
        if (switchType.asElement().getKind() != ElementKind.ENUM) {
            return false;
        }
        return handledEnumValues.containsAll(ASTHelpers.enumValues((Symbol.TypeSymbol)switchType.asElement()));
    }

    private static String transformReturnOrThrowBlock(CaseTree caseTree, VisitorState state, List<? extends StatementTree> statements) {
        StatementTree codeBlockStart2;
        StringBuilder transformedBlockBuilder = new StringBuilder();
        int codeBlockEnd = StatementSwitchToExpressionSwitch.getBlockEnd(state, caseTree);
        if (statements.size() > 1) {
            transformedBlockBuilder.append("{\n");
            int codeBlockStart2 = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
            int offset = transformedBlockBuilder.length();
            transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart2, codeBlockEnd);
            transformedBlockBuilder.append("\n}");
            Object object = Iterables.getLast(statements);
            if (object instanceof ReturnTree) {
                ReturnTree returnTree = (ReturnTree)object;
                int start = ASTHelpers.getStartPosition((Tree)returnTree);
                transformedBlockBuilder.replace(offset + start - codeBlockStart2, offset + start - codeBlockStart2 + "return".length(), "yield");
            }
        } else if (statements.size() == 1 && (codeBlockStart2 = statements.get(0)) instanceof ReturnTree) {
            ReturnTree returnTree = (ReturnTree)codeBlockStart2;
            int unused = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
            int codeBlockStart3 = ASTHelpers.getStartPosition((Tree)returnTree.getExpression());
            transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart3, codeBlockEnd);
        } else {
            int codeBlockStart4 = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
            transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart4, codeBlockEnd);
        }
        return transformedBlockBuilder.toString();
    }

    private static String transformAssignOrThrowBlock(CaseTree caseTree, VisitorState state, List<? extends StatementTree> statements) {
        int codeBlockStart;
        StatementTree statementTree;
        int codeBlockEnd;
        StringBuilder transformedBlockBuilder = new StringBuilder();
        int n = codeBlockEnd = statements.isEmpty() ? StatementSwitchToExpressionSwitch.getBlockEnd(state, caseTree) : state.getEndPosition((Tree)Streams.findLast(statements.stream()).get());
        if (!statements.isEmpty() && (statementTree = statements.get(0)) instanceof ExpressionStatementTree) {
            ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)statementTree;
            int unused = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
            ExpressionTree expression = expressionStatementTree.getExpression();
            Optional<Object> rhs = Optional.empty();
            if (expression instanceof CompoundAssignmentTree) {
                CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)expression;
                rhs = Optional.of(compoundAssignmentTree.getExpression());
            } else if (expression instanceof AssignmentTree) {
                AssignmentTree assignmentTree = (AssignmentTree)expression;
                rhs = Optional.of(assignmentTree.getExpression());
            }
            codeBlockStart = ASTHelpers.getStartPosition((Tree)((Tree)rhs.get()));
        } else {
            codeBlockStart = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
        }
        transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart, codeBlockEnd);
        return transformedBlockBuilder.toString();
    }

    private static NullDefaultKind analyzeCaseForNullAndDefault(CaseTree caseTree) {
        boolean hasDefault = ASTHelpers.isSwitchDefault((CaseTree)caseTree);
        boolean hasNull = caseTree.getExpressions().stream().anyMatch(expression -> expression.getKind().equals((Object)Tree.Kind.NULL_LITERAL));
        if (hasNull && hasDefault) {
            return NullDefaultKind.KIND_NULL_AND_DEFAULT;
        }
        if (hasNull) {
            return NullDefaultKind.KIND_NULL;
        }
        if (hasDefault) {
            return NullDefaultKind.KIND_DEFAULT;
        }
        return NullDefaultKind.KIND_NEITHER;
    }

    private static /* synthetic */ void lambda$analyzeSwitchTree$4(BiMap symbolsToHoist, BiMap symbolsDefinedInPreviousCases, Symbol.VarSymbol symbol) {
        symbolsToHoist.put((Object)symbol, (Object)((VariableTree)symbolsDefinedInPreviousCases.get((Object)symbol)));
    }

    record AnalysisResult(boolean canConvertDirectlyToExpressionSwitch, boolean canConvertToReturnSwitch, boolean canRemoveDefault, AssignmentSwitchAnalysisResult assignmentSwitchAnalysisResult, ImmutableList<Boolean> groupedWithNextCase, ImmutableBiMap<Symbol.VarSymbol, VariableTree> symbolsToHoist) {
    }

    record AssignmentSwitchAnalysisResult(boolean canConvertToAssignmentSwitch, Optional<VariableTree> precedingVariableDeclaration, Optional<ExpressionTree> assignmentTargetOptional, Optional<Tree.Kind> assignmentKindOptional, Optional<String> assignmentSourceCodeOptional) {
    }

    static enum CaseQualifications {
        NO_CASES_ASSESSED,
        ALL_CASES_QUALIFY,
        SOME_OR_ALL_CASES_DONT_QUALIFY;

    }

    record AssignmentSwitchAnalysisState(CaseQualifications assignmentSwitchCaseQualifications, Optional<ExpressionTree> assignmentTargetOptional, Optional<Tree.Kind> assignmentExpressionKindOptional, Optional<ExpressionTree> assignmentTreeOptional) {
    }

    static enum NullDefaultKind {
        KIND_NULL_AND_DEFAULT,
        KIND_DEFAULT,
        KIND_NULL,
        KIND_NEITHER;

    }

    private static enum CaseFallThru {
        DEFINITELY_DOES_NOT_FALL_THRU,
        MAYBE_FALLS_THRU,
        DEFINITELY_DOES_FALL_THRU;

    }
}

