/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;

@BugPattern(summary="reachabilityFence should always be called inside a finally block", severity=BugPattern.SeverityLevel.WARNING)
public class ReachabilityFenceUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> FENCE_MATCHER = MethodMatchers.staticMethod().onClass("java.lang.ref.Reference").named("reachabilityFence");

    /*
     * Enabled aggressive block sorting
     */
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FENCE_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Tree previous = null;
        Iterator<Tree> iterator = state.getPath().getParentPath().iterator();
        while (iterator.hasNext()) {
            Tree tree2;
            Tree enclosing = iterator.next();
            Objects.requireNonNull(enclosing);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TryTree.class, ClassTree.class, MethodTree.class, LambdaExpressionTree.class}, (Object)tree2, n)) {
                case 0: {
                    TryTree tryTree = (TryTree)tree2;
                    if (!Objects.equals(tryTree.getFinallyBlock(), previous)) break;
                    return Description.NO_MATCH;
                }
                case 1: {
                    ClassTree classTree = (ClassTree)tree2;
                    return this.describeMatch(tree);
                }
                case 2: {
                    MethodTree methodTree = (MethodTree)tree2;
                    return this.describeMatch(tree);
                }
                case 3: {
                    LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree2;
                    return this.describeMatch(tree);
                }
            }
            previous = enclosing;
        }
        return this.describeMatch(tree);
    }
}

