/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;

@BugPattern(summary="Consider using a literal of the desired type instead of casting an int literal", severity=BugPattern.SeverityLevel.WARNING)
public class IntLiteralCast
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        String suffix;
        if (!tree.getKind().equals((Object)Tree.Kind.INT_LITERAL)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof TypeCastTree)) {
            return Description.NO_MATCH;
        }
        String source = state.getSourceForNode((Tree)tree);
        boolean decimal = !source.startsWith("0") || source.equals("0");
        switch (ASTHelpers.getType((Tree)parent).getTag()) {
            case LONG: {
                String string = "L";
                break;
            }
            case FLOAT: {
                String string;
                if (decimal) {
                    string = ".0f";
                    break;
                }
                string = "";
                break;
            }
            case DOUBLE: {
                String string;
                if (decimal) {
                    string = ".0";
                    break;
                }
                string = "";
                break;
            }
            default: {
                String string = suffix = "";
            }
        }
        if (suffix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(ASTHelpers.getStartPosition((Tree)parent), ASTHelpers.getStartPosition((Tree)tree), "").postfixWith((Tree)tree, suffix).build());
    }
}

