/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.WellKnownKeep;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@BugPattern(summary="If you don't intend to mutate a member collection prefer using Immutable types.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class ImmutableMemberCollection
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final ImmutableSet<String> MUTATING_METHODS = ImmutableSet.of((Object)"add", (Object)"addAll", (Object)"clear", (Object)"compute", (Object)"computeIfAbsent", (Object)"computeIfPresent", (Object[])new String[]{"forcePut", "merge", "pollFirst", "pollFirstEntry", "pollLast", "pollLastEntry", "put", "putAll", "putIfAbsent", "remove", "removeAll", "removeIf", "replace", "replaceAll", "replaceValues", "retainAll", "set", "sort"});
    private static final ImmutableSet<ReplaceableType<?>> REPLACEABLE_TYPES = ImmutableSet.of(ReplaceableType.create(NavigableSet.class, ImmutableSortedSet.class), ReplaceableType.create(Set.class, ImmutableSet.class), ReplaceableType.create(List.class, ImmutableList.class), ReplaceableType.create(ListMultimap.class, ImmutableListMultimap.class), ReplaceableType.create(SetMultimap.class, ImmutableSetMultimap.class), ReplaceableType.create(SortedMap.class, ImmutableSortedMap.class), (Object[])new ReplaceableType[]{ReplaceableType.create(Map.class, ImmutableMap.class)});
    private static final Matcher<Tree> PRIVATE_FINAL_VAR_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.VARIABLE), Matchers.hasModifier((Modifier)Modifier.PRIVATE), Matchers.hasModifier((Modifier)Modifier.FINAL)});
    private static final Matcher<Tree> EXCLUSIONS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotationWithSimpleName((String)"Bind"), Matchers.hasAnnotationWithSimpleName((String)"Inject")});
    private final WellKnownKeep wellKnownKeep;

    @Inject
    ImmutableMemberCollection(WellKnownKeep wellKnownKeep) {
        this.wellKnownKeep = wellKnownKeep;
    }

    public Description matchClass(ClassTree classTree, VisitorState state) {
        final ImmutableMap replaceableVars = (ImmutableMap)classTree.getMembers().stream().filter(member -> PRIVATE_FINAL_VAR_MATCHER.matches(member, state)).filter(member -> !this.wellKnownKeep.shouldKeep((Tree)member)).filter(member -> !EXCLUSIONS.matches(member, state)).filter(member -> !this.isSuppressed((Tree)member, state)).map(VariableTree.class::cast).flatMap(varTree -> ImmutableMemberCollection.isReplaceable(varTree, state).stream()).collect(ImmutableMap.toImmutableMap(ReplaceableVar::symbol, var -> var));
        if (replaceableVars.isEmpty()) {
            return Description.NO_MATCH;
        }
        final HashSet isPotentiallyMutated = new HashSet();
        final ImmutableSetMultimap.Builder initTreesBuilder = ImmutableSetMultimap.builder();
        new TreePathScanner<Void, VisitorState>(this){

            @Override
            public Void visitAssignment(AssignmentTree assignmentTree, VisitorState visitorState) {
                Symbol varSymbol = ASTHelpers.getSymbol((Tree)assignmentTree.getVariable());
                if (replaceableVars.containsKey((Object)varSymbol) && assignmentTree.getExpression() != null) {
                    initTreesBuilder.put((Object)varSymbol, (Object)assignmentTree.getExpression());
                }
                return (Void)this.scan(assignmentTree.getExpression(), visitorState);
            }

            @Override
            public Void visitVariable(VariableTree variableTree, VisitorState visitorState) {
                Symbol.VarSymbol varSym = ASTHelpers.getSymbol((VariableTree)variableTree);
                if (replaceableVars.containsKey((Object)varSym) && variableTree.getInitializer() != null) {
                    initTreesBuilder.put((Object)varSym, (Object)variableTree.getInitializer());
                }
                return (Void)super.visitVariable(variableTree, visitorState);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, VisitorState visitorState) {
                this.recordVarMutation(ASTHelpers.getSymbol((Tree)identifierTree));
                return (Void)super.visitIdentifier(identifierTree, visitorState);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, VisitorState visitorState) {
                this.recordVarMutation(ASTHelpers.getSymbol((Tree)memberSelectTree));
                return (Void)super.visitMemberSelect(memberSelectTree, visitorState);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState visitorState) {
                MemberSelectTree selectTree;
                ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
                if (replaceableVars.containsKey((Object)ASTHelpers.getSymbol((Tree)receiver)) && !MUTATING_METHODS.contains((Object)(selectTree = (MemberSelectTree)methodInvocationTree.getMethodSelect()).getIdentifier().toString())) {
                    methodInvocationTree.getTypeArguments().forEach(type -> this.scan((Tree)type, visitorState));
                    methodInvocationTree.getArguments().forEach(arg -> this.scan((Tree)arg, visitorState));
                    return null;
                }
                return (Void)super.visitMethodInvocation(methodInvocationTree, visitorState);
            }

            private void recordVarMutation(Symbol sym) {
                if (replaceableVars.containsKey((Object)sym)) {
                    isPotentiallyMutated.add(sym);
                }
            }
        }.scan(state.findPathToEnclosing(new Class[]{CompilationUnitTree.class}), state);
        ImmutableSetMultimap initTrees = initTreesBuilder.build();
        SuggestedFix.Builder suggestedFix = SuggestedFix.builder();
        replaceableVars.values().stream().filter(var -> var.areAllInitImmutable((ImmutableSet<Tree>)initTrees.get((Object)var.symbol()), state) || !isPotentiallyMutated.contains(var.symbol())).forEach(replaceableVar -> suggestedFix.merge(replaceableVar.getFix((ImmutableSet<Tree>)initTrees.get((Object)replaceableVar.symbol()), state)));
        if (suggestedFix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(classTree, (Fix)suggestedFix.build());
    }

    private static Optional<ReplaceableVar> isReplaceable(VariableTree tree, VisitorState state) {
        return REPLACEABLE_TYPES.stream().filter(type -> Matchers.isSameType(type.interfaceType()).matches((Tree)tree, state)).findFirst().map(type -> ReplaceableVar.create(tree, type));
    }

    record ReplaceableVar(Symbol symbol, ReplaceableType<?> type, Tree declaredType) {
        static ReplaceableVar create(VariableTree variableTree, ReplaceableType<?> type) {
            return new ReplaceableVar(ASTHelpers.getSymbol((VariableTree)variableTree), type, variableTree.getType());
        }

        private SuggestedFix getFix(ImmutableSet<Tree> initTrees, VisitorState state) {
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder().replace(ReplaceableVar.stripTypeParameters(this.declaredType()), this.type().immutableType().getSimpleName()).addImport(this.type().immutableType().getName());
            initTrees.stream().filter(initTree -> !Matchers.isSameType(this.type().immutableType()).matches(initTree, state)).forEach(init -> fixBuilder.replace(init, this.wrapWithImmutableCopy((Tree)init, state)));
            return fixBuilder.build();
        }

        private String wrapWithImmutableCopy(Tree tree, VisitorState state) {
            String type = this.type().immutableType().getSimpleName();
            return type + ".copyOf(" + state.getSourceForNode(tree) + ")";
        }

        private boolean areAllInitImmutable(ImmutableSet<Tree> initTrees, VisitorState state) {
            return initTrees.stream().allMatch(initTree -> Matchers.isSameType(this.type().immutableType()).matches(initTree, state));
        }

        private static Tree stripTypeParameters(Tree tree) {
            Tree tree2;
            if (tree instanceof ParameterizedTypeTree) {
                ParameterizedTypeTree parameterizedTypeTree = (ParameterizedTypeTree)tree;
                tree2 = parameterizedTypeTree.getType();
            } else {
                tree2 = tree;
            }
            return tree2;
        }
    }

    record ReplaceableType<M>(Class<M> interfaceType, Class<? extends M> immutableType) {
        static <M> ReplaceableType<M> create(Class<M> interfaceType, Class<? extends M> immutableType) {
            return new ReplaceableType<M>(interfaceType, immutableType);
        }
    }
}

