/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Collections;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Casting a lambda to this @FunctionalInterface can cause a behavior change from casting to a functional superinterface, which is surprising to users.  Prefer decorator methods to this surprising behavior.", severity=BugPattern.SeverityLevel.ERROR)
public class FunctionalInterfaceMethodChanged
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<Tree> IS_FUNCTIONAL_INTERFACE = Matchers.symbolHasAnnotation(FunctionalInterface.class);

    public Description matchMethod(MethodTree tree, VisitorState state) {
        ClassTree enclosingClazz = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (tree.getModifiers().getFlags().contains((Object)Modifier.DEFAULT) && IS_FUNCTIONAL_INTERFACE.matches((Tree)enclosingClazz, state)) {
            Types types = state.getTypes();
            ImmutableSet functionalSuperInterfaceSams = (ImmutableSet)enclosingClazz.getImplementsClause().stream().filter(t -> IS_FUNCTIONAL_INTERFACE.matches(t, state)).map(ASTHelpers::getSymbol).map(Symbol.TypeSymbol.class::cast).map(types::findDescriptorSymbol).collect(ImmutableSet.toImmutableSet());
            Symbol thisInterfaceSam = types.findDescriptorSymbol(ASTHelpers.getSymbol((ClassTree)enclosingClazz));
            BehaviorPreservingChecker behaviorPreserving = new BehaviorPreservingChecker(thisInterfaceSam);
            if (!Collections.disjoint(ASTHelpers.findSuperMethods((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)tree), (Types)types), functionalSuperInterfaceSams) && !tree.accept(behaviorPreserving, state).booleanValue()) {
                return this.describeMatch(tree);
            }
        }
        return Description.NO_MATCH;
    }

    private static class BehaviorPreservingChecker
    extends SimpleTreeVisitor<Boolean, VisitorState> {
        private boolean inBoxedVoidReturningMethod = false;
        private final Symbol methodToCall;

        BehaviorPreservingChecker(Symbol methodToCall) {
            super(false);
            this.methodToCall = methodToCall;
        }

        @Override
        public Boolean visitMethod(MethodTree node, VisitorState state) {
            Type boxedVoidType;
            boolean prevInBoxedVoidReturningMethod = this.inBoxedVoidReturningMethod;
            Type returnType = ASTHelpers.getType((Tree)node.getReturnType());
            if (ASTHelpers.isSameType((Type)returnType, (Type)(boxedVoidType = (Type)Suppliers.JAVA_LANG_VOID_TYPE.get(state)), (VisitorState)state)) {
                this.inBoxedVoidReturningMethod = true;
            }
            boolean result = node.getBody() != null && node.getBody().accept(this, state) != false;
            this.inBoxedVoidReturningMethod = prevInBoxedVoidReturningMethod;
            return result;
        }

        @Override
        public Boolean visitBlock(BlockTree node, VisitorState state) {
            if (this.inBoxedVoidReturningMethod) {
                ReturnTree returnTree;
                ExpressionTree expressionTree;
                if (node.getStatements().size() != 2) {
                    return false;
                }
                if (!node.getStatements().get(0).accept(this, state).booleanValue()) {
                    return false;
                }
                StatementTree statementTree = node.getStatements().get(1);
                if (statementTree instanceof ReturnTree && (expressionTree = (returnTree = (ReturnTree)statementTree).getExpression()) instanceof LiteralTree) {
                    LiteralTree literalTree = (LiteralTree)expressionTree;
                    Object returnValue = literalTree.getValue();
                    return returnValue == null;
                }
                return false;
            }
            return node.getStatements().size() == 1 && ((StatementTree)Iterables.getOnlyElement(node.getStatements())).accept(this, state) != false;
        }

        @Override
        public Boolean visitExpressionStatement(ExpressionStatementTree node, VisitorState state) {
            return node.getExpression().accept(this, state);
        }

        @Override
        public Boolean visitReturn(ReturnTree node, VisitorState state) {
            return node.getExpression().accept(this, state);
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            return ASTHelpers.getSymbol((MethodInvocationTree)node) == this.methodToCall;
        }
    }
}

