/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Empty top-level type declarations should be omitted", severity=BugPattern.SeverityLevel.WARNING)
public final class EmptyTopLevelDeclaration
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableList toDelete = (ImmutableList)tree.getTypeDecls().stream().filter(m -> m instanceof EmptyStatementTree).collect(ImmutableList.toImmutableList());
        if (toDelete.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        toDelete.forEach(x -> {
            int start = ASTHelpers.getStartPosition((Tree)x);
            int end = state.getEndPosition(x);
            if (end <= start) {
                end = start + 1;
            }
            fixBuilder.replace(start, end, "");
        });
        return this.describeMatch((Tree)toDelete.getFirst(), (Fix)fixBuilder.build());
    }
}

