/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Map;
import javax.inject.Inject;

@BugPattern(summary="This assertion is duplicate.", severity=BugPattern.SeverityLevel.WARNING)
public final class DuplicateAssertion
extends BugChecker
implements BugChecker.BlockTreeMatcher {
    private static final Matcher<ExpressionTree> JUNIT_ASSERT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.assertEqualsInvocation(), Matchers.assertNotEqualsInvocation()});
    private final ConstantExpressions constantExpressions;

    @Inject
    DuplicateAssertion(ConstantExpressions constantExpressions) {
        this.constantExpressions = constantExpressions;
    }

    public Description matchBlock(BlockTree tree, VisitorState state) {
        ImmutableSetMultimap<Assertion, Integer> assertionLines = this.extractAssertionLines(tree, state);
        for (Map.Entry entry : assertionLines.entries()) {
            Integer line;
            Assertion source = (Assertion)entry.getKey();
            if (!assertionLines.containsEntry((Object)source, (Object)((line = (Integer)entry.getValue()) - 1))) continue;
            state.reportMatch(this.buildDescription(tree.getStatements().get(line)).setMessage("This assertion is duplicated on the line above. Is that a mistake?").build());
        }
        return Description.NO_MATCH;
    }

    private ImmutableSetMultimap<Assertion, Integer> extractAssertionLines(BlockTree tree, VisitorState state) {
        ImmutableSetMultimap.Builder lines = ImmutableSetMultimap.builder();
        for (int i = 0; i < tree.getStatements().size(); ++i) {
            MethodInvocationTree mit;
            ExpressionStatementTree est;
            ExpressionTree expressionTree;
            int finalI = i;
            StatementTree statement = tree.getStatements().get(i);
            if (!(statement instanceof ExpressionStatementTree) || !((expressionTree = (est = (ExpressionStatementTree)statement).getExpression()) instanceof MethodInvocationTree)) continue;
            ExpressionTree receiver = mit = (MethodInvocationTree)expressionTree;
            while (receiver instanceof MethodInvocationTree) {
                MethodInvocationTree method = receiver;
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)method);
                if (JUNIT_ASSERT.matches((Tree)method, state)) {
                    this.constantExpressions.constantExpression(method.getArguments().get(DuplicateAssertion.argumentsToSkip(method, state) + 1), state).ifPresent(ce -> lines.put((Object)new Assertion(state.getSourceForNode((Tree)statement), (ConstantExpressions.ConstantExpression)ce), (Object)finalI));
                } else if (((Name)symbol.getSimpleName()).contentEquals("assertThat") && method.getArguments().size() == 1) {
                    this.constantExpressions.constantExpression((ExpressionTree)Iterables.getOnlyElement(method.getArguments()), state).ifPresent(ce -> lines.put((Object)new Assertion(state.getSourceForNode((Tree)statement), (ConstantExpressions.ConstantExpression)ce), (Object)finalI));
                }
                receiver = ASTHelpers.getReceiver((ExpressionTree)receiver);
            }
        }
        return lines.build();
    }

    private static int argumentsToSkip(MethodInvocationTree tree, VisitorState state) {
        java.util.List parameters = ASTHelpers.getSymbol((MethodInvocationTree)tree).getParameters();
        if (!ASTHelpers.isSameType((Type)((Symbol.VarSymbol)parameters.getFirst()).type, (Type)state.getSymtab().stringType, (VisitorState)state)) {
            return 0;
        }
        if (((List)parameters).size() == 2) {
            return 0;
        }
        return 1;
    }

    private record Assertion(String line, ConstantExpressions.ConstantExpression assertee) {
    }
}

