/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Make toString(), hashCode() and equals() final in AutoValue classes, so it is clear to readers that AutoValue is not overriding them", severity=BugPattern.SeverityLevel.WARNING)
public class AutoValueFinalMethods
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String MEMOIZED = "com.google.auto.value.extension.memoized.Memoized";
    private static final Matcher<MethodTree> METHOD_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.PUBLIC), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT)), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.FINAL)), Matchers.not((Matcher)Matchers.hasAnnotation((String)"com.google.auto.value.extension.memoized.Memoized")), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.equalsMethodDeclaration(), Matchers.toStringMethodDeclaration(), Matchers.hashCodeMethodDeclaration()})});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!ASTHelpers.hasAnnotation((Tree)tree, (String)"com.google.auto.value.AutoValue", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        ImmutableList candidateMethods = (ImmutableList)tree.getMembers().stream().filter(t -> {
            MethodTree methodTree;
            return t instanceof MethodTree && METHOD_MATCHER.matches((Tree)(methodTree = (MethodTree)t), state) && !this.isSuppressed((Tree)t, state);
        }).map(t -> (MethodTree)t).collect(ImmutableList.toImmutableList());
        SuggestedFix fix = candidateMethods.stream().flatMap(t -> SuggestedFixes.addModifiers((Tree)t, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).stream()).reduce(SuggestedFix.emptyFix(), (x$0, x$1) -> SuggestedFix.merge((SuggestedFix)x$0, (SuggestedFix)x$1, (SuggestedFix[])new SuggestedFix[0]));
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription((Tree)candidateMethods.getFirst()).setMessage(String.format("Make %s final in AutoValue classes, so it is clear to readers that AutoValue is not overriding them", candidateMethods.stream().map(t -> t.getName().toString()).collect(Collectors.joining(", ")))).addFix((Fix)fix).build();
    }
}

