/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InitializedClassUtil;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.AnalyzedObject;
import proguard.evaluation.value.object.ArrayModel;
import proguard.evaluation.value.object.ArrayObject;
import proguard.evaluation.value.object.Model;
import proguard.evaluation.value.object.ModeledObject;
import proguard.evaluation.value.object.NullObject;
import proguard.evaluation.value.object.PreciseObject;
import proguard.evaluation.value.object.TypedNullObject;

public class AnalyzedObjectFactory {
    private AnalyzedObjectFactory() {
    }

    public static AnalyzedObject create(@Nullable Object value, @Nullable String type, @Nullable Clazz referencedClass) {
        if (value == null && type == null) {
            AnalyzedObjectFactory.checkValidNullObject(referencedClass);
            return AnalyzedObjectFactory.createNull();
        }
        AnalyzedObjectFactory.checkValidType(type);
        if (value == null) {
            AnalyzedObjectFactory.checkValidTypedNullObject(type, referencedClass);
            return AnalyzedObjectFactory.createNullOfType(type);
        }
        if (value instanceof Model) {
            Model model = (Model)value;
            AnalyzedObjectFactory.checkValidModel(model, referencedClass);
            return AnalyzedObjectFactory.createModeled(model);
        }
        AnalyzedObjectFactory.checkValidPrecise(value, type, referencedClass);
        return AnalyzedObjectFactory.createPrecise(value);
    }

    private static void checkValidNullObject(Clazz referencedClass) {
        if (referencedClass != null) {
            throw new IllegalStateException(String.format("'type' is null while 'referencedClass' is \"%s\", should 'type' be the one from 'referencedClass'?", referencedClass.getName()));
        }
    }

    private static void checkValidType(String type) {
        if (type == null) {
            throw new IllegalStateException("'type' should be null just for null 'value'");
        }
        if (!ClassUtil.isInternalType(type)) {
            throw new IllegalStateException(String.format("the 'type' \"%s\" has an invalid format, should be an internal type (e.g., 'Ljava/lang/String;')", type));
        }
    }

    private static void checkValidTypedNullObject(String type, Clazz referencedClass) {
        String referencedType;
        if (referencedClass != null && !type.equals(referencedType = ClassUtil.internalTypeFromClassName(referencedClass.getName()))) {
            throw new IllegalStateException(String.format("'value' is null but 'type' \"%s\" is not the type of 'referencedClass' \"%s\"", type, referencedType));
        }
    }

    private static void checkValidModel(Model model, Clazz referencedClass) {
        if (referencedClass != null && !InitializedClassUtil.isInstanceOf(model.getType(), referencedClass)) {
            throw new IllegalStateException(String.format("The type \"%s\" of model \"%s\" does not extend the referenced clazz \"%s\"", model.getType(), model, referencedClass.getName()));
        }
    }

    private static void checkValidPrecise(Object value, String type, Clazz referencedClass) {
        String objectType = ClassUtil.internalType(value.getClass().getTypeName());
        if (referencedClass == null && !type.equals(objectType)) {
            throw new IllegalStateException(String.format("The referenced clazz is null, the type \"%s\" of the object needs to be exactly the provided type \"%s\"", objectType, type));
        }
        if (referencedClass != null && !InitializedClassUtil.isInstanceOf(objectType, referencedClass)) {
            throw new IllegalStateException(String.format("The type \"%s\" of the object does not extend the referenced clazz \"%s\"", type, referencedClass.getName()));
        }
    }

    public static AnalyzedObject createPrecise(@NotNull Object value) {
        Objects.requireNonNull(value, "'value' can't be null");
        if (value instanceof Model) {
            throw new IllegalStateException("Models should not be used to create precise values");
        }
        return new PreciseObject(value);
    }

    public static AnalyzedObject createModeled(@NotNull Model value) {
        Objects.requireNonNull(value, "'value' can't be null");
        if (value instanceof ArrayModel) {
            return new ArrayObject((ArrayModel)value);
        }
        return new ModeledObject(value);
    }

    public static AnalyzedObject createNullOfType(@NotNull String type) {
        Objects.requireNonNull(type, "'type' can't be null");
        return new TypedNullObject(type);
    }

    public static AnalyzedObject createNull() {
        return NullObject.INSTANCE;
    }

    public static AnalyzedObject createDetailedArray(Value[] values, String type) {
        return new ArrayObject(new ArrayModel(values, type));
    }
}

