/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberRenamer
implements MemberVisitor {
    private final BiFunction<Clazz, Member, String> memberNameFunction;
    private final MemberVisitor extraMemberVisitor;

    public MemberRenamer(BiFunction<Clazz, Member, String> memberNameFunction) {
        this(memberNameFunction, null);
    }

    public MemberRenamer(Function<Clazz, String> classNameFunction, MemberVisitor extraMemberVisitor) {
        this((Clazz clazz, Member member) -> member.getName((Clazz)clazz), extraMemberVisitor);
    }

    public MemberRenamer(BiFunction<Clazz, Member, String> memberNameFunction, MemberVisitor extraMemberVisitor) {
        this.memberNameFunction = memberNameFunction;
        this.extraMemberVisitor = extraMemberVisitor;
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        String name = programMember.getName(programClass);
        String newName = this.memberNameFunction.apply(programClass, programMember);
        if (newName != null && !newName.equals(name)) {
            programMember.u2nameIndex = new ConstantPoolEditor(programClass).addUtf8Constant(newName);
            if (this.extraMemberVisitor != null) {
                programMember.accept(programClass, this.extraMemberVisitor);
            }
        }
    }

    @Override
    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        String name = libraryMember.getName(libraryClass);
        String newName = this.memberNameFunction.apply(libraryClass, libraryMember);
        if (newName != null && !newName.equals(name)) {
            libraryMember.name = newName;
            if (this.extraMemberVisitor != null) {
                libraryMember.accept(libraryClass, this.extraMemberVisitor);
            }
        }
    }
}

