// Copyright 2021 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.devtools.build.lib.platform;

import static com.google.common.base.Preconditions.checkNotNull;

import com.google.devtools.build.lib.analysis.BlazeDirectories;
import com.google.devtools.build.lib.runtime.BlazeModule;
import com.google.devtools.build.lib.runtime.BlazeRuntime;
import com.google.devtools.build.lib.runtime.CommandEnvironment;
import com.google.devtools.build.lib.runtime.WorkspaceBuilder;

/** Responsible for registering the current reporter with the SystemMemoryPressureMonitor. */
public final class SystemMemoryPressureModule extends BlazeModule {

  public SystemMemoryPressureModule() {}

  @Override
  public void workspaceInit(
      BlazeRuntime runtime, BlazeDirectories directories, WorkspaceBuilder builder) {
    SystemMemoryPressureMonitor.getInstance()
        .registerJniService(checkNotNull(runtime.getBlazeService(PlatformNativeDepsService.class)));
  }

  @Override
  public synchronized void beforeCommand(CommandEnvironment env) {
    SystemMemoryPressureMonitor.getInstance().setReporter(env.getReporter());
  }

  @Override
  public synchronized void afterCommand() {
    SystemMemoryPressureMonitor.getInstance().setReporter(null);
  }
}
