// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: build/bazel/remote/execution/v2/remote_execution.proto
// Protobuf Java Version: 4.33.4

package build.bazel.remote.execution.v2;

/**
 * <pre>
 * An `Action` captures all the information about an execution which is required
 * to reproduce it.
 *
 * `Action`s are the core component of the [Execution] service. A single
 * `Action` represents a repeatable action that can be performed by the
 * execution service. `Action`s can be succinctly identified by the digest of
 * their wire format encoding and, once an `Action` has been executed, will be
 * cached in the action cache. Future requests can then use the cached result
 * rather than needing to run afresh.
 *
 * When a server completes execution of an
 * [Action][build.bazel.remote.execution.v2.Action], it MAY choose to
 * cache the [result][build.bazel.remote.execution.v2.ActionResult] in
 * the [ActionCache][build.bazel.remote.execution.v2.ActionCache] unless
 * `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
 * default, future calls to
 * [Execute][build.bazel.remote.execution.v2.Execution.Execute] the same
 * `Action` will also serve their results from the cache. Clients must take care
 * to understand the caching behaviour. Ideally, all `Action`s will be
 * reproducible so that serving a result from cache is always desirable and
 * correct.
 * </pre>
 *
 * Protobuf type {@code build.bazel.remote.execution.v2.Action}
 */
@com.google.protobuf.Generated
public final class Action extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:build.bazel.remote.execution.v2.Action)
    ActionOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 33,
      /* patch= */ 4,
      /* suffix= */ "",
      "Action");
  }
  // Use Action.newBuilder() to construct.
  private Action(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private Action() {
    salt_ = com.google.protobuf.ByteString.EMPTY;
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            build.bazel.remote.execution.v2.Action.class, build.bazel.remote.execution.v2.Action.Builder.class);
  }

  private int bitField0_;
  public static final int COMMAND_DIGEST_FIELD_NUMBER = 1;
  private build.bazel.remote.execution.v2.Digest commandDigest_;
  /**
   * <pre>
   * The digest of the [Command][build.bazel.remote.execution.v2.Command]
   * to run, which MUST be present in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
   * @return Whether the commandDigest field is set.
   */
  @java.lang.Override
  public boolean hasCommandDigest() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * The digest of the [Command][build.bazel.remote.execution.v2.Command]
   * to run, which MUST be present in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
   * @return The commandDigest.
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.Digest getCommandDigest() {
    return commandDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : commandDigest_;
  }
  /**
   * <pre>
   * The digest of the [Command][build.bazel.remote.execution.v2.Command]
   * to run, which MUST be present in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.DigestOrBuilder getCommandDigestOrBuilder() {
    return commandDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : commandDigest_;
  }

  public static final int INPUT_ROOT_DIGEST_FIELD_NUMBER = 2;
  private build.bazel.remote.execution.v2.Digest inputRootDigest_;
  /**
   * <pre>
   * The digest of the root
   * [Directory][build.bazel.remote.execution.v2.Directory] for the input
   * files. The files in the directory tree are available in the correct
   * location on the build machine before the command is executed. The root
   * directory, as well as every subdirectory and content blob referred to, MUST
   * be in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
   * @return Whether the inputRootDigest field is set.
   */
  @java.lang.Override
  public boolean hasInputRootDigest() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * The digest of the root
   * [Directory][build.bazel.remote.execution.v2.Directory] for the input
   * files. The files in the directory tree are available in the correct
   * location on the build machine before the command is executed. The root
   * directory, as well as every subdirectory and content blob referred to, MUST
   * be in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
   * @return The inputRootDigest.
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.Digest getInputRootDigest() {
    return inputRootDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : inputRootDigest_;
  }
  /**
   * <pre>
   * The digest of the root
   * [Directory][build.bazel.remote.execution.v2.Directory] for the input
   * files. The files in the directory tree are available in the correct
   * location on the build machine before the command is executed. The root
   * directory, as well as every subdirectory and content blob referred to, MUST
   * be in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.DigestOrBuilder getInputRootDigestOrBuilder() {
    return inputRootDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : inputRootDigest_;
  }

  public static final int TIMEOUT_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration timeout_;
  /**
   * <pre>
   * A timeout after which the execution should be killed. If the timeout is
   * absent, then the client is specifying that the execution should continue
   * as long as the server will let it. The server SHOULD impose a timeout if
   * the client does not specify one, however, if the client does specify a
   * timeout that is longer than the server's maximum timeout, the server MUST
   * reject the request.
   *
   * The timeout is only intended to cover the "execution" of the specified
   * action and not time in queue nor any overheads before or after execution
   * such as marshalling inputs/outputs. The server SHOULD avoid including time
   * spent the client doesn't have control over, and MAY extend or reduce the
   * timeout to account for delays or speedups that occur during execution
   * itself (e.g., lazily loading data from the Content Addressable Storage,
   * live migration of virtual machines, emulation overhead).
   *
   * The timeout is a part of the
   * [Action][build.bazel.remote.execution.v2.Action] message, and
   * therefore two `Actions` with different timeouts are different, even if they
   * are otherwise identical. This is because, if they were not, running an
   * `Action` with a lower timeout than is required might result in a cache hit
   * from an execution run with a longer timeout, hiding the fact that the
   * timeout is too short. By encoding it directly in the `Action`, a lower
   * timeout will result in a cache miss and the execution timeout will fail
   * immediately, rather than whenever the cache entry gets evicted.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * A timeout after which the execution should be killed. If the timeout is
   * absent, then the client is specifying that the execution should continue
   * as long as the server will let it. The server SHOULD impose a timeout if
   * the client does not specify one, however, if the client does specify a
   * timeout that is longer than the server's maximum timeout, the server MUST
   * reject the request.
   *
   * The timeout is only intended to cover the "execution" of the specified
   * action and not time in queue nor any overheads before or after execution
   * such as marshalling inputs/outputs. The server SHOULD avoid including time
   * spent the client doesn't have control over, and MAY extend or reduce the
   * timeout to account for delays or speedups that occur during execution
   * itself (e.g., lazily loading data from the Content Addressable Storage,
   * live migration of virtual machines, emulation overhead).
   *
   * The timeout is a part of the
   * [Action][build.bazel.remote.execution.v2.Action] message, and
   * therefore two `Actions` with different timeouts are different, even if they
   * are otherwise identical. This is because, if they were not, running an
   * `Action` with a lower timeout than is required might result in a cache hit
   * from an execution run with a longer timeout, hiding the fact that the
   * timeout is too short. By encoding it directly in the `Action`, a lower
   * timeout will result in a cache miss and the execution timeout will fail
   * immediately, rather than whenever the cache entry gets evicted.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   * <pre>
   * A timeout after which the execution should be killed. If the timeout is
   * absent, then the client is specifying that the execution should continue
   * as long as the server will let it. The server SHOULD impose a timeout if
   * the client does not specify one, however, if the client does specify a
   * timeout that is longer than the server's maximum timeout, the server MUST
   * reject the request.
   *
   * The timeout is only intended to cover the "execution" of the specified
   * action and not time in queue nor any overheads before or after execution
   * such as marshalling inputs/outputs. The server SHOULD avoid including time
   * spent the client doesn't have control over, and MAY extend or reduce the
   * timeout to account for delays or speedups that occur during execution
   * itself (e.g., lazily loading data from the Content Addressable Storage,
   * live migration of virtual machines, emulation overhead).
   *
   * The timeout is a part of the
   * [Action][build.bazel.remote.execution.v2.Action] message, and
   * therefore two `Actions` with different timeouts are different, even if they
   * are otherwise identical. This is because, if they were not, running an
   * `Action` with a lower timeout than is required might result in a cache hit
   * from an execution run with a longer timeout, hiding the fact that the
   * timeout is too short. By encoding it directly in the `Action`, a lower
   * timeout will result in a cache miss and the execution timeout will fail
   * immediately, rather than whenever the cache entry gets evicted.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int DO_NOT_CACHE_FIELD_NUMBER = 7;
  private boolean doNotCache_ = false;
  /**
   * <pre>
   * If true, then the `Action`'s result cannot be cached, and in-flight
   * requests for the same `Action` may not be merged.
   * </pre>
   *
   * <code>bool do_not_cache = 7;</code>
   * @return The doNotCache.
   */
  @java.lang.Override
  public boolean getDoNotCache() {
    return doNotCache_;
  }

  public static final int SALT_FIELD_NUMBER = 9;
  private com.google.protobuf.ByteString salt_ = com.google.protobuf.ByteString.EMPTY;
  /**
   * <pre>
   * An optional additional salt value used to place this `Action` into a
   * separate cache namespace from other instances having the same field
   * contents. This salt typically comes from operational configuration
   * specific to sources such as repo and service configuration,
   * and allows disowning an entire set of ActionResults that might have been
   * poisoned by buggy software or tool failures.
   * </pre>
   *
   * <code>bytes salt = 9;</code>
   * @return The salt.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSalt() {
    return salt_;
  }

  public static final int PLATFORM_FIELD_NUMBER = 10;
  private build.bazel.remote.execution.v2.Platform platform_;
  /**
   * <pre>
   * The optional platform requirements for the execution environment. The
   * server MAY choose to execute the action on any worker satisfying the
   * requirements, so the client SHOULD ensure that running the action on any
   * such worker will have the same result.  A detailed lexicon for this can be
   * found in the accompanying platform.md.
   * New in version 2.2: clients SHOULD set these platform properties as well
   * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
   * SHOULD prefer those set here.
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
   * @return Whether the platform field is set.
   */
  @java.lang.Override
  public boolean hasPlatform() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * The optional platform requirements for the execution environment. The
   * server MAY choose to execute the action on any worker satisfying the
   * requirements, so the client SHOULD ensure that running the action on any
   * such worker will have the same result.  A detailed lexicon for this can be
   * found in the accompanying platform.md.
   * New in version 2.2: clients SHOULD set these platform properties as well
   * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
   * SHOULD prefer those set here.
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
   * @return The platform.
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.Platform getPlatform() {
    return platform_ == null ? build.bazel.remote.execution.v2.Platform.getDefaultInstance() : platform_;
  }
  /**
   * <pre>
   * The optional platform requirements for the execution environment. The
   * server MAY choose to execute the action on any worker satisfying the
   * requirements, so the client SHOULD ensure that running the action on any
   * such worker will have the same result.  A detailed lexicon for this can be
   * found in the accompanying platform.md.
   * New in version 2.2: clients SHOULD set these platform properties as well
   * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
   * SHOULD prefer those set here.
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.PlatformOrBuilder getPlatformOrBuilder() {
    return platform_ == null ? build.bazel.remote.execution.v2.Platform.getDefaultInstance() : platform_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCommandDigest());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getInputRootDigest());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getTimeout());
    }
    if (doNotCache_ != false) {
      output.writeBool(7, doNotCache_);
    }
    if (!salt_.isEmpty()) {
      output.writeBytes(9, salt_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getPlatform());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getCommandDigest());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getInputRootDigest());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getTimeout());
    }
    if (doNotCache_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(7, doNotCache_);
    }
    if (!salt_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream
        .computeBytesSize(9, salt_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, getPlatform());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof build.bazel.remote.execution.v2.Action)) {
      return super.equals(obj);
    }
    build.bazel.remote.execution.v2.Action other = (build.bazel.remote.execution.v2.Action) obj;

    if (hasCommandDigest() != other.hasCommandDigest()) return false;
    if (hasCommandDigest()) {
      if (!getCommandDigest()
          .equals(other.getCommandDigest())) return false;
    }
    if (hasInputRootDigest() != other.hasInputRootDigest()) return false;
    if (hasInputRootDigest()) {
      if (!getInputRootDigest()
          .equals(other.getInputRootDigest())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout()
          .equals(other.getTimeout())) return false;
    }
    if (getDoNotCache()
        != other.getDoNotCache()) return false;
    if (!getSalt()
        .equals(other.getSalt())) return false;
    if (hasPlatform() != other.hasPlatform()) return false;
    if (hasPlatform()) {
      if (!getPlatform()
          .equals(other.getPlatform())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCommandDigest()) {
      hash = (37 * hash) + COMMAND_DIGEST_FIELD_NUMBER;
      hash = (53 * hash) + getCommandDigest().hashCode();
    }
    if (hasInputRootDigest()) {
      hash = (37 * hash) + INPUT_ROOT_DIGEST_FIELD_NUMBER;
      hash = (53 * hash) + getInputRootDigest().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + DO_NOT_CACHE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getDoNotCache());
    hash = (37 * hash) + SALT_FIELD_NUMBER;
    hash = (53 * hash) + getSalt().hashCode();
    if (hasPlatform()) {
      hash = (37 * hash) + PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getPlatform().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static build.bazel.remote.execution.v2.Action parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static build.bazel.remote.execution.v2.Action parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static build.bazel.remote.execution.v2.Action parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(build.bazel.remote.execution.v2.Action prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An `Action` captures all the information about an execution which is required
   * to reproduce it.
   *
   * `Action`s are the core component of the [Execution] service. A single
   * `Action` represents a repeatable action that can be performed by the
   * execution service. `Action`s can be succinctly identified by the digest of
   * their wire format encoding and, once an `Action` has been executed, will be
   * cached in the action cache. Future requests can then use the cached result
   * rather than needing to run afresh.
   *
   * When a server completes execution of an
   * [Action][build.bazel.remote.execution.v2.Action], it MAY choose to
   * cache the [result][build.bazel.remote.execution.v2.ActionResult] in
   * the [ActionCache][build.bazel.remote.execution.v2.ActionCache] unless
   * `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
   * default, future calls to
   * [Execute][build.bazel.remote.execution.v2.Execution.Execute] the same
   * `Action` will also serve their results from the cache. Clients must take care
   * to understand the caching behaviour. Ideally, all `Action`s will be
   * reproducible so that serving a result from cache is always desirable and
   * correct.
   * </pre>
   *
   * Protobuf type {@code build.bazel.remote.execution.v2.Action}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:build.bazel.remote.execution.v2.Action)
      build.bazel.remote.execution.v2.ActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              build.bazel.remote.execution.v2.Action.class, build.bazel.remote.execution.v2.Action.Builder.class);
    }

    // Construct using build.bazel.remote.execution.v2.Action.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage
              .alwaysUseFieldBuilders) {
        internalGetCommandDigestFieldBuilder();
        internalGetInputRootDigestFieldBuilder();
        internalGetTimeoutFieldBuilder();
        internalGetPlatformFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      commandDigest_ = null;
      if (commandDigestBuilder_ != null) {
        commandDigestBuilder_.dispose();
        commandDigestBuilder_ = null;
      }
      inputRootDigest_ = null;
      if (inputRootDigestBuilder_ != null) {
        inputRootDigestBuilder_.dispose();
        inputRootDigestBuilder_ = null;
      }
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      doNotCache_ = false;
      salt_ = com.google.protobuf.ByteString.EMPTY;
      platform_ = null;
      if (platformBuilder_ != null) {
        platformBuilder_.dispose();
        platformBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_descriptor;
    }

    @java.lang.Override
    public build.bazel.remote.execution.v2.Action getDefaultInstanceForType() {
      return build.bazel.remote.execution.v2.Action.getDefaultInstance();
    }

    @java.lang.Override
    public build.bazel.remote.execution.v2.Action build() {
      build.bazel.remote.execution.v2.Action result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public build.bazel.remote.execution.v2.Action buildPartial() {
      build.bazel.remote.execution.v2.Action result = new build.bazel.remote.execution.v2.Action(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(build.bazel.remote.execution.v2.Action result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.commandDigest_ = commandDigestBuilder_ == null
            ? commandDigest_
            : commandDigestBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.inputRootDigest_ = inputRootDigestBuilder_ == null
            ? inputRootDigest_
            : inputRootDigestBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.timeout_ = timeoutBuilder_ == null
            ? timeout_
            : timeoutBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.doNotCache_ = doNotCache_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.salt_ = salt_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.platform_ = platformBuilder_ == null
            ? platform_
            : platformBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof build.bazel.remote.execution.v2.Action) {
        return mergeFrom((build.bazel.remote.execution.v2.Action)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(build.bazel.remote.execution.v2.Action other) {
      if (other == build.bazel.remote.execution.v2.Action.getDefaultInstance()) return this;
      if (other.hasCommandDigest()) {
        mergeCommandDigest(other.getCommandDigest());
      }
      if (other.hasInputRootDigest()) {
        mergeInputRootDigest(other.getInputRootDigest());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.getDoNotCache() != false) {
        setDoNotCache(other.getDoNotCache());
      }
      if (!other.getSalt().isEmpty()) {
        setSalt(other.getSalt());
      }
      if (other.hasPlatform()) {
        mergePlatform(other.getPlatform());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              input.readMessage(
                  internalGetCommandDigestFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              input.readMessage(
                  internalGetInputRootDigestFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 50: {
              input.readMessage(
                  internalGetTimeoutFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000004;
              break;
            } // case 50
            case 56: {
              doNotCache_ = input.readBool();
              bitField0_ |= 0x00000008;
              break;
            } // case 56
            case 74: {
              salt_ = input.readBytes();
              bitField0_ |= 0x00000010;
              break;
            } // case 74
            case 82: {
              input.readMessage(
                  internalGetPlatformFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000020;
              break;
            } // case 82
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private build.bazel.remote.execution.v2.Digest commandDigest_;
    private com.google.protobuf.SingleFieldBuilder<
        build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder> commandDigestBuilder_;
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     * @return Whether the commandDigest field is set.
     */
    public boolean hasCommandDigest() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     * @return The commandDigest.
     */
    public build.bazel.remote.execution.v2.Digest getCommandDigest() {
      if (commandDigestBuilder_ == null) {
        return commandDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : commandDigest_;
      } else {
        return commandDigestBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public Builder setCommandDigest(build.bazel.remote.execution.v2.Digest value) {
      if (commandDigestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commandDigest_ = value;
      } else {
        commandDigestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public Builder setCommandDigest(
        build.bazel.remote.execution.v2.Digest.Builder builderForValue) {
      if (commandDigestBuilder_ == null) {
        commandDigest_ = builderForValue.build();
      } else {
        commandDigestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public Builder mergeCommandDigest(build.bazel.remote.execution.v2.Digest value) {
      if (commandDigestBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0) &&
          commandDigest_ != null &&
          commandDigest_ != build.bazel.remote.execution.v2.Digest.getDefaultInstance()) {
          getCommandDigestBuilder().mergeFrom(value);
        } else {
          commandDigest_ = value;
        }
      } else {
        commandDigestBuilder_.mergeFrom(value);
      }
      if (commandDigest_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public Builder clearCommandDigest() {
      bitField0_ = (bitField0_ & ~0x00000001);
      commandDigest_ = null;
      if (commandDigestBuilder_ != null) {
        commandDigestBuilder_.dispose();
        commandDigestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public build.bazel.remote.execution.v2.Digest.Builder getCommandDigestBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return internalGetCommandDigestFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public build.bazel.remote.execution.v2.DigestOrBuilder getCommandDigestOrBuilder() {
      if (commandDigestBuilder_ != null) {
        return commandDigestBuilder_.getMessageOrBuilder();
      } else {
        return commandDigest_ == null ?
            build.bazel.remote.execution.v2.Digest.getDefaultInstance() : commandDigest_;
      }
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder> 
        internalGetCommandDigestFieldBuilder() {
      if (commandDigestBuilder_ == null) {
        commandDigestBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder>(
                getCommandDigest(),
                getParentForChildren(),
                isClean());
        commandDigest_ = null;
      }
      return commandDigestBuilder_;
    }

    private build.bazel.remote.execution.v2.Digest inputRootDigest_;
    private com.google.protobuf.SingleFieldBuilder<
        build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder> inputRootDigestBuilder_;
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     * @return Whether the inputRootDigest field is set.
     */
    public boolean hasInputRootDigest() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     * @return The inputRootDigest.
     */
    public build.bazel.remote.execution.v2.Digest getInputRootDigest() {
      if (inputRootDigestBuilder_ == null) {
        return inputRootDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : inputRootDigest_;
      } else {
        return inputRootDigestBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public Builder setInputRootDigest(build.bazel.remote.execution.v2.Digest value) {
      if (inputRootDigestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputRootDigest_ = value;
      } else {
        inputRootDigestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public Builder setInputRootDigest(
        build.bazel.remote.execution.v2.Digest.Builder builderForValue) {
      if (inputRootDigestBuilder_ == null) {
        inputRootDigest_ = builderForValue.build();
      } else {
        inputRootDigestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public Builder mergeInputRootDigest(build.bazel.remote.execution.v2.Digest value) {
      if (inputRootDigestBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0) &&
          inputRootDigest_ != null &&
          inputRootDigest_ != build.bazel.remote.execution.v2.Digest.getDefaultInstance()) {
          getInputRootDigestBuilder().mergeFrom(value);
        } else {
          inputRootDigest_ = value;
        }
      } else {
        inputRootDigestBuilder_.mergeFrom(value);
      }
      if (inputRootDigest_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public Builder clearInputRootDigest() {
      bitField0_ = (bitField0_ & ~0x00000002);
      inputRootDigest_ = null;
      if (inputRootDigestBuilder_ != null) {
        inputRootDigestBuilder_.dispose();
        inputRootDigestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public build.bazel.remote.execution.v2.Digest.Builder getInputRootDigestBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return internalGetInputRootDigestFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public build.bazel.remote.execution.v2.DigestOrBuilder getInputRootDigestOrBuilder() {
      if (inputRootDigestBuilder_ != null) {
        return inputRootDigestBuilder_.getMessageOrBuilder();
      } else {
        return inputRootDigest_ == null ?
            build.bazel.remote.execution.v2.Digest.getDefaultInstance() : inputRootDigest_;
      }
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder> 
        internalGetInputRootDigestFieldBuilder() {
      if (inputRootDigestBuilder_ == null) {
        inputRootDigestBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder>(
                getInputRootDigest(),
                getParentForChildren(),
                isClean());
        inputRootDigest_ = null;
      }
      return inputRootDigestBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilder<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> timeoutBuilder_;
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     *
     * The timeout is only intended to cover the "execution" of the specified
     * action and not time in queue nor any overheads before or after execution
     * such as marshalling inputs/outputs. The server SHOULD avoid including time
     * spent the client doesn't have control over, and MAY extend or reduce the
     * timeout to account for delays or speedups that occur during execution
     * itself (e.g., lazily loading data from the Content Addressable Storage,
     * live migration of virtual machines, emulation overhead).
     *
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     *
     * The timeout is only intended to cover the "execution" of the specified
     * action and not time in queue nor any overheads before or after execution
     * such as marshalling inputs/outputs. The server SHOULD avoid including time
     * spent the client doesn't have control over, and MAY extend or reduce the
     * timeout to account for delays or speedups that occur during execution
     * itself (e.g., lazily loading data from the Content Addressable Storage,
     * live migration of virtual machines, emulation overhead).
     *
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     *
     * The timeout is only intended to cover the "execution" of the specified
     * action and not time in queue nor any overheads before or after execution
     * such as marshalling inputs/outputs. The server SHOULD avoid including time
     * spent the client doesn't have control over, and MAY extend or reduce the
     * timeout to account for delays or speedups that occur during execution
     * itself (e.g., lazily loading data from the Content Addressable Storage,
     * live migration of virtual machines, emulation overhead).
     *
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     *
     * The timeout is only intended to cover the "execution" of the specified
     * action and not time in queue nor any overheads before or after execution
     * such as marshalling inputs/outputs. The server SHOULD avoid including time
     * spent the client doesn't have control over, and MAY extend or reduce the
     * timeout to account for delays or speedups that occur during execution
     * itself (e.g., lazily loading data from the Content Addressable Storage,
     * live migration of virtual machines, emulation overhead).
     *
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     *
     * The timeout is only intended to cover the "execution" of the specified
     * action and not time in queue nor any overheads before or after execution
     * such as marshalling inputs/outputs. The server SHOULD avoid including time
     * spent the client doesn't have control over, and MAY extend or reduce the
     * timeout to account for delays or speedups that occur during execution
     * itself (e.g., lazily loading data from the Content Addressable Storage,
     * live migration of virtual machines, emulation overhead).
     *
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0) &&
          timeout_ != null &&
          timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      if (timeout_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     *
     * The timeout is only intended to cover the "execution" of the specified
     * action and not time in queue nor any overheads before or after execution
     * such as marshalling inputs/outputs. The server SHOULD avoid including time
     * spent the client doesn't have control over, and MAY extend or reduce the
     * timeout to account for delays or speedups that occur during execution
     * itself (e.g., lazily loading data from the Content Addressable Storage,
     * live migration of virtual machines, emulation overhead).
     *
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000004);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     *
     * The timeout is only intended to cover the "execution" of the specified
     * action and not time in queue nor any overheads before or after execution
     * such as marshalling inputs/outputs. The server SHOULD avoid including time
     * spent the client doesn't have control over, and MAY extend or reduce the
     * timeout to account for delays or speedups that occur during execution
     * itself (e.g., lazily loading data from the Content Addressable Storage,
     * live migration of virtual machines, emulation overhead).
     *
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return internalGetTimeoutFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     *
     * The timeout is only intended to cover the "execution" of the specified
     * action and not time in queue nor any overheads before or after execution
     * such as marshalling inputs/outputs. The server SHOULD avoid including time
     * spent the client doesn't have control over, and MAY extend or reduce the
     * timeout to account for delays or speedups that occur during execution
     * itself (e.g., lazily loading data from the Content Addressable Storage,
     * live migration of virtual machines, emulation overhead).
     *
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ?
            com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     *
     * The timeout is only intended to cover the "execution" of the specified
     * action and not time in queue nor any overheads before or after execution
     * such as marshalling inputs/outputs. The server SHOULD avoid including time
     * spent the client doesn't have control over, and MAY extend or reduce the
     * timeout to account for delays or speedups that occur during execution
     * itself (e.g., lazily loading data from the Content Addressable Storage,
     * live migration of virtual machines, emulation overhead).
     *
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> 
        internalGetTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder>(
                getTimeout(),
                getParentForChildren(),
                isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private boolean doNotCache_ ;
    /**
     * <pre>
     * If true, then the `Action`'s result cannot be cached, and in-flight
     * requests for the same `Action` may not be merged.
     * </pre>
     *
     * <code>bool do_not_cache = 7;</code>
     * @return The doNotCache.
     */
    @java.lang.Override
    public boolean getDoNotCache() {
      return doNotCache_;
    }
    /**
     * <pre>
     * If true, then the `Action`'s result cannot be cached, and in-flight
     * requests for the same `Action` may not be merged.
     * </pre>
     *
     * <code>bool do_not_cache = 7;</code>
     * @param value The doNotCache to set.
     * @return This builder for chaining.
     */
    public Builder setDoNotCache(boolean value) {

      doNotCache_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, then the `Action`'s result cannot be cached, and in-flight
     * requests for the same `Action` may not be merged.
     * </pre>
     *
     * <code>bool do_not_cache = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearDoNotCache() {
      bitField0_ = (bitField0_ & ~0x00000008);
      doNotCache_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString salt_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     * An optional additional salt value used to place this `Action` into a
     * separate cache namespace from other instances having the same field
     * contents. This salt typically comes from operational configuration
     * specific to sources such as repo and service configuration,
     * and allows disowning an entire set of ActionResults that might have been
     * poisoned by buggy software or tool failures.
     * </pre>
     *
     * <code>bytes salt = 9;</code>
     * @return The salt.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSalt() {
      return salt_;
    }
    /**
     * <pre>
     * An optional additional salt value used to place this `Action` into a
     * separate cache namespace from other instances having the same field
     * contents. This salt typically comes from operational configuration
     * specific to sources such as repo and service configuration,
     * and allows disowning an entire set of ActionResults that might have been
     * poisoned by buggy software or tool failures.
     * </pre>
     *
     * <code>bytes salt = 9;</code>
     * @param value The salt to set.
     * @return This builder for chaining.
     */
    public Builder setSalt(com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      salt_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * An optional additional salt value used to place this `Action` into a
     * separate cache namespace from other instances having the same field
     * contents. This salt typically comes from operational configuration
     * specific to sources such as repo and service configuration,
     * and allows disowning an entire set of ActionResults that might have been
     * poisoned by buggy software or tool failures.
     * </pre>
     *
     * <code>bytes salt = 9;</code>
     * @return This builder for chaining.
     */
    public Builder clearSalt() {
      bitField0_ = (bitField0_ & ~0x00000010);
      salt_ = getDefaultInstance().getSalt();
      onChanged();
      return this;
    }

    private build.bazel.remote.execution.v2.Platform platform_;
    private com.google.protobuf.SingleFieldBuilder<
        build.bazel.remote.execution.v2.Platform, build.bazel.remote.execution.v2.Platform.Builder, build.bazel.remote.execution.v2.PlatformOrBuilder> platformBuilder_;
    /**
     * <pre>
     * The optional platform requirements for the execution environment. The
     * server MAY choose to execute the action on any worker satisfying the
     * requirements, so the client SHOULD ensure that running the action on any
     * such worker will have the same result.  A detailed lexicon for this can be
     * found in the accompanying platform.md.
     * New in version 2.2: clients SHOULD set these platform properties as well
     * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
     * SHOULD prefer those set here.
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
     * @return Whether the platform field is set.
     */
    public boolean hasPlatform() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * The optional platform requirements for the execution environment. The
     * server MAY choose to execute the action on any worker satisfying the
     * requirements, so the client SHOULD ensure that running the action on any
     * such worker will have the same result.  A detailed lexicon for this can be
     * found in the accompanying platform.md.
     * New in version 2.2: clients SHOULD set these platform properties as well
     * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
     * SHOULD prefer those set here.
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
     * @return The platform.
     */
    public build.bazel.remote.execution.v2.Platform getPlatform() {
      if (platformBuilder_ == null) {
        return platform_ == null ? build.bazel.remote.execution.v2.Platform.getDefaultInstance() : platform_;
      } else {
        return platformBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The optional platform requirements for the execution environment. The
     * server MAY choose to execute the action on any worker satisfying the
     * requirements, so the client SHOULD ensure that running the action on any
     * such worker will have the same result.  A detailed lexicon for this can be
     * found in the accompanying platform.md.
     * New in version 2.2: clients SHOULD set these platform properties as well
     * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
     * SHOULD prefer those set here.
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
     */
    public Builder setPlatform(build.bazel.remote.execution.v2.Platform value) {
      if (platformBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platform_ = value;
      } else {
        platformBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The optional platform requirements for the execution environment. The
     * server MAY choose to execute the action on any worker satisfying the
     * requirements, so the client SHOULD ensure that running the action on any
     * such worker will have the same result.  A detailed lexicon for this can be
     * found in the accompanying platform.md.
     * New in version 2.2: clients SHOULD set these platform properties as well
     * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
     * SHOULD prefer those set here.
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
     */
    public Builder setPlatform(
        build.bazel.remote.execution.v2.Platform.Builder builderForValue) {
      if (platformBuilder_ == null) {
        platform_ = builderForValue.build();
      } else {
        platformBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The optional platform requirements for the execution environment. The
     * server MAY choose to execute the action on any worker satisfying the
     * requirements, so the client SHOULD ensure that running the action on any
     * such worker will have the same result.  A detailed lexicon for this can be
     * found in the accompanying platform.md.
     * New in version 2.2: clients SHOULD set these platform properties as well
     * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
     * SHOULD prefer those set here.
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
     */
    public Builder mergePlatform(build.bazel.remote.execution.v2.Platform value) {
      if (platformBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0) &&
          platform_ != null &&
          platform_ != build.bazel.remote.execution.v2.Platform.getDefaultInstance()) {
          getPlatformBuilder().mergeFrom(value);
        } else {
          platform_ = value;
        }
      } else {
        platformBuilder_.mergeFrom(value);
      }
      if (platform_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * The optional platform requirements for the execution environment. The
     * server MAY choose to execute the action on any worker satisfying the
     * requirements, so the client SHOULD ensure that running the action on any
     * such worker will have the same result.  A detailed lexicon for this can be
     * found in the accompanying platform.md.
     * New in version 2.2: clients SHOULD set these platform properties as well
     * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
     * SHOULD prefer those set here.
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
     */
    public Builder clearPlatform() {
      bitField0_ = (bitField0_ & ~0x00000020);
      platform_ = null;
      if (platformBuilder_ != null) {
        platformBuilder_.dispose();
        platformBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The optional platform requirements for the execution environment. The
     * server MAY choose to execute the action on any worker satisfying the
     * requirements, so the client SHOULD ensure that running the action on any
     * such worker will have the same result.  A detailed lexicon for this can be
     * found in the accompanying platform.md.
     * New in version 2.2: clients SHOULD set these platform properties as well
     * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
     * SHOULD prefer those set here.
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
     */
    public build.bazel.remote.execution.v2.Platform.Builder getPlatformBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return internalGetPlatformFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The optional platform requirements for the execution environment. The
     * server MAY choose to execute the action on any worker satisfying the
     * requirements, so the client SHOULD ensure that running the action on any
     * such worker will have the same result.  A detailed lexicon for this can be
     * found in the accompanying platform.md.
     * New in version 2.2: clients SHOULD set these platform properties as well
     * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
     * SHOULD prefer those set here.
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
     */
    public build.bazel.remote.execution.v2.PlatformOrBuilder getPlatformOrBuilder() {
      if (platformBuilder_ != null) {
        return platformBuilder_.getMessageOrBuilder();
      } else {
        return platform_ == null ?
            build.bazel.remote.execution.v2.Platform.getDefaultInstance() : platform_;
      }
    }
    /**
     * <pre>
     * The optional platform requirements for the execution environment. The
     * server MAY choose to execute the action on any worker satisfying the
     * requirements, so the client SHOULD ensure that running the action on any
     * such worker will have the same result.  A detailed lexicon for this can be
     * found in the accompanying platform.md.
     * New in version 2.2: clients SHOULD set these platform properties as well
     * as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
     * SHOULD prefer those set here.
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Platform platform = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        build.bazel.remote.execution.v2.Platform, build.bazel.remote.execution.v2.Platform.Builder, build.bazel.remote.execution.v2.PlatformOrBuilder> 
        internalGetPlatformFieldBuilder() {
      if (platformBuilder_ == null) {
        platformBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            build.bazel.remote.execution.v2.Platform, build.bazel.remote.execution.v2.Platform.Builder, build.bazel.remote.execution.v2.PlatformOrBuilder>(
                getPlatform(),
                getParentForChildren(),
                isClean());
        platform_ = null;
      }
      return platformBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:build.bazel.remote.execution.v2.Action)
  }

  // @@protoc_insertion_point(class_scope:build.bazel.remote.execution.v2.Action)
  private static final build.bazel.remote.execution.v2.Action DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new build.bazel.remote.execution.v2.Action();
  }

  public static build.bazel.remote.execution.v2.Action getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Action>
      PARSER = new com.google.protobuf.AbstractParser<Action>() {
    @java.lang.Override
    public Action parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<Action> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Action> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public build.bazel.remote.execution.v2.Action getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

