/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.Set;
import javax.lang.model.element.Modifier;

public enum Visibility implements Comparable<Visibility>
{
    NONE{

        @Override
        public boolean shouldBeVisible(Tree tree, VisitorState state) {
            return false;
        }

        @Override
        public boolean shouldBeVisible(Symbol symbol, VisitorState state) {
            return false;
        }

        @Override
        public String description() {
            return "not be used";
        }
    }
    ,
    PRIVATE{

        @Override
        public boolean shouldBeVisible(Tree tree, VisitorState state) {
            return this.shouldBeVisible(ASTHelpers.getSymbol(tree), state);
        }

        @Override
        public boolean shouldBeVisible(Symbol symbol, VisitorState state) {
            Symbol outermostClass = null;
            for (Tree parent : state.getPath()) {
                if (!(parent instanceof ClassTree)) continue;
                outermostClass = ASTHelpers.getSymbol(parent);
            }
            return outermostClass == null || ASTHelpers.outermostClass(symbol).equals(outermostClass);
        }

        @Override
        public String description() {
            return "private visibility";
        }
    }
    ,
    PACKAGE_PRIVATE{

        @Override
        public boolean shouldBeVisible(Tree tree, VisitorState state) {
            return PACKAGE_PRIVATE.shouldBeVisible(ASTHelpers.getSymbol(tree), state);
        }

        @Override
        public boolean shouldBeVisible(Symbol symbol, VisitorState state) {
            JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
            Symbol.PackageSymbol packge = compilationUnit.packge;
            return ASTHelpers.enclosingPackage(symbol).equals(packge);
        }

        @Override
        public String description() {
            return "default (package private) visibility";
        }
    }
    ,
    PROTECTED{

        @Override
        public boolean shouldBeVisible(Tree tree, VisitorState state) {
            MemberSelectTree memberSelectTree;
            if (PACKAGE_PRIVATE.shouldBeVisible(tree, state)) {
                return true;
            }
            Symbol symbol = ASTHelpers.getSymbol(tree);
            ClassTree classTree = ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class);
            if (ASTHelpers.isStatic(symbol)) {
                if (classTree == null) {
                    return false;
                }
                return this.hasEnclosingClassExtending(ASTHelpers.enclosingClass((Symbol)symbol).type, state, classTree);
            }
            if (tree instanceof NewClassTree) {
                return false;
            }
            if (!(tree instanceof ExpressionTree)) {
                return this.hasEnclosingClassExtending(ASTHelpers.enclosingClass((Symbol)symbol).type, state, classTree);
            }
            ExpressionTree expressionTree = (ExpressionTree)tree;
            if (tree instanceof MemberSelectTree && (memberSelectTree = (MemberSelectTree)tree).getIdentifier().contentEquals("super")) {
                return true;
            }
            if (tree instanceof MemberSelectTree || tree instanceof MemberReferenceTree) {
                ExpressionTree receiver = ASTHelpers.getReceiver(expressionTree);
                return receiver.toString().equals("super") || this.hasEnclosingClassOfSuperType(ASTHelpers.getType(receiver), state, classTree);
            }
            return true;
        }

        @Override
        public boolean shouldBeVisible(Symbol symbol, VisitorState state) {
            if (PACKAGE_PRIVATE.shouldBeVisible(symbol, state)) {
                return true;
            }
            ClassTree classTree = ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class);
            return classTree != null && this.hasEnclosingClassExtending(ASTHelpers.enclosingClass((Symbol)symbol).type, state, classTree);
        }

        private boolean hasEnclosingClassOfSuperType(Type type, VisitorState state, ClassTree classTree) {
            Symbol.ClassSymbol encl = ASTHelpers.getSymbol(classTree);
            while (encl != null && !encl.isStatic()) {
                if (ASTHelpers.isSubtype(type, encl.type, state)) {
                    return true;
                }
                encl = ASTHelpers.enclosingClass(encl);
            }
            return false;
        }

        private boolean hasEnclosingClassExtending(Type type, VisitorState state, ClassTree classTree) {
            Symbol.ClassSymbol encl = ASTHelpers.getSymbol(classTree);
            while (encl != null && !encl.isStatic()) {
                if (ASTHelpers.isSubtype(encl.type, type, state)) {
                    return true;
                }
                encl = ASTHelpers.enclosingClass(encl);
            }
            return false;
        }

        @Override
        public String description() {
            return "protected visibility";
        }
    }
    ,
    PUBLIC{

        @Override
        public boolean shouldBeVisible(Tree tree, VisitorState state) {
            return true;
        }

        @Override
        public boolean shouldBeVisible(Symbol symbol, VisitorState state) {
            return true;
        }

        @Override
        public String description() {
            return "public visibility";
        }
    };


    public abstract boolean shouldBeVisible(Tree var1, VisitorState var2);

    public abstract boolean shouldBeVisible(Symbol var1, VisitorState var2);

    public static Visibility fromModifiers(Set<Modifier> modifiers) {
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return PRIVATE;
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return PUBLIC;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return PROTECTED;
        }
        return PACKAGE_PRIVATE;
    }

    public boolean isAtLeastAsRestrictiveAs(Visibility visibility) {
        return this.compareTo(visibility) <= 0;
    }

    public boolean isMoreVisibleThan(Visibility visibility) {
        return this.compareTo(visibility) > 0;
    }

    public abstract String description();
}

