/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Commented;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.DeconstructionPatternTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Position;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class Comments {
    public static ImmutableList<Commented> findCommentsForArguments(NewClassTree newClassTree, VisitorState state) {
        int startPosition = ASTHelpers.getStartPosition(newClassTree);
        return Comments.findCommentsForArguments(newClassTree, newClassTree.getArguments(), startPosition, state);
    }

    public static ImmutableList<Commented> findCommentsForArguments(MethodInvocationTree methodInvocationTree, VisitorState state) {
        int startPosition = state.getEndPosition(methodInvocationTree.getMethodSelect());
        return Comments.findCommentsForArguments(methodInvocationTree, methodInvocationTree.getArguments(), startPosition, state);
    }

    public static ImmutableList<Commented> findCommentsForArguments(DeconstructionPatternTree deconstructionPatternTree, VisitorState state) {
        int startPosition = state.getEndPosition(deconstructionPatternTree.getDeconstructor());
        return Comments.findCommentsForArguments(deconstructionPatternTree, deconstructionPatternTree.getNestedPatterns(), startPosition, state);
    }

    public static String getTextFromComment(ErrorProneComment comment) {
        return switch (comment.getStyle()) {
            default -> throw new MatchException(null, null);
            case ErrorProneComment.ErrorProneCommentStyle.BLOCK -> comment.getText().replaceAll("^\\s*/\\*\\s*(.*?)\\s*\\*/\\s*", "$1");
            case ErrorProneComment.ErrorProneCommentStyle.LINE -> comment.getText().replaceAll("^\\s*//\\s*", "");
            case ErrorProneComment.ErrorProneCommentStyle.JAVADOC_LINE -> comment.getText().replaceAll("^\\s*///\\s*", "");
            case ErrorProneComment.ErrorProneCommentStyle.JAVADOC_BLOCK -> comment.getText().replaceAll("^\\s*/\\*\\*\\s*(.*?)\\s*\\*/\\s*", "$1");
        };
    }

    private static ImmutableList<Commented> findCommentsForArguments(Tree tree, List<? extends Tree> arguments, int invocationStart, VisitorState state) {
        if (arguments.isEmpty()) {
            return ImmutableList.of();
        }
        CharSequence sourceCode = state.getSourceCode();
        Optional<Integer> endPosition = Comments.computeEndPosition(tree, sourceCode, state);
        if (endPosition.isEmpty()) {
            return Comments.noComments(arguments);
        }
        CharSequence source = sourceCode.subSequence(invocationStart, endPosition.get());
        if (CharMatcher.is((char)'/').matchesNoneOf(source)) {
            return Comments.noComments(arguments);
        }
        int invocationEnd = state.getEndPosition(tree) - invocationStart;
        TreeRangeSet exclude = TreeRangeSet.create();
        arguments.forEach(arg -> exclude.add(Range.closed((Comparable)Integer.valueOf(ASTHelpers.getStartPosition(arg) - invocationStart), (Comparable)Integer.valueOf(state.getEndPosition((Tree)arg) - invocationStart))));
        ErrorProneTokens errorProneTokens = new ErrorProneTokens(source.toString(), state.context);
        ImmutableList<ErrorProneToken> tokens = errorProneTokens.getTokens();
        Position.LineMap lineMap = errorProneTokens.getLineMap();
        ArgumentTracker argumentTracker = new ArgumentTracker(arguments, invocationStart, state, lineMap);
        TokenTracker tokenTracker = new TokenTracker(lineMap);
        argumentTracker.advance();
        for (ErrorProneToken token : tokens) {
            tokenTracker.advance(token);
            if (tokenTracker.atStartOfLine() && !tokenTracker.wasPreviousLineEmpty()) {
                for (ErrorProneComment comment : token.comments()) {
                    int commentStart = comment.getPos();
                    int commentEnd = comment.getEndPos();
                    if (exclude.intersects(Range.closedOpen((Comparable)Integer.valueOf(commentStart), (Comparable)Integer.valueOf(commentEnd)))) continue;
                    if (tokenTracker.isCommentOnPreviousLine(comment) && token.pos() <= argumentTracker.currentArgumentStartPosition && argumentTracker.isPreviousArgumentOnPreviousLine()) {
                        argumentTracker.addCommentToPreviousArgument(comment, Commented.Position.ANY);
                        continue;
                    }
                    if (commentStart > invocationEnd && lineMap.getLineNumber(commentStart) > lineMap.getLineNumber(argumentTracker.currentArgumentEndPosition)) continue;
                    argumentTracker.addCommentToCurrentArgument(comment, Commented.Position.ANY);
                }
            } else {
                if (token.pos() == argumentTracker.currentArgumentStartPosition) {
                    argumentTracker.addAllCommentsToCurrentArgument((Iterable<ErrorProneComment>)token.comments(), Commented.Position.BEFORE);
                }
                if (token.endPos() > argumentTracker.currentArgumentEndPosition) {
                    argumentTracker.addAllCommentsToCurrentArgument((Iterable<ErrorProneComment>)token.comments(), Commented.Position.AFTER);
                }
            }
            if (token.pos() < argumentTracker.currentArgumentEndPosition || token.kind() != Tokens.TokenKind.COMMA) continue;
            if (!argumentTracker.hasMoreArguments()) break;
            argumentTracker.advance();
        }
        return argumentTracker.build();
    }

    private static ImmutableList<Commented> noComments(List<? extends Tree> arguments) {
        return (ImmutableList)arguments.stream().map(a -> Commented.builder().setTree((Tree)a).build()).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    static Optional<Integer> computeEndPosition(Tree methodInvocationTree, CharSequence sourceCode, VisitorState state) {
        int invocationEnd = state.getEndPosition(methodInvocationTree);
        if (invocationEnd == -1) {
            return Optional.empty();
        }
        int nextNewLine = CharMatcher.is((char)'\n').indexIn(sourceCode, invocationEnd);
        if (nextNewLine == -1) {
            return Optional.of(invocationEnd);
        }
        if (CharMatcher.is((char)'/').matchesNoneOf(sourceCode.subSequence(invocationEnd, nextNewLine))) {
            return Optional.of(invocationEnd);
        }
        int nextNodeEnd = state.getEndPosition(Comments.getNextNodeOrParent(methodInvocationTree, state));
        if (nextNodeEnd == -1) {
            return Optional.of(invocationEnd);
        }
        MethodScanner scanner = new MethodScanner(invocationEnd, nextNodeEnd);
        scanner.scan(state.getPath().getParentPath().getLeaf(), null);
        return Optional.of(scanner.startOfNextMethodInvocation == -1 ? nextNodeEnd : scanner.startOfNextMethodInvocation);
    }

    private static Tree getNextNodeOrParent(Tree current, VisitorState state) {
        TreePath enclosingPath;
        Tree predecessorNode = current;
        for (enclosingPath = state.getPath(); enclosingPath != null && !(enclosingPath.getLeaf() instanceof BlockTree) && !(enclosingPath.getLeaf() instanceof ClassTree); enclosingPath = enclosingPath.getParentPath()) {
            predecessorNode = enclosingPath.getLeaf();
        }
        if (enclosingPath == null) {
            return state.getPath().getParentPath().getLeaf();
        }
        Tree parent = enclosingPath.getLeaf();
        if (parent instanceof BlockTree) {
            BlockTree blockTree = (BlockTree)parent;
            return Comments.after(predecessorNode, blockTree.getStatements(), parent);
        }
        if (parent instanceof ClassTree) {
            ClassTree classTree = (ClassTree)parent;
            return Comments.after(predecessorNode, classTree.getMembers(), parent);
        }
        return parent;
    }

    private static <T> T after(T target, Iterable<? extends T> iterable, T defaultValue) {
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext() && !iterator.next().equals(target)) {
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return defaultValue;
    }

    private Comments() {
    }

    private static class ArgumentTracker {
        private final VisitorState state;
        private final Iterator<? extends Tree> argumentsIterator;
        private final int offset;
        private final Position.LineMap lineMap;
        private Commented.Builder currentCommentedResultBuilder = null;
        private Commented.Builder previousCommentedResultBuilder = null;
        private final ImmutableList.Builder<Commented> resultBuilder = ImmutableList.builder();
        private int currentArgumentStartPosition = -1;
        private int currentArgumentEndPosition = -1;
        private int previousArgumentEndPosition = -1;

        ArgumentTracker(Iterable<? extends Tree> arguments, int offset, VisitorState state, Position.LineMap lineMap) {
            this.state = state;
            this.offset = offset;
            this.argumentsIterator = arguments.iterator();
            this.lineMap = lineMap;
        }

        void advance() {
            Tree nextArgument = this.argumentsIterator.next();
            this.currentArgumentEndPosition = this.state.getEndPosition(nextArgument) - this.offset;
            this.previousArgumentEndPosition = this.currentArgumentStartPosition;
            this.currentArgumentStartPosition = ASTHelpers.getStartPosition(nextArgument) - this.offset;
            if (this.previousCommentedResultBuilder != null) {
                this.resultBuilder.add((Object)this.previousCommentedResultBuilder.build());
            }
            this.previousCommentedResultBuilder = this.currentCommentedResultBuilder;
            this.currentCommentedResultBuilder = Commented.builder().setTree(nextArgument);
        }

        ImmutableList<Commented> build() {
            if (this.previousCommentedResultBuilder != null) {
                this.resultBuilder.add((Object)this.previousCommentedResultBuilder.build());
            }
            if (this.currentCommentedResultBuilder != null) {
                this.resultBuilder.add((Object)this.currentCommentedResultBuilder.build());
            }
            return this.resultBuilder.build();
        }

        boolean isPreviousArgumentOnPreviousLine() {
            return this.lineMap.getLineNumber(this.previousArgumentEndPosition) == this.lineMap.getLineNumber(this.currentArgumentStartPosition) - 1;
        }

        void addCommentToPreviousArgument(ErrorProneComment c, Commented.Position position) {
            this.previousCommentedResultBuilder.addComment(c, this.previousArgumentEndPosition, this.offset, position);
        }

        void addCommentToCurrentArgument(ErrorProneComment c, Commented.Position position) {
            this.currentCommentedResultBuilder.addComment(c, this.currentArgumentStartPosition, this.offset, position);
        }

        void addAllCommentsToCurrentArgument(Iterable<ErrorProneComment> comments, Commented.Position position) {
            this.currentCommentedResultBuilder.addAllComment(comments, this.currentArgumentStartPosition, this.offset, position);
        }

        boolean hasMoreArguments() {
            return this.argumentsIterator.hasNext();
        }
    }

    private static class TokenTracker {
        private final Position.LineMap lineMap;
        private int tokensOnCurrentLine = 0;
        private int currentLineNumber = -1;
        private boolean previousLineEmpty = true;

        TokenTracker(Position.LineMap lineMap) {
            this.lineMap = lineMap;
        }

        void advance(ErrorProneToken token) {
            int line = this.lineMap.getLineNumber(token.pos());
            if (line != this.currentLineNumber) {
                this.currentLineNumber = line;
                this.previousLineEmpty = this.tokensOnCurrentLine == 0;
                this.tokensOnCurrentLine = 0;
            } else {
                ++this.tokensOnCurrentLine;
            }
        }

        boolean isCommentOnPreviousLine(ErrorProneComment c) {
            int tokenLine = this.lineMap.getLineNumber(c.getSourcePos(0));
            return tokenLine == this.currentLineNumber - 1;
        }

        boolean atStartOfLine() {
            return this.tokensOnCurrentLine == 0;
        }

        boolean wasPreviousLineEmpty() {
            return this.previousLineEmpty;
        }
    }

    static class MethodScanner
    extends TreeScanner<Void, Void> {
        public int startOfNextMethodInvocation = -1;
        int invocationEnd;
        int nextNodeEnd;

        MethodScanner(int invocationEnd, int nextNodeEnd) {
            this.invocationEnd = invocationEnd;
            this.nextNodeEnd = nextNodeEnd;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
            int start = ASTHelpers.getStartPosition(methodInvocationTree);
            if (this.invocationEnd < start && start < this.nextNodeEnd && (start < this.startOfNextMethodInvocation || this.startOfNextMethodInvocation == -1)) {
                this.startOfNextMethodInvocation = start;
            }
            return (Void)super.visitMethodInvocation(methodInvocationTree, null);
        }
    }
}

