/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.google.common.collect.ImmutableList;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.checkerframework.errorprone.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.errorprone.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.errorprone.javacutil.TreeUtils;
import org.jspecify.annotations.Nullable;

public record AccessPath(@Nullable Element base, ImmutableList<String> path) {
    public static boolean isAutoValueAccessor(Tree tree) {
        Type type;
        if (!(tree instanceof MethodInvocationTree)) {
            return false;
        }
        JCTree.JCMethodInvocation invocationTree = (JCTree.JCMethodInvocation)tree;
        JCTree.JCExpression methodSelect = invocationTree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)methodSelect;
            type = jCFieldAccess.selected.type;
        } else {
            type = ((JCTree.JCIdent)methodSelect).sym.owner.type;
        }
        Type rcvrType = type;
        return ((List)invocationTree.getArguments()).isEmpty() && TreeUtils.elementFromUse((MethodInvocationTree)invocationTree).getModifiers().contains((Object)Modifier.ABSTRACT) && rcvrType.tsym.getKind() == ElementKind.CLASS && rcvrType.tsym.getAnnotationMirrors().stream().anyMatch(a -> ((TypeElement)a.getAnnotationType().asElement()).getQualifiedName().contentEquals("com.google.auto.value.AutoValue"));
    }

    public static @Nullable AccessPath fromFieldAccess(FieldAccessNode fieldAccess) {
        IdentifierTree id;
        boolean isFieldAccess;
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        Tree tree = fieldAccess.getTree();
        while ((isFieldAccess = TreeUtils.isFieldAccess((Tree)tree)) || AccessPath.isAutoValueAccessor(tree)) {
            if (isFieldAccess) {
                pathBuilder.add((Object)TreeUtils.getFieldName((Tree)tree));
            } else {
                tree = ((MethodInvocationTree)tree).getMethodSelect();
                pathBuilder.add((Object)(TreeUtils.getMethodName((Tree)tree) + "()"));
            }
            if (tree instanceof IdentifierTree) {
                return new AccessPath(null, (ImmutableList<String>)pathBuilder.build());
            }
            tree = ((MemberSelectTree)tree).getExpression();
        }
        if (tree instanceof IdentifierTree && (id = (IdentifierTree)tree).getName().contentEquals("this")) {
            return new AccessPath(null, (ImmutableList<String>)pathBuilder.build());
        }
        if (tree instanceof IdentifierTree) {
            return new AccessPath(TreeUtils.elementFromTree((Tree)tree), (ImmutableList<String>)pathBuilder.build());
        }
        return null;
    }

    public static AccessPath fromLocalVariable(LocalVariableNode node) {
        return new AccessPath(node.getElement(), (ImmutableList<String>)ImmutableList.of());
    }

    public static AccessPath fromVariableDecl(VariableDeclarationNode node) {
        return new AccessPath(TreeUtils.elementFromDeclaration((VariableTree)node.getTree()), (ImmutableList<String>)ImmutableList.of());
    }

    public static @Nullable AccessPath fromNodeIfTrackable(Node node) {
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalVariableNode.class, VariableDeclarationNode.class, FieldAccessNode.class, AssignmentNode.class}, (Object)node3, n)) {
            case 0 -> {
                LocalVariableNode localVariableNode = (LocalVariableNode)node3;
                yield AccessPath.fromLocalVariable(localVariableNode);
            }
            case 1 -> {
                VariableDeclarationNode variableDeclarationNode = (VariableDeclarationNode)node3;
                yield AccessPath.fromVariableDecl(variableDeclarationNode);
            }
            case 2 -> {
                FieldAccessNode fieldAccessNode = (FieldAccessNode)node3;
                yield AccessPath.fromFieldAccess(fieldAccessNode);
            }
            case 3 -> {
                AssignmentNode assignmentNode = (AssignmentNode)node3;
                yield AccessPath.fromNodeIfTrackable(assignmentNode.getTarget());
            }
            default -> null;
        };
    }
}

