/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.errorprone.ErrorProneVersion;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import javax.tools.JavaFileObject;

public class ErrorProneError
extends Error {
    private final String checkName;
    private final Throwable cause;
    private final JCDiagnostic.DiagnosticPosition pos;
    private final JavaFileObject source;

    public ErrorProneError(String checkName, Throwable cause, JCDiagnostic.DiagnosticPosition pos, JavaFileObject source) {
        super(ErrorProneError.formatMessage(checkName, source, pos, cause), cause, true, false);
        this.checkName = checkName;
        this.cause = cause;
        this.pos = pos;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logFatalError(Log log, Context context) {
        String version = (String)ErrorProneVersion.loadVersionFromPom().or((Object)"unknown version");
        JavaFileObject originalSource = log.useSource(this.source);
        JCDiagnostic.Factory factory = JCDiagnostic.Factory.instance(context);
        try {
            log.report(factory.create(JCDiagnostic.DiagnosticType.ERROR, log.currentSource(), this.pos, "error.prone.crash", Throwables.getStackTraceAsString((Throwable)this.cause), version, this.checkName));
        }
        finally {
            log.useSource(originalSource);
        }
    }

    private static String formatMessage(String checkName, JavaFileObject file, JCDiagnostic.DiagnosticPosition pos, Throwable cause) {
        DiagnosticSource source = new DiagnosticSource(file, null);
        int column = source.getColumnNumber(pos.getStartPosition(), true);
        int line = source.getLineNumber(pos.getStartPosition());
        String snippet = source.getLine(pos.getStartPosition());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n%s:%d: %s: An exception was thrown by Error Prone: %s\n", source.getFile().getName(), line, checkName, cause.getMessage()));
        sb.append(snippet).append('\n');
        if (column > 0) {
            sb.append(Strings.repeat((String)" ", (int)(column - 1)));
        }
        sb.append("^\n");
        return sb.toString();
    }

    public String checkName() {
        return this.checkName;
    }
}

