/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineElement;
import com.google.turbine.processing.TurbineTypeMirror;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import com.google.turbine.types.Deannotate;
import com.google.turbine.types.Erasure;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.jspecify.annotations.Nullable;

public class TurbineTypes
implements Types {
    private final ModelFactory factory;

    public TurbineTypes(ModelFactory factory) {
        this.factory = factory;
    }

    private static Type asTurbineType(TypeMirror typeMirror) {
        if (!(typeMirror instanceof TurbineTypeMirror)) {
            throw new IllegalArgumentException(typeMirror.toString());
        }
        TurbineTypeMirror turbineTypeMirror = (TurbineTypeMirror)typeMirror;
        return turbineTypeMirror.asTurbineType();
    }

    @Override
    public @Nullable Element asElement(TypeMirror t) {
        return switch (t.getKind()) {
            case TypeKind.DECLARED -> ((TurbineTypeMirror.TurbineDeclaredType)t).asElement();
            case TypeKind.TYPEVAR -> ((TurbineTypeMirror.TurbineTypeVariable)t).asElement();
            case TypeKind.ERROR -> ((TurbineTypeMirror.TurbineErrorType)t).asElement();
            default -> null;
        };
    }

    @Override
    public boolean isSameType(TypeMirror a, TypeMirror b) {
        Type t1 = TurbineTypes.asTurbineType(a);
        Type t2 = TurbineTypes.asTurbineType(b);
        if (t1.tyKind() == Type.TyKind.WILD_TY || t2.tyKind() == Type.TyKind.WILD_TY) {
            return false;
        }
        return this.isSameType(t1, t2);
    }

    private boolean isSameType(Type a, Type b) {
        if (b.tyKind() == Type.TyKind.ERROR_TY) {
            return true;
        }
        return switch (a.tyKind()) {
            default -> throw new MatchException(null, null);
            case Type.TyKind.PRIM_TY -> {
                if (b.tyKind() == Type.TyKind.PRIM_TY && ((Type.PrimTy)a).primkind() == ((Type.PrimTy)b).primkind()) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.VOID_TY -> {
                if (b.tyKind() == Type.TyKind.VOID_TY) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.NONE_TY -> {
                if (b.tyKind() == Type.TyKind.NONE_TY) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.CLASS_TY -> this.isSameClassType((Type.ClassTy)a, b);
            case Type.TyKind.ARRAY_TY -> {
                if (b.tyKind() == Type.TyKind.ARRAY_TY && this.isSameType(((Type.ArrayTy)a).elementType(), ((Type.ArrayTy)b).elementType())) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.TY_VAR -> {
                if (b.tyKind() == Type.TyKind.TY_VAR && ((Type.TyVar)a).sym().equals(((Type.TyVar)b).sym())) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.WILD_TY -> this.isSameWildType((Type.WildTy)a, b);
            case Type.TyKind.INTERSECTION_TY -> {
                if (b.tyKind() == Type.TyKind.INTERSECTION_TY && this.isSameIntersectionType((Type.IntersectionTy)a, (Type.IntersectionTy)b)) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.METHOD_TY -> {
                if (b.tyKind() == Type.TyKind.METHOD_TY && this.isSameMethodType((Type.MethodTy)a, (Type.MethodTy)b)) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.ERROR_TY -> true;
        };
    }

    private boolean isSameMethodType(Type.MethodTy a, Type.MethodTy b) {
        ImmutableMap<TyVarSymbol, Type> mapping = TurbineTypes.getMapping(a, b);
        if (mapping == null) {
            return false;
        }
        if (!this.sameTypeParameterBounds(a, b, mapping)) {
            return false;
        }
        if (!this.isSameType(a.returnType(), this.subst(b.returnType(), (Map<TyVarSymbol, Type>)mapping))) {
            return false;
        }
        return this.isSameTypes(a.parameters(), this.substAll((ImmutableList<? extends Type>)b.parameters(), (Map<TyVarSymbol, Type>)mapping));
    }

    private boolean sameTypeParameterBounds(Type.MethodTy a, Type.MethodTy b, ImmutableMap<TyVarSymbol, Type> mapping) {
        if (a.tyParams().size() != b.tyParams().size()) {
            return false;
        }
        UnmodifiableIterator ax = a.tyParams().iterator();
        UnmodifiableIterator bx = b.tyParams().iterator();
        while (ax.hasNext()) {
            TyVarSymbol x = (TyVarSymbol)ax.next();
            TyVarSymbol y = (TyVarSymbol)bx.next();
            if (this.isSameType(this.factory.getTyVarInfo(x).upperBound(), this.subst(this.factory.getTyVarInfo(y).upperBound(), (Map<TyVarSymbol, Type>)mapping))) continue;
            return false;
        }
        return true;
    }

    private boolean isSameTypes(ImmutableList<Type> a, ImmutableList<Type> b) {
        if (a.size() != b.size()) {
            return false;
        }
        UnmodifiableIterator ax = a.iterator();
        UnmodifiableIterator bx = b.iterator();
        while (ax.hasNext()) {
            if (this.isSameType((Type)ax.next(), (Type)bx.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSameIntersectionType(Type.IntersectionTy a, Type.IntersectionTy b) {
        return this.isSameTypes(this.getBounds(a), this.getBounds(b));
    }

    private ImmutableList<Type> getBounds(Type.IntersectionTy a) {
        return TurbineTypes.getBounds(this.factory, a);
    }

    static ImmutableList<Type> getBounds(ModelFactory factory, Type.IntersectionTy type) {
        ImmutableList<Type> bounds = type.bounds();
        if (TurbineTypes.implicitObjectBound(factory, bounds)) {
            return ImmutableList.builder().add((Object)Type.ClassTy.OBJECT).addAll(bounds).build();
        }
        return bounds;
    }

    private static boolean implicitObjectBound(ModelFactory factory, ImmutableList<Type> bounds) {
        if (bounds.isEmpty()) {
            return true;
        }
        Type bound = (Type)bounds.getFirst();
        return switch (bound.tyKind()) {
            case Type.TyKind.TY_VAR -> false;
            case Type.TyKind.CLASS_TY -> factory.getSymbol(((Type.ClassTy)bound).sym()).kind().equals((Object)TurbineTyKind.INTERFACE);
            default -> throw new AssertionError((Object)bound.tyKind());
        };
    }

    private boolean isSameWildType(Type.WildTy a, Type other) {
        switch (other.tyKind()) {
            case WILD_TY: {
                break;
            }
            case CLASS_TY: {
                return ((Type.ClassTy)other).sym().equals(ClassSymbol.OBJECT) && a.boundKind() == Type.WildTy.BoundKind.LOWER && a.bound().tyKind() == Type.TyKind.CLASS_TY && ((Type.ClassTy)a.bound()).sym().equals(ClassSymbol.OBJECT);
            }
            default: {
                return false;
            }
        }
        Type.WildTy b = (Type.WildTy)other;
        return switch (a.boundKind()) {
            default -> throw new MatchException(null, null);
            case Type.WildTy.BoundKind.NONE -> {
                switch (b.boundKind()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UPPER: {
                        yield TurbineTypes.isObjectType(b.bound());
                    }
                    case LOWER: {
                        yield false;
                    }
                    case NONE: 
                }
                yield true;
            }
            case Type.WildTy.BoundKind.UPPER -> {
                switch (b.boundKind()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UPPER: {
                        yield this.isSameType(a.bound(), b.bound());
                    }
                    case LOWER: {
                        yield false;
                    }
                    case NONE: 
                }
                yield TurbineTypes.isObjectType(a.bound());
            }
            case Type.WildTy.BoundKind.LOWER -> b.boundKind() == Type.WildTy.BoundKind.LOWER && this.isSameType(a.bound(), b.bound());
        };
    }

    private boolean isSameClassType(Type.ClassTy a, Type other) {
        switch (other.tyKind()) {
            case CLASS_TY: {
                break;
            }
            case WILD_TY: {
                Type.WildTy w = (Type.WildTy)other;
                return a.sym().equals(ClassSymbol.OBJECT) && w.boundKind() == Type.WildTy.BoundKind.LOWER && w.bound().tyKind() == Type.TyKind.CLASS_TY && ((Type.ClassTy)w.bound()).sym().equals(ClassSymbol.OBJECT);
            }
            default: {
                return false;
            }
        }
        Type.ClassTy b = (Type.ClassTy)other;
        if (!a.sym().equals(b.sym())) {
            return false;
        }
        UnmodifiableIterator ax = a.classes().reverse().iterator();
        UnmodifiableIterator bx = b.classes().reverse().iterator();
        while (ax.hasNext() && bx.hasNext()) {
            if (this.isSameSimpleClassType((Type.ClassTy.SimpleClassTy)ax.next(), (Type.ClassTy.SimpleClassTy)bx.next())) continue;
            return false;
        }
        return !TurbineTypes.hasTyArgs((Iterator<Type.ClassTy.SimpleClassTy>)ax) && !TurbineTypes.hasTyArgs((Iterator<Type.ClassTy.SimpleClassTy>)bx);
    }

    private static boolean hasTyArgs(Iterator<Type.ClassTy.SimpleClassTy> it) {
        while (it.hasNext()) {
            if (it.next().targs().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isSameSimpleClassType(Type.ClassTy.SimpleClassTy a, Type.ClassTy.SimpleClassTy b) {
        return a.sym().equals(b.sym()) && this.isSameTypes(a.targs(), b.targs());
    }

    @Override
    public boolean isSubtype(TypeMirror a, TypeMirror b) {
        return this.isSubtype(TurbineTypes.asTurbineType(a), TurbineTypes.asTurbineType(b), true);
    }

    private boolean isSubtype(Type a, Type b, boolean strict) {
        if (a.tyKind() == Type.TyKind.ERROR_TY || b.tyKind() == Type.TyKind.ERROR_TY) {
            return true;
        }
        if (b.tyKind() == Type.TyKind.INTERSECTION_TY) {
            for (Type bound : this.getBounds((Type.IntersectionTy)b)) {
                if (this.isSubtype(a, bound, true)) continue;
                return false;
            }
            return true;
        }
        return switch (a.tyKind()) {
            default -> throw new MatchException(null, null);
            case Type.TyKind.CLASS_TY -> this.isClassSubtype((Type.ClassTy)a, b, strict);
            case Type.TyKind.PRIM_TY -> TurbineTypes.isPrimSubtype((Type.PrimTy)a, b);
            case Type.TyKind.ARRAY_TY -> this.isArraySubtype((Type.ArrayTy)a, b, strict);
            case Type.TyKind.TY_VAR -> this.isTyVarSubtype((Type.TyVar)a, b, strict);
            case Type.TyKind.INTERSECTION_TY -> this.isIntersectionSubtype((Type.IntersectionTy)a, b, strict);
            case Type.TyKind.VOID_TY -> {
                if (b.tyKind() == Type.TyKind.VOID_TY) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.NONE_TY -> {
                if (b.tyKind() == Type.TyKind.NONE_TY) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.WILD_TY -> false;
            case Type.TyKind.ERROR_TY -> true;
            case Type.TyKind.METHOD_TY -> false;
        };
    }

    private boolean isTyVarSubtype(Type.TyVar a, Type b, boolean strict) {
        if (b.tyKind() == Type.TyKind.TY_VAR && a.sym().equals(((Type.TyVar)b).sym())) {
            return true;
        }
        TypeBoundClass.TyVarInfo tyVarInfo = this.factory.getTyVarInfo(a.sym());
        return this.isSubtype(tyVarInfo.upperBound(), b, strict);
    }

    private boolean isIntersectionSubtype(Type.IntersectionTy a, Type b, boolean strict) {
        for (Type bound : this.getBounds(a)) {
            if (!this.isSubtype(bound, b, strict)) continue;
            return true;
        }
        return false;
    }

    private boolean isArraySubtype(Type.ArrayTy a, Type b, boolean strict) {
        return switch (b.tyKind()) {
            case Type.TyKind.ARRAY_TY -> {
                Type ae = a.elementType();
                Type be = ((Type.ArrayTy)b).elementType();
                if (ae.tyKind() == Type.TyKind.PRIM_TY) {
                    yield this.isSameType(ae, be);
                }
                yield this.isSubtype(ae, be, strict);
            }
            case Type.TyKind.CLASS_TY -> {
                ClassSymbol bsym = ((Type.ClassTy)b).sym();
                switch (bsym.binaryName()) {
                    case "java/lang/Object": 
                    case "java/lang/Cloneable": 
                    case "java/io/Serializable": {
                        yield true;
                    }
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isPrimSubtype(Type.PrimTy a, Type other) {
        if (other.tyKind() != Type.TyKind.PRIM_TY) {
            return a.primkind() == TurbineConstantTypeKind.NULL && TurbineTypes.isReferenceType(other);
        }
        Type.PrimTy b = (Type.PrimTy)other;
        return switch (a.primkind()) {
            default -> throw new MatchException(null, null);
            case TurbineConstantTypeKind.CHAR -> {
                switch (b.primkind()) {
                    case CHAR: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        yield true;
                    }
                }
                yield false;
            }
            case TurbineConstantTypeKind.BYTE -> {
                switch (b.primkind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BYTE: 
                    case SHORT: {
                        yield true;
                    }
                }
                yield false;
            }
            case TurbineConstantTypeKind.SHORT -> {
                switch (b.primkind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case SHORT: {
                        yield true;
                    }
                }
                yield false;
            }
            case TurbineConstantTypeKind.INT -> {
                switch (b.primkind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        yield true;
                    }
                }
                yield false;
            }
            case TurbineConstantTypeKind.LONG -> {
                switch (b.primkind()) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        yield true;
                    }
                }
                yield false;
            }
            case TurbineConstantTypeKind.FLOAT -> {
                switch (b.primkind()) {
                    case FLOAT: 
                    case DOUBLE: {
                        yield true;
                    }
                }
                yield false;
            }
            case TurbineConstantTypeKind.DOUBLE, TurbineConstantTypeKind.STRING, TurbineConstantTypeKind.BOOLEAN -> {
                if (a.primkind() == b.primkind()) {
                    yield true;
                }
                yield false;
            }
            case TurbineConstantTypeKind.NULL -> TurbineTypes.isReferenceType(other);
        };
    }

    private boolean isClassSubtype(Type.ClassTy a, Type other, boolean strict) {
        if (other.tyKind() != Type.TyKind.CLASS_TY) {
            return false;
        }
        Type.ClassTy b = (Type.ClassTy)other;
        if (!a.sym().equals(b.sym())) {
            ImmutableList<Type.ClassTy> path = this.factory.cha().search(a, b.sym());
            if (path.isEmpty()) {
                return false;
            }
            a = (Type.ClassTy)path.getFirst();
            for (Type.ClassTy ty : path) {
                ImmutableMap<TyVarSymbol, Type> mapping = this.getMapping(ty);
                if (mapping == null) {
                    a = (Type.ClassTy)this.erasure(a);
                    break;
                }
                a = this.substClassTy(a, (Map<TyVarSymbol, Type>)mapping);
            }
        }
        UnmodifiableIterator ax = a.classes().reverse().iterator();
        UnmodifiableIterator bx = b.classes().reverse().iterator();
        while (ax.hasNext() && bx.hasNext()) {
            if (this.tyArgsContains((Type.ClassTy.SimpleClassTy)ax.next(), (Type.ClassTy.SimpleClassTy)bx.next(), strict)) continue;
            return false;
        }
        return !TurbineTypes.hasTyArgs((Iterator<Type.ClassTy.SimpleClassTy>)ax) && !TurbineTypes.hasTyArgs((Iterator<Type.ClassTy.SimpleClassTy>)bx);
    }

    private boolean tyArgsContains(Type.ClassTy.SimpleClassTy a, Type.ClassTy.SimpleClassTy b, boolean strict) {
        Verify.verify((boolean)a.sym().equals(b.sym()));
        UnmodifiableIterator ax = a.targs().iterator();
        UnmodifiableIterator bx = b.targs().iterator();
        while (ax.hasNext() && bx.hasNext()) {
            if (this.containedBy((Type)ax.next(), (Type)bx.next(), strict)) continue;
            return false;
        }
        if (strict) {
            return !bx.hasNext();
        }
        return true;
    }

    private Type subst(Type type, Map<TyVarSymbol, Type> mapping) {
        return switch (type.tyKind()) {
            default -> throw new MatchException(null, null);
            case Type.TyKind.CLASS_TY -> this.substClassTy((Type.ClassTy)type, mapping);
            case Type.TyKind.ARRAY_TY -> this.substArrayTy((Type.ArrayTy)type, mapping);
            case Type.TyKind.TY_VAR -> this.substTyVar((Type.TyVar)type, mapping);
            case Type.TyKind.PRIM_TY, Type.TyKind.VOID_TY, Type.TyKind.NONE_TY, Type.TyKind.ERROR_TY -> type;
            case Type.TyKind.METHOD_TY -> this.substMethod((Type.MethodTy)type, mapping);
            case Type.TyKind.INTERSECTION_TY -> this.substIntersectionTy((Type.IntersectionTy)type, mapping);
            case Type.TyKind.WILD_TY -> this.substWildTy((Type.WildTy)type, mapping);
        };
    }

    private Type substWildTy(Type.WildTy type, Map<TyVarSymbol, Type> mapping) {
        return switch (type.boundKind()) {
            default -> throw new MatchException(null, null);
            case Type.WildTy.BoundKind.NONE -> type;
            case Type.WildTy.BoundKind.UPPER -> Type.WildUpperBoundedTy.create(this.subst(type.bound(), mapping), (ImmutableList<AnnoInfo>)ImmutableList.of());
            case Type.WildTy.BoundKind.LOWER -> Type.WildLowerBoundedTy.create(this.subst(type.bound(), mapping), (ImmutableList<AnnoInfo>)ImmutableList.of());
        };
    }

    private Type substIntersectionTy(Type.IntersectionTy type, Map<TyVarSymbol, Type> mapping) {
        return Type.IntersectionTy.create(this.substAll(this.getBounds(type), mapping));
    }

    private Type.MethodTy substMethod(Type.MethodTy method, Map<TyVarSymbol, Type> mapping) {
        return Type.MethodTy.create(method.tyParams(), this.subst(method.returnType(), mapping), method.receiverType() != null ? this.subst(method.receiverType(), mapping) : null, this.substAll(method.parameters(), mapping), this.substAll(method.thrown(), mapping));
    }

    private ImmutableList<Type> substAll(ImmutableList<? extends Type> types, Map<TyVarSymbol, Type> mapping) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add((Object)this.subst(type, mapping));
        }
        return result.build();
    }

    private Type substTyVar(Type.TyVar type, Map<TyVarSymbol, Type> mapping) {
        return mapping.getOrDefault(type.sym(), type);
    }

    private Type substArrayTy(Type.ArrayTy type, Map<TyVarSymbol, Type> mapping) {
        return Type.ArrayTy.create(this.subst(type.elementType(), mapping), type.annos());
    }

    private Type.ClassTy substClassTy(Type.ClassTy type, Map<TyVarSymbol, Type> mapping) {
        ImmutableList.Builder simples = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy simple : type.classes()) {
            ImmutableList.Builder args = ImmutableList.builder();
            for (Type arg : simple.targs()) {
                args.add((Object)this.subst(arg, mapping));
            }
            simples.add((Object)Type.ClassTy.SimpleClassTy.create(simple.sym(), (ImmutableList<Type>)args.build(), simple.annos()));
        }
        return Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)simples.build());
    }

    private static @Nullable ImmutableMap<TyVarSymbol, Type> getMapping(Type.MethodTy a, Type.MethodTy b) {
        if (a.tyParams().size() != b.tyParams().size()) {
            return null;
        }
        UnmodifiableIterator ax = a.tyParams().iterator();
        UnmodifiableIterator bx = b.tyParams().iterator();
        ImmutableMap.Builder mapping = ImmutableMap.builder();
        while (ax.hasNext()) {
            TyVarSymbol s = (TyVarSymbol)ax.next();
            TyVarSymbol t = (TyVarSymbol)bx.next();
            mapping.put((Object)t, (Object)Type.TyVar.create(s, (ImmutableList<AnnoInfo>)ImmutableList.of()));
        }
        return mapping.buildOrThrow();
    }

    private @Nullable ImmutableMap<TyVarSymbol, Type> getMapping(Type.ClassTy ty) {
        ImmutableMap.Builder mapping = ImmutableMap.builder();
        for (Type.ClassTy.SimpleClassTy s : ty.classes()) {
            TypeBoundClass info = this.factory.getSymbol(s.sym());
            if (s.targs().isEmpty() && !info.typeParameters().isEmpty()) {
                return null;
            }
            UnmodifiableIterator ax = info.typeParameters().values().iterator();
            UnmodifiableIterator bx = s.targs().iterator();
            while (ax.hasNext()) {
                mapping.put((Object)((TyVarSymbol)ax.next()), (Object)((Type)bx.next()));
            }
            Verify.verify((!bx.hasNext() ? 1 : 0) != 0);
        }
        return mapping.buildOrThrow();
    }

    @Override
    public boolean isAssignable(TypeMirror a1, TypeMirror a2) {
        return this.isAssignable(TurbineTypes.asTurbineType(a1), TurbineTypes.asTurbineType(a2));
    }

    private boolean isAssignable(Type t1, Type t2) {
        if (t1.tyKind() == Type.TyKind.ERROR_TY || t2.tyKind() == Type.TyKind.ERROR_TY) {
            return true;
        }
        switch (t1.tyKind()) {
            case PRIM_TY: {
                TurbineConstantTypeKind primkind = ((Type.PrimTy)t1).primkind();
                if (primkind == TurbineConstantTypeKind.NULL) {
                    return TurbineTypes.isReferenceType(t2);
                }
                if (t2.tyKind() != Type.TyKind.CLASS_TY) break;
                ClassSymbol boxed = TurbineTypes.boxedClass(primkind);
                t1 = Type.ClassTy.asNonParametricClassTy(boxed);
                break;
            }
            case CLASS_TY: {
                if (t2.tyKind() != Type.TyKind.PRIM_TY) break;
                TurbineConstantTypeKind unboxed = TurbineTypes.unboxedType((Type.ClassTy)t1);
                if (unboxed == null) {
                    return false;
                }
                t1 = Type.PrimTy.create(unboxed, (ImmutableList<AnnoInfo>)ImmutableList.of());
                break;
            }
        }
        return this.isSubtype(t1, t2, false);
    }

    private static boolean isObjectType(Type type) {
        return type.tyKind() == Type.TyKind.CLASS_TY && ((Type.ClassTy)type).sym().equals(ClassSymbol.OBJECT);
    }

    private static boolean isReferenceType(Type type) {
        return switch (type.tyKind()) {
            default -> throw new MatchException(null, null);
            case Type.TyKind.CLASS_TY, Type.TyKind.ARRAY_TY, Type.TyKind.TY_VAR, Type.TyKind.WILD_TY, Type.TyKind.INTERSECTION_TY, Type.TyKind.ERROR_TY -> true;
            case Type.TyKind.PRIM_TY -> {
                if (((Type.PrimTy)type).primkind() == TurbineConstantTypeKind.NULL) {
                    yield true;
                }
                yield false;
            }
            case Type.TyKind.VOID_TY, Type.TyKind.NONE_TY, Type.TyKind.METHOD_TY -> false;
        };
    }

    @Override
    public boolean contains(TypeMirror a, TypeMirror b) {
        return this.contains(TurbineTypes.asTurbineType(a), TurbineTypes.asTurbineType(b), true);
    }

    private boolean contains(Type t1, Type t2, boolean strict) {
        return this.containedBy(t2, t1, strict);
    }

    private boolean containedBy(Type t1, Type t2, boolean strict) {
        if (t1.tyKind() == Type.TyKind.ERROR_TY) {
            return true;
        }
        if (t1.tyKind() == Type.TyKind.WILD_TY) {
            Type.WildTy w1 = (Type.WildTy)t1;
            switch (w1.boundKind()) {
                case UPPER: {
                    Type t = w1.bound();
                    if (t2.tyKind() == Type.TyKind.WILD_TY) {
                        Type.WildTy w2 = (Type.WildTy)t2;
                        switch (w2.boundKind()) {
                            case UPPER: {
                                return this.isSubtype(t, w2.bound(), strict);
                            }
                            case NONE: {
                                return true;
                            }
                            case LOWER: {
                                return false;
                            }
                        }
                        throw new AssertionError((Object)w1.boundKind());
                    }
                    return false;
                }
                case LOWER: {
                    Type t = w1.bound();
                    if (t2.tyKind() == Type.TyKind.WILD_TY) {
                        Type.WildTy w2 = (Type.WildTy)t2;
                        switch (w2.boundKind()) {
                            case LOWER: {
                                return this.isSubtype(w2.bound(), t, strict);
                            }
                            case NONE: {
                                return true;
                            }
                            case UPPER: {
                                return TurbineTypes.isObjectType(w2.bound());
                            }
                        }
                        throw new AssertionError((Object)w2.boundKind());
                    }
                    return TurbineTypes.isObjectType(t2) && TurbineTypes.isObjectType(t);
                }
                case NONE: {
                    if (t2.tyKind() == Type.TyKind.WILD_TY) {
                        Type.WildTy w2 = (Type.WildTy)t2;
                        switch (w2.boundKind()) {
                            case NONE: {
                                return true;
                            }
                            case LOWER: {
                                return false;
                            }
                            case UPPER: {
                                return TurbineTypes.isObjectType(w2.bound());
                            }
                        }
                        throw new AssertionError((Object)w2.boundKind());
                    }
                    return false;
                }
            }
            throw new AssertionError((Object)w1.boundKind());
        }
        if (t2.tyKind() == Type.TyKind.WILD_TY) {
            Type.WildTy w2 = (Type.WildTy)t2;
            return switch (w2.boundKind()) {
                default -> throw new MatchException(null, null);
                case Type.WildTy.BoundKind.LOWER -> this.isSubtype(w2.bound(), t1, strict);
                case Type.WildTy.BoundKind.UPPER -> this.isSubtype(t1, w2.bound(), strict);
                case Type.WildTy.BoundKind.NONE -> true;
            };
        }
        return this.isSameType(t1, t2);
    }

    @Override
    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return this.isSubsignature((Type.MethodTy)TurbineTypes.asTurbineType(m1), (Type.MethodTy)TurbineTypes.asTurbineType(m2));
    }

    private boolean isSubsignature(Type.MethodTy a, Type.MethodTy b) {
        return this.isSameSignature(a, b) || this.isSameSignature(a, (Type.MethodTy)this.erasure(b));
    }

    private boolean isSameSignature(Type.MethodTy a, Type.MethodTy b) {
        if (a.parameters().size() != b.parameters().size()) {
            return false;
        }
        ImmutableMap<TyVarSymbol, Type> mapping = TurbineTypes.getMapping(a, b);
        if (mapping == null) {
            return false;
        }
        if (!this.sameTypeParameterBounds(a, b, mapping)) {
            return false;
        }
        UnmodifiableIterator ax = a.parameters().iterator();
        UnmodifiableIterator bx = this.substAll((ImmutableList<? extends Type>)b.parameters(), (Map<TyVarSymbol, Type>)mapping).iterator();
        while (ax.hasNext()) {
            if (this.isSameType((Type)ax.next(), (Type)bx.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<? extends TypeMirror> directSupertypes(TypeMirror m) {
        return this.factory.asTypeMirrors((Iterable<? extends Type>)Deannotate.deannotate(this.directSupertypes(TurbineTypes.asTurbineType(m))));
    }

    public ImmutableList<Type> directSupertypes(Type t) {
        return switch (t.tyKind()) {
            default -> throw new MatchException(null, null);
            case Type.TyKind.CLASS_TY -> this.directSupertypes((Type.ClassTy)t);
            case Type.TyKind.INTERSECTION_TY -> ((Type.IntersectionTy)t).bounds();
            case Type.TyKind.TY_VAR -> this.getBounds(this.factory.getTyVarInfo(((Type.TyVar)t).sym()).upperBound());
            case Type.TyKind.ARRAY_TY -> this.directSupertypes((Type.ArrayTy)t);
            case Type.TyKind.PRIM_TY, Type.TyKind.VOID_TY, Type.TyKind.NONE_TY, Type.TyKind.WILD_TY, Type.TyKind.ERROR_TY -> ImmutableList.of();
            case Type.TyKind.METHOD_TY -> throw new IllegalArgumentException(t.tyKind().name());
        };
    }

    private ImmutableList<Type> directSupertypes(Type.ArrayTy t) {
        Type elem = t.elementType();
        if (elem.tyKind() == Type.TyKind.PRIM_TY || TurbineTypes.isObjectType(elem)) {
            return ImmutableList.of((Object)Type.IntersectionTy.create((ImmutableList<Type>)ImmutableList.of((Object)Type.ClassTy.OBJECT, (Object)Type.ClassTy.SERIALIZABLE, (Object)Type.ClassTy.CLONEABLE)));
        }
        ImmutableList<Type> ex = this.directSupertypes(elem);
        return ImmutableList.of((Object)Type.ArrayTy.create((Type)ex.iterator().next(), (ImmutableList<AnnoInfo>)ImmutableList.of()));
    }

    private ImmutableList<Type> directSupertypes(Type.ClassTy t) {
        if (t.sym().equals(ClassSymbol.OBJECT)) {
            return ImmutableList.of();
        }
        TypeBoundClass info = this.factory.getSymbol(t.sym());
        ImmutableMap<TyVarSymbol, Type> mapping = this.getMapping(t);
        boolean raw = mapping == null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (info.superClassType() != null) {
            builder.add((Object)(raw ? this.erasure(info.superClassType()) : this.subst(info.superClassType(), (Map<TyVarSymbol, Type>)mapping)));
        } else {
            builder.add((Object)Type.ClassTy.OBJECT);
        }
        for (Type interfaceType : info.interfaceTypes()) {
            if (interfaceType.tyKind() != Type.TyKind.CLASS_TY) continue;
            builder.add((Object)(raw ? this.erasure(interfaceType) : this.subst(interfaceType, (Map<TyVarSymbol, Type>)mapping)));
        }
        return builder.build();
    }

    @Override
    public TypeMirror erasure(TypeMirror typeMirror) {
        return this.factory.asTypeMirror(Deannotate.deannotate(this.erasure(TurbineTypes.asTurbineType(typeMirror))));
    }

    private Type erasure(Type type) {
        return Erasure.erase(type, new Function<TyVarSymbol, TypeBoundClass.TyVarInfo>(){

            @Override
            public TypeBoundClass.TyVarInfo apply(TyVarSymbol input) {
                return TurbineTypes.this.factory.getTyVarInfo(input);
            }
        });
    }

    @Override
    public TypeElement boxedClass(PrimitiveType p) {
        return this.factory.typeElement(TurbineTypes.boxedClass(((Type.PrimTy)TurbineTypes.asTurbineType(p)).primkind()));
    }

    static ClassSymbol boxedClass(TurbineConstantTypeKind kind) {
        return switch (kind) {
            default -> throw new MatchException(null, null);
            case TurbineConstantTypeKind.CHAR -> ClassSymbol.CHARACTER;
            case TurbineConstantTypeKind.SHORT -> ClassSymbol.SHORT;
            case TurbineConstantTypeKind.INT -> ClassSymbol.INTEGER;
            case TurbineConstantTypeKind.LONG -> ClassSymbol.LONG;
            case TurbineConstantTypeKind.FLOAT -> ClassSymbol.FLOAT;
            case TurbineConstantTypeKind.DOUBLE -> ClassSymbol.DOUBLE;
            case TurbineConstantTypeKind.BOOLEAN -> ClassSymbol.BOOLEAN;
            case TurbineConstantTypeKind.BYTE -> ClassSymbol.BYTE;
            case TurbineConstantTypeKind.STRING, TurbineConstantTypeKind.NULL -> throw new AssertionError((Object)kind);
        };
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror typeMirror) {
        Type type = TurbineTypes.asTurbineType(typeMirror);
        if (type.tyKind() != Type.TyKind.CLASS_TY) {
            throw new IllegalArgumentException(type.toString());
        }
        TurbineConstantTypeKind unboxed = TurbineTypes.unboxedType((Type.ClassTy)type);
        if (unboxed == null) {
            throw new IllegalArgumentException(type.toString());
        }
        return (PrimitiveType)this.factory.asTypeMirror(Type.PrimTy.create(unboxed, (ImmutableList<AnnoInfo>)ImmutableList.of()));
    }

    private static @Nullable TurbineConstantTypeKind unboxedType(Type.ClassTy classTy) {
        return switch (classTy.sym().binaryName()) {
            case "java/lang/Boolean" -> TurbineConstantTypeKind.BOOLEAN;
            case "java/lang/Byte" -> TurbineConstantTypeKind.BYTE;
            case "java/lang/Short" -> TurbineConstantTypeKind.SHORT;
            case "java/lang/Integer" -> TurbineConstantTypeKind.INT;
            case "java/lang/Long" -> TurbineConstantTypeKind.LONG;
            case "java/lang/Character" -> TurbineConstantTypeKind.CHAR;
            case "java/lang/Float" -> TurbineConstantTypeKind.FLOAT;
            case "java/lang/Double" -> TurbineConstantTypeKind.DOUBLE;
            default -> null;
        };
    }

    @Override
    public TypeMirror capture(TypeMirror typeMirror) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind kind) {
        Preconditions.checkArgument((boolean)kind.isPrimitive(), (String)"%s is not a primitive type", (Object)((Object)kind));
        return (PrimitiveType)this.factory.asTypeMirror(Type.PrimTy.create(TurbineTypes.primitiveType(kind), (ImmutableList<AnnoInfo>)ImmutableList.of()));
    }

    private static TurbineConstantTypeKind primitiveType(TypeKind kind) {
        return switch (kind) {
            case TypeKind.BOOLEAN -> TurbineConstantTypeKind.BOOLEAN;
            case TypeKind.BYTE -> TurbineConstantTypeKind.BYTE;
            case TypeKind.SHORT -> TurbineConstantTypeKind.SHORT;
            case TypeKind.INT -> TurbineConstantTypeKind.INT;
            case TypeKind.LONG -> TurbineConstantTypeKind.LONG;
            case TypeKind.CHAR -> TurbineConstantTypeKind.CHAR;
            case TypeKind.FLOAT -> TurbineConstantTypeKind.FLOAT;
            case TypeKind.DOUBLE -> TurbineConstantTypeKind.DOUBLE;
            default -> throw new IllegalArgumentException(String.valueOf((Object)kind) + " is not a primitive type");
        };
    }

    @Override
    public NullType getNullType() {
        return this.factory.nullType();
    }

    @Override
    public NoType getNoType(TypeKind kind) {
        return switch (kind) {
            case TypeKind.VOID -> (NoType)this.factory.asTypeMirror(Type.VOID);
            case TypeKind.NONE -> this.factory.noType();
            default -> throw new IllegalArgumentException(kind.toString());
        };
    }

    @Override
    public ArrayType getArrayType(TypeMirror componentType) {
        return (ArrayType)this.factory.asTypeMirror(Type.ArrayTy.create(TurbineTypes.asTurbineType(componentType), (ImmutableList<AnnoInfo>)ImmutableList.of()));
    }

    @Override
    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        Type.WildTy type = extendsBound != null ? Type.WildUpperBoundedTy.create(TurbineTypes.asTurbineType(extendsBound), (ImmutableList<AnnoInfo>)ImmutableList.of()) : (superBound != null ? Type.WildLowerBoundedTy.create(TurbineTypes.asTurbineType(superBound), (ImmutableList<AnnoInfo>)ImmutableList.of()) : Type.WildUnboundedTy.create((ImmutableList<AnnoInfo>)ImmutableList.of()));
        return (WildcardType)this.factory.asTypeMirror(type);
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        Objects.requireNonNull(typeElem);
        ImmutableList.Builder args = ImmutableList.builder();
        for (TypeMirror t : typeArgs) {
            args.add((Object)TurbineTypes.asTurbineType(t));
        }
        TurbineElement.TurbineTypeElement element = (TurbineElement.TurbineTypeElement)typeElem;
        return (DeclaredType)this.factory.asTypeMirror(Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)ImmutableList.of((Object)Type.ClassTy.SimpleClassTy.create(element.sym(), (ImmutableList<Type>)args.build(), (ImmutableList<AnnoInfo>)ImmutableList.of()))));
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        if (containing == null) {
            return this.getDeclaredType(typeElem, typeArgs);
        }
        Objects.requireNonNull(typeElem);
        Type.ClassTy base = (Type.ClassTy)TurbineTypes.asTurbineType(containing);
        TurbineElement.TurbineTypeElement element = (TurbineElement.TurbineTypeElement)typeElem;
        ImmutableList.Builder args = ImmutableList.builder();
        for (TypeMirror t : typeArgs) {
            args.add((Object)TurbineTypes.asTurbineType(t));
        }
        return (DeclaredType)this.factory.asTypeMirror(Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)ImmutableList.builder().addAll(base.classes()).add((Object)Type.ClassTy.SimpleClassTy.create(element.sym(), (ImmutableList<Type>)args.build(), (ImmutableList<AnnoInfo>)ImmutableList.of())).build()));
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        TypeMirror result = this.asMemberOfInternal(containing, element);
        if (result == null) {
            throw new IllegalArgumentException(String.format("asMemberOf(%s, %s)", containing, element));
        }
        return result;
    }

    public @Nullable TypeMirror asMemberOfInternal(DeclaredType containing, Element element) {
        Type.ClassTy c = ((TurbineTypeMirror.TurbineDeclaredType)containing).asTurbineType();
        Symbol enclosing = ((TurbineElement)element.getEnclosingElement()).sym();
        if (!enclosing.symKind().equals((Object)Symbol.Kind.CLASS)) {
            return null;
        }
        ImmutableList<Type.ClassTy> path = this.factory.cha().search(c, (ClassSymbol)enclosing);
        if (path.isEmpty()) {
            return null;
        }
        Type type = TurbineTypes.asTurbineType(element.asType());
        for (Type.ClassTy ty : path) {
            ImmutableMap<TyVarSymbol, Type> mapping = this.getMapping(ty);
            if (mapping == null) {
                type = this.erasure(type);
                break;
            }
            type = this.subst(type, (Map<TyVarSymbol, Type>)mapping);
        }
        return this.factory.asTypeMirror(type);
    }
}

