/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.errorprone.annotations.CheckReturnValue;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;

public class UnicodeEscapePreprocessor {
    public static final char ASCII_SUB = '\u001a';
    private final SourceFile source;
    private final String input;
    private int idx = 0;
    private int ch;
    private boolean evenLeadingSlashes = true;

    public UnicodeEscapePreprocessor(SourceFile source) {
        this.source = source;
        this.input = source.source();
    }

    public int position() {
        return this.idx - 1;
    }

    public boolean done() {
        return this.idx >= this.input.length();
    }

    public int next() {
        this.eat();
        if (this.ch == 92 && this.evenLeadingSlashes) {
            this.unicodeEscape();
        } else {
            this.evenLeadingSlashes = true;
        }
        return this.ch;
    }

    public String readString(int from, int to) {
        return this.input.substring(from, to);
    }

    private void unicodeEscape() {
        this.eat();
        if (this.ch != 117) {
            --this.idx;
            this.ch = 92;
            this.evenLeadingSlashes = false;
            return;
        }
        do {
            this.eat();
        } while (this.ch == 117);
        char acc = (char)((this.hexDigit(this.ch) & 0xFF) << 12);
        this.eat();
        acc = (char)(acc | (char)((this.hexDigit(this.ch) & 0xFF) << 8));
        this.eat();
        acc = (char)(acc | (char)((this.hexDigit(this.ch) & 0xFF) << 4));
        this.eat();
        acc = (char)(acc | (char)(this.hexDigit(this.ch) & 0xFF));
        this.ch = acc;
        this.evenLeadingSlashes = this.ch != 92;
    }

    private int hexDigit(int d) {
        return switch (d) {
            case 48, 49, 50, 51, 52, 53, 54, 55, 56, 57 -> d - 48;
            case 65, 66, 67, 68, 69, 70 -> d - 65 + 10;
            case 97, 98, 99, 100, 101, 102 -> d - 97 + 10;
            case 26 -> throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
            default -> throw this.error(TurbineError.ErrorKind.INVALID_UNICODE, new Object[0]);
        };
    }

    private void eat() {
        char lo;
        char hi = this.done() ? (char)'\u001a' : (char)this.input.charAt(this.idx);
        ++this.idx;
        if (!Character.isHighSurrogate(hi)) {
            this.ch = hi;
            return;
        }
        if (this.done()) {
            throw this.error(TurbineError.ErrorKind.UNPAIRED_SURROGATE, hi);
        }
        if (!Character.isLowSurrogate(lo = this.input.charAt(this.idx++))) {
            throw this.error(TurbineError.ErrorKind.UNPAIRED_SURROGATE, hi);
        }
        this.ch = Character.toCodePoint(hi, lo);
    }

    public SourceFile source() {
        return this.source;
    }

    @CheckReturnValue
    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        throw TurbineError.format(this.source(), Math.min(this.position(), this.source().source().length() - 1), kind, args);
    }
}

