/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.options;

import com.google.auto.value.AutoBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.turbine.options.AutoBuilder_TurbineOptions_Builder;
import com.google.turbine.options.LanguageVersion;
import java.util.Objects;
import java.util.Optional;

public record TurbineOptions(ImmutableList<String> sources, ImmutableList<String> classPath, ImmutableSet<String> bootClassPath, LanguageVersion languageVersion, Optional<String> system, Optional<String> output, Optional<String> headerCompilationOutput, ImmutableList<String> processorPath, ImmutableSet<String> processors, ImmutableSet<String> builtinProcessors, ImmutableList<String> sourceJars, Optional<String> outputDeps, Optional<String> outputManifest, ImmutableSet<String> directJars, Optional<String> targetLabel, Optional<String> injectingRuleKind, ImmutableList<String> depsArtifacts, boolean help, ImmutableList<String> javacOpts, ReducedClasspathMode reducedClasspathMode, Optional<String> profile, Optional<String> gensrcOutput, Optional<String> resourceOutput, int fullClasspathLength, int reducedClasspathLength) {
    public TurbineOptions {
        Objects.requireNonNull(sources, "sources");
        Objects.requireNonNull(classPath, "classPath");
        Objects.requireNonNull(bootClassPath, "bootClassPath");
        Objects.requireNonNull(languageVersion, "languageVersion");
        Objects.requireNonNull(system, "system");
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(headerCompilationOutput, "headerCompilationOutput");
        Objects.requireNonNull(processorPath, "processorPath");
        Objects.requireNonNull(processors, "processors");
        Objects.requireNonNull(builtinProcessors, "builtinProcessors");
        Objects.requireNonNull(sourceJars, "sourceJars");
        Objects.requireNonNull(outputDeps, "outputDeps");
        Objects.requireNonNull(outputManifest, "outputManifest");
        Objects.requireNonNull(directJars, "directJars");
        Objects.requireNonNull(targetLabel, "targetLabel");
        Objects.requireNonNull(injectingRuleKind, "injectingRuleKind");
        Objects.requireNonNull(depsArtifacts, "depsArtifacts");
        Objects.requireNonNull(javacOpts, "javacOpts");
        Objects.requireNonNull(reducedClasspathMode, "reducedClasspathMode");
        Objects.requireNonNull(profile, "profile");
        Objects.requireNonNull(gensrcOutput, "gensrcOutput");
        Objects.requireNonNull(resourceOutput, "resourceOutput");
    }

    public static Builder builder() {
        return new AutoBuilder_TurbineOptions_Builder().setSources((ImmutableList<String>)ImmutableList.of()).setClassPath((ImmutableList<String>)ImmutableList.of()).setBootClassPath((ImmutableList<String>)ImmutableList.of()).setProcessorPath((ImmutableList<String>)ImmutableList.of()).setProcessors((ImmutableList<String>)ImmutableList.of()).setBuiltinProcessors((ImmutableList<String>)ImmutableList.of()).setSourceJars((ImmutableList<String>)ImmutableList.of()).setDirectJars((ImmutableList<String>)ImmutableList.of()).setDepsArtifacts((ImmutableList<String>)ImmutableList.of()).addAllJavacOpts((Iterable<String>)ImmutableList.of()).setLanguageVersion(LanguageVersion.createDefault()).setReducedClasspathMode(ReducedClasspathMode.NONE).setHelp(false).setFullClasspathLength(0).setReducedClasspathLength(0);
    }

    public static enum ReducedClasspathMode {
        BAZEL_REDUCED,
        BAZEL_FALLBACK,
        JAVABUILDER_REDUCED,
        NONE;

    }

    @AutoBuilder
    public static abstract class Builder {
        public abstract Builder setOutput(String var1);

        public abstract Builder setClassPath(ImmutableList<String> var1);

        public abstract Builder setBootClassPath(ImmutableList<String> var1);

        public abstract Builder setLanguageVersion(LanguageVersion var1);

        public abstract Builder setSystem(String var1);

        public abstract Builder setSources(ImmutableList<String> var1);

        public abstract Builder setProcessorPath(ImmutableList<String> var1);

        public abstract Builder setProcessors(ImmutableList<String> var1);

        public abstract Builder setBuiltinProcessors(ImmutableList<String> var1);

        public abstract Builder setSourceJars(ImmutableList<String> var1);

        public abstract Builder setOutputDeps(String var1);

        public abstract Builder setHeaderCompilationOutput(String var1);

        public abstract Builder setOutputManifest(String var1);

        public abstract Builder setTargetLabel(String var1);

        public abstract Builder setInjectingRuleKind(String var1);

        public abstract Builder setDepsArtifacts(ImmutableList<String> var1);

        public abstract Builder setHelp(boolean var1);

        abstract ImmutableList.Builder<String> javacOptsBuilder();

        @CanIgnoreReturnValue
        public Builder addAllJavacOpts(Iterable<String> javacOpts) {
            this.javacOptsBuilder().addAll(javacOpts);
            return this;
        }

        public abstract Builder setReducedClasspathMode(ReducedClasspathMode var1);

        public abstract Builder setDirectJars(ImmutableList<String> var1);

        public abstract Builder setProfile(String var1);

        public abstract Builder setGensrcOutput(String var1);

        public abstract Builder setResourceOutput(String var1);

        public abstract Builder setFullClasspathLength(int var1);

        public abstract Builder setReducedClasspathLength(int var1);

        public abstract TurbineOptions build();
    }
}

