/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.Binder;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassReader;
import com.google.turbine.bytecode.ClassWriter;
import com.google.turbine.deps.Dependencies;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public final class Transitive {
    public static ImmutableMap<String, byte[]> collectDeps(ClassPath bootClassPath, Binder.BindingResult bound) {
        ImmutableMap.Builder transitive = ImmutableMap.builder();
        Set<ClassSymbol> closure = Transitive.superClosure(bound);
        Dependencies.addPackageInfos(closure, bound);
        for (ClassSymbol sym : closure) {
            BytecodeBoundClass info = bound.classPathEnv().get(sym);
            if (info == null || bootClassPath.env().get(sym) != null) continue;
            transitive.put((Object)sym.binaryName(), (Object)ClassWriter.writeClass(Transitive.trimClass(info.classFile(), info.jarFile())));
        }
        return transitive.buildOrThrow();
    }

    public static ImmutableMap<String, byte[]> trimOutput(ImmutableMap<String, byte[]> lowered) {
        ImmutableMap.Builder trimmed = ImmutableMap.builder();
        for (Map.Entry sym : lowered.entrySet()) {
            if (((String)sym.getKey()).equals("module-info")) continue;
            trimmed.put((Object)((String)sym.getKey()), (Object)ClassWriter.writeClass(Transitive.trimClass(ClassReader.read((byte[])sym.getValue()), null)));
        }
        return trimmed.buildOrThrow();
    }

    /*
     * WARNING - void declaration
     */
    public static ClassFile trimClass(ClassFile cf, @Nullable String jarFile) {
        void var4_8;
        ImmutableList.Builder fields = ImmutableList.builder();
        for (ClassFile.FieldInfo fieldInfo : cf.fields()) {
            if (!Transitive.keepField(fieldInfo)) continue;
            fields.add((Object)fieldInfo);
        }
        ImmutableList.Builder innerClasses = ImmutableList.builder();
        for (ClassFile.InnerClass i : cf.innerClasses()) {
            if (!i.innerClass().equals(cf.name()) && !i.outerClass().equals(cf.name())) continue;
            innerClasses.add((Object)i);
        }
        String string = cf.transitiveJar();
        if (string == null) {
            String string2 = jarFile;
        }
        return new ClassFile(cf.access(), cf.majorVersion(), cf.name(), cf.signature(), cf.superName(), cf.interfaces(), cf.permits(), (cf.access() & 0x2000) == 8192 ? cf.methods() : ImmutableList.of(), (List<ClassFile.FieldInfo>)fields.build(), cf.annotations(), (List<ClassFile.InnerClass>)innerClasses.build(), cf.typeAnnotations(), null, null, (ImmutableList<String>)ImmutableList.of(), null, (String)var4_8);
    }

    private static boolean keepField(ClassFile.FieldInfo f) {
        if (f.value() != null) {
            return true;
        }
        return (f.access() & 0x4000) == 16384;
    }

    private static Set<ClassSymbol> superClosure(Binder.BindingResult bound) {
        CompoundEnv<ClassSymbol, TypeBoundClass> env = CompoundEnv.of(new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(bound.units())).append(bound.classPathEnv());
        LinkedHashSet<ClassSymbol> closure = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol sym : bound.units().keySet()) {
            Transitive.addSuperTypes(closure, env, sym);
        }
        LinkedHashSet directChildren = new LinkedHashSet();
        for (ClassSymbol sym : closure) {
            TypeBoundClass info = (TypeBoundClass)env.get(sym);
            if (info == null) continue;
            directChildren.addAll(info.children().values());
        }
        closure.addAll(directChildren);
        return closure;
    }

    private static void addSuperTypes(Set<ClassSymbol> closure, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym) {
        if (!closure.add(sym)) {
            return;
        }
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            return;
        }
        if (info.superclass() != null) {
            Transitive.addSuperTypes(closure, env, info.superclass());
        }
        for (ClassSymbol i : info.interfaces()) {
            Transitive.addSuperTypes(closure, env, i);
        }
    }

    private Transitive() {
    }
}

