/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.expression.ClassName;
import org.checkerframework.errorprone.dataflow.expression.JavaExpression;
import org.checkerframework.errorprone.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.errorprone.dataflow.util.PurityUtils;
import org.checkerframework.errorprone.javacutil.AnnotationProvider;

public class MethodCall
extends JavaExpression {
    protected final ExecutableElement method;
    protected final JavaExpression receiver;
    protected final List<JavaExpression> arguments;

    public MethodCall(TypeMirror type, ExecutableElement method, JavaExpression receiver, List<JavaExpression> arguments) {
        super(type);
        this.receiver = receiver;
        this.arguments = arguments;
        this.method = method;
    }

    public ExecutableElement getElement() {
        return this.method;
    }

    public JavaExpression getReceiver() {
        return this.receiver;
    }

    public List<JavaExpression> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public boolean containsOfClass(Class<? extends JavaExpression> clazz) {
        if (this.getClass() == clazz) {
            return true;
        }
        if (this.receiver.containsOfClass(clazz)) {
            return true;
        }
        for (JavaExpression p : this.arguments) {
            if (!p.containsOfClass(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return (PurityUtils.isDeterministic(provider, this.method) || provider.isDeterministic(this.method)) && MethodCall.listIsDeterministic(this.arguments, provider);
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return this.receiver.isUnmodifiableByOtherCode() && this.arguments.stream().allMatch(JavaExpression::isUnmodifiableByOtherCode);
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return this.isUnassignableByOtherCode();
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof MethodCall)) {
            return false;
        }
        MethodCall other = (MethodCall)je;
        return this.method.equals(other.method) && this.receiver.syntacticEquals(other.receiver) && JavaExpression.syntacticEqualsList(this.arguments, other.arguments);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || this.receiver.containsSyntacticEqualJavaExpression(other) || JavaExpression.listContainsSyntacticEqualJavaExpression(this.arguments, other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        if (this.receiver.containsModifiableAliasOf(store, other)) {
            return true;
        }
        for (JavaExpression p : this.arguments) {
            if (!p.containsModifiableAliasOf(store, other)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodCall)) {
            return false;
        }
        if (this.method.getKind() == ElementKind.CONSTRUCTOR) {
            return false;
        }
        MethodCall other = (MethodCall)obj;
        return this.method.equals(other.method) && this.receiver.equals(other.receiver) && this.arguments.equals(other.arguments);
    }

    public int hashCode() {
        if (this.method.getKind() == ElementKind.CONSTRUCTOR) {
            return super.hashCode();
        }
        return Objects.hash(this.method, this.receiver, this.arguments);
    }

    public String toString() {
        StringBuilder preParen = new StringBuilder();
        if (this.receiver instanceof ClassName) {
            preParen.append(this.receiver.getType());
        } else {
            preParen.append(this.receiver);
        }
        preParen.append(".");
        String methodName = this.method.getSimpleName().toString();
        preParen.append(methodName);
        preParen.append("(");
        StringJoiner result = new StringJoiner(", ", preParen, ")");
        for (JavaExpression argument : this.arguments) {
            result.add(argument.toString());
        }
        return result.toString();
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitMethodCall(this, p);
    }
}

