/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.AutoValue_PlaceholderUnificationVisitor;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.LocalVarBinding;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UFreeIdent;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;

@AutoValue
abstract class PlaceholderUnificationVisitor
extends SimpleTreeVisitor<Choice<? extends State<? extends JCTree>>, State<?>> {
    static final TreeVisitor<Boolean, Unifier> FORBIDDEN_REFERENCE_VISITOR = new SimpleTreeVisitor<Boolean, Unifier>(){

        @Override
        protected Boolean defaultAction(Tree node, Unifier unifier) {
            if (!(node instanceof JCTree.JCExpression)) {
                return false;
            }
            JCTree.JCExpression expr = (JCTree.JCExpression)node;
            for (UFreeIdent.Key key : Iterables.filter((Iterable)unifier.getBindings().keySet(), UFreeIdent.Key.class)) {
                JCTree.JCExpression keyBinding = unifier.getBinding(key);
                if (!PlaceholderUnificationVisitor.equivalentExprs(unifier, expr, keyBinding)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree node, Unifier unifier) {
            for (LocalVarBinding localBinding : Iterables.filter((Iterable)unifier.getBindings().values(), LocalVarBinding.class)) {
                if (!localBinding.symbol().equals(ASTHelpers.getSymbol((Tree)node))) continue;
                return true;
            }
            return this.defaultAction((Tree)node, unifier);
        }
    };
    private static final ImmutableSet<JCTree.Tag> MUTATING_UNARY_TAGS = ImmutableSet.copyOf(EnumSet.of(JCTree.Tag.PREINC, JCTree.Tag.PREDEC, JCTree.Tag.POSTINC, JCTree.Tag.POSTDEC));

    PlaceholderUnificationVisitor() {
    }

    public static PlaceholderUnificationVisitor create(TreeMaker maker, Map<UVariableDecl, UExpression> arguments) {
        return new AutoValue_PlaceholderUnificationVisitor(maker, (ImmutableMap<UVariableDecl, UExpression>)ImmutableMap.copyOf(arguments));
    }

    abstract TreeMaker maker();

    abstract ImmutableMap<UVariableDecl, UExpression> arguments();

    Choice<State<UPlaceholderExpression.PlaceholderParamIdent>> tryBindArguments(ExpressionTree node, State<?> state) {
        return Choice.from(this.arguments().entrySet()).flatMap(entry -> this.unifyParam((UVariableDecl)entry.getKey(), (UExpression)entry.getValue(), node, state.fork()));
    }

    private Choice<State<UPlaceholderExpression.PlaceholderParamIdent>> unifyParam(UVariableDecl placeholderParam, UExpression placeholderArg, ExpressionTree toUnify, State<?> state) {
        return placeholderArg.unify(toUnify, state.unifier()).map(unifier -> State.create(state.seenParameters().prepend(placeholderParam), unifier, new UPlaceholderExpression.PlaceholderParamIdent(placeholderParam, unifier.getContext())));
    }

    public Choice<? extends State<? extends JCTree>> unify(@Nullable Tree node, State<?> state) {
        if (node instanceof ExpressionTree) {
            ExpressionTree expressionTree = (ExpressionTree)node;
            return this.unifyExpression(expressionTree, state);
        }
        if (node == null) {
            return Choice.of(state.withResult(null));
        }
        return (Choice)node.accept(this, state);
    }

    public Choice<State<List<JCTree>>> unify(@Nullable Iterable<? extends Tree> nodes, State<?> state) {
        if (nodes == null) {
            return Choice.of(state.withResult(null));
        }
        Choice<State<List<Object>>> choice = Choice.of(state.withResult(List.nil()));
        for (Tree tree : nodes) {
            choice = choice.flatMap(s -> this.unify(node, (State<?>)s).map(treeState -> treeState.withResult(((List)s.result()).prepend((JCTree)treeState.result()))));
        }
        return choice.map(s -> s.withResult(((List)s.result()).reverse()));
    }

    static boolean equivalentExprs(Unifier unifier, JCTree.JCExpression expr1, JCTree.JCExpression expr2) {
        return expr1.type != null && expr2.type != null && Types.instance(unifier.getContext()).isSameType(expr2.type, expr1.type) && expr2.toString().equals(expr1.toString());
    }

    public Choice<? extends State<? extends JCTree.JCExpression>> unifyExpression(@Nullable ExpressionTree node, State<?> state) {
        if (node == null) {
            return Choice.of(state.withResult(null));
        }
        Choice<State<UPlaceholderExpression.PlaceholderParamIdent>> tryBindArguments = this.tryBindArguments(node, state);
        if (!node.accept(FORBIDDEN_REFERENCE_VISITOR, state.unifier()).booleanValue()) {
            return tryBindArguments.concat((Choice)node.accept(this, state));
        }
        return tryBindArguments;
    }

    public Choice<State<List<JCTree.JCExpression>>> unifyExpressions(@Nullable Iterable<? extends ExpressionTree> nodes, State<?> state) {
        return this.unify(nodes, state).map(s -> s.withResult(List.convert(JCTree.JCExpression.class, (List)s.result())));
    }

    public Choice<? extends State<? extends JCTree.JCStatement>> unifyStatement(@Nullable StatementTree node, State<?> state) {
        return this.unify(node, state);
    }

    public Choice<State<List<JCTree.JCStatement>>> unifyStatements(@Nullable Iterable<? extends StatementTree> nodes, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unify((Iterable<? extends Tree>)nodes, (State<?>)s), stmts -> List.convert(JCTree.JCStatement.class, stmts));
    }

    @Override
    protected Choice<State<JCTree>> defaultAction(Tree node, State<?> state) {
        return Choice.of(state.withResult((JCTree)node));
    }

    private static <T, R> Choice<State<R>> chooseSubtrees(State<?> state, Function<State<?>, Choice<? extends State<? extends T>>> choice1, Function<T, R> finalizer) {
        return ((Choice)choice1.apply(state)).map(s -> s.withResult(finalizer.apply(s.result())));
    }

    private static <T1, T2, R> Choice<State<R>> chooseSubtrees(State<?> state, Function<State<?>, Choice<? extends State<? extends T1>>> choice1, Function<State<?>, Choice<? extends State<? extends T2>>> choice2, BiFunction<T1, T2, R> finalizer) {
        return ((Choice)choice1.apply(state)).flatMap(s1 -> ((Choice)choice2.apply(s1)).map(s2 -> s2.withResult(finalizer.apply(s1.result(), s2.result()))));
    }

    private static <T1, T2, T3, R> Choice<State<R>> chooseSubtrees(State<?> state, Function<State<?>, Choice<? extends State<? extends T1>>> choice1, Function<State<?>, Choice<? extends State<? extends T2>>> choice2, Function<State<?>, Choice<? extends State<? extends T3>>> choice3, TriFunction<T1, T2, T3, R> finalizer) {
        return ((Choice)choice1.apply(state)).flatMap(s1 -> ((Choice)choice2.apply(s1)).flatMap(s2 -> ((Choice)choice3.apply(s2)).map(s3 -> s3.withResult(finalizer.apply(s1.result(), s2.result(), s3.result())))));
    }

    private static <T1, T2, T3, T4, R> Choice<State<R>> chooseSubtrees(State<?> state, Function<State<?>, Choice<? extends State<? extends T1>>> choice1, Function<State<?>, Choice<? extends State<? extends T2>>> choice2, Function<State<?>, Choice<? extends State<? extends T3>>> choice3, Function<State<?>, Choice<? extends State<? extends T4>>> choice4, QuadFunction<T1, T2, T3, T4, R> finalizer) {
        return ((Choice)choice1.apply(state)).flatMap(s1 -> ((Choice)choice2.apply(s1)).flatMap(s2 -> ((Choice)choice3.apply(s2)).flatMap(s3 -> ((Choice)choice4.apply(s3)).map(s4 -> s4.withResult(finalizer.apply(s1.result(), s2.result(), s3.result(), s4.result()))))));
    }

    @Override
    public Choice<State<JCTree.JCArrayAccess>> visitArrayAccess(ArrayAccessTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), s -> this.unifyExpression(node.getIndex(), (State<?>)s), this.maker()::Indexed);
    }

    @Override
    public Choice<State<JCTree.JCBinary>> visitBinary(BinaryTree node, State<?> state) {
        JCTree.Tag tag = ((JCTree.JCBinary)node).getTag();
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getLeftOperand(), (State<?>)s), s -> this.unifyExpression(node.getRightOperand(), (State<?>)s), (l, r) -> this.maker().Binary(tag, (JCTree.JCExpression)l, (JCTree.JCExpression)r));
    }

    @Override
    public Choice<State<JCTree.JCMethodInvocation>> visitMethodInvocation(MethodInvocationTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getMethodSelect(), (State<?>)s), s -> this.unifyExpressions((Iterable<? extends ExpressionTree>)node.getArguments(), (State<?>)s), (select, args) -> this.maker().Apply(null, (JCTree.JCExpression)select, (List<JCTree.JCExpression>)args));
    }

    @Override
    public Choice<State<JCTree.JCFieldAccess>> visitMemberSelect(MemberSelectTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), expr -> this.maker().Select((JCTree.JCExpression)expr, (Name)node.getIdentifier()));
    }

    @Override
    public Choice<State<JCTree.JCParens>> visitParenthesized(ParenthesizedTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), this.maker()::Parens);
    }

    @Override
    public Choice<State<JCTree.JCUnary>> visitUnary(UnaryTree node, State<?> state) {
        JCTree.Tag tag = ((JCTree.JCUnary)node).getTag();
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), expr -> this.maker().Unary(tag, (JCTree.JCExpression)expr)).filter(s -> !MUTATING_UNARY_TAGS.contains((Object)tag) || !(((JCTree.JCUnary)s.result()).getExpression() instanceof UPlaceholderExpression.PlaceholderParamIdent));
    }

    @Override
    public Choice<State<JCTree.JCTypeCast>> visitTypeCast(TypeCastTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), expr -> this.maker().TypeCast((JCTree)node.getType(), (JCTree.JCExpression)expr));
    }

    @Override
    public Choice<State<JCTree.JCInstanceOf>> visitInstanceOf(InstanceOfTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), expr -> this.maker().TypeTest((JCTree.JCExpression)expr, (JCTree)node.getType()));
    }

    @Override
    public Choice<State<JCTree.JCNewClass>> visitNewClass(NewClassTree node, State<?> state) {
        if (node.getEnclosingExpression() != null || node.getTypeArguments() != null && !node.getTypeArguments().isEmpty() || node.getClassBody() != null) {
            return Choice.none();
        }
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getIdentifier(), (State<?>)s), s -> this.unifyExpressions((Iterable<? extends ExpressionTree>)node.getArguments(), (State<?>)s), (ident, args) -> this.maker().NewClass(null, null, (JCTree.JCExpression)ident, (List<JCTree.JCExpression>)args, null));
    }

    @Override
    public Choice<State<JCTree.JCNewArray>> visitNewArray(NewArrayTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpressions((Iterable<? extends ExpressionTree>)node.getDimensions(), (State<?>)s), s -> this.unifyExpressions((Iterable<? extends ExpressionTree>)node.getInitializers(), (State<?>)s), (dims, inits) -> this.maker().NewArray((JCTree.JCExpression)node.getType(), (List<JCTree.JCExpression>)dims, (List<JCTree.JCExpression>)inits));
    }

    @Override
    public Choice<State<JCTree.JCConditional>> visitConditionalExpression(ConditionalExpressionTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getCondition(), (State<?>)s), s -> this.unifyExpression(node.getTrueExpression(), (State<?>)s), s -> this.unifyExpression(node.getFalseExpression(), (State<?>)s), this.maker()::Conditional);
    }

    @Override
    public Choice<State<JCTree.JCAssign>> visitAssignment(AssignmentTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getVariable(), (State<?>)s), s -> this.unifyExpression(node.getExpression(), (State<?>)s), this.maker()::Assign).filter(s -> !(((JCTree.JCAssign)s.result()).getVariable() instanceof UPlaceholderExpression.PlaceholderParamIdent));
    }

    @Override
    public Choice<State<JCTree.JCAssignOp>> visitCompoundAssignment(CompoundAssignmentTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getVariable(), (State<?>)s), s -> this.unifyExpression(node.getExpression(), (State<?>)s), (variable, expr) -> this.maker().Assignop(((JCTree.JCAssignOp)node).getTag(), (JCTree)variable, (JCTree)expr)).filter(assignOp -> !(((JCTree.JCAssignOp)assignOp.result()).getVariable() instanceof UPlaceholderExpression.PlaceholderParamIdent));
    }

    @Override
    public Choice<State<JCTree.JCExpressionStatement>> visitExpressionStatement(ExpressionStatementTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), this.maker()::Exec);
    }

    @Override
    public Choice<State<JCTree.JCBlock>> visitBlock(BlockTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyStatements((Iterable<? extends StatementTree>)node.getStatements(), (State<?>)s), stmts -> this.maker().Block(0L, (List<JCTree.JCStatement>)stmts));
    }

    @Override
    public Choice<State<JCTree.JCThrow>> visitThrow(ThrowTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), this.maker()::Throw);
    }

    @Override
    public Choice<State<JCTree.JCEnhancedForLoop>> visitEnhancedForLoop(EnhancedForLoopTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), s -> this.unifyStatement(node.getStatement(), (State<?>)s), (expr, stmt) -> this.maker().ForeachLoop((JCTree.JCVariableDecl)node.getVariable(), (JCTree.JCExpression)expr, (JCTree.JCStatement)stmt));
    }

    @Override
    public Choice<State<JCTree.JCIf>> visitIf(IfTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getCondition(), (State<?>)s), s -> this.unifyStatement(node.getThenStatement(), (State<?>)s), s -> this.unifyStatement(node.getElseStatement(), (State<?>)s), this.maker()::If);
    }

    @Override
    public Choice<State<JCTree.JCDoWhileLoop>> visitDoWhileLoop(DoWhileLoopTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyStatement(node.getStatement(), (State<?>)s), s -> this.unifyExpression(node.getCondition(), (State<?>)s), this.maker()::DoLoop);
    }

    @Override
    public Choice<State<JCTree.JCForLoop>> visitForLoop(ForLoopTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyStatements((Iterable<? extends StatementTree>)node.getInitializer(), (State<?>)s), s -> this.unifyExpression(node.getCondition(), (State<?>)s), s -> this.unifyStatements((Iterable<? extends StatementTree>)node.getUpdate(), (State<?>)s), s -> this.unifyStatement(node.getStatement(), (State<?>)s), (inits, cond, update, stmt) -> this.maker().ForLoop((List<JCTree.JCStatement>)inits, (JCTree.JCExpression)cond, List.convert(JCTree.JCExpressionStatement.class, update), (JCTree.JCStatement)stmt));
    }

    @Override
    public Choice<State<JCTree.JCLabeledStatement>> visitLabeledStatement(LabeledStatementTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyStatement(node.getStatement(), (State<?>)s), stmt -> this.maker().Labelled((Name)node.getLabel(), (JCTree.JCStatement)stmt));
    }

    @Override
    public Choice<State<JCTree.JCVariableDecl>> visitVariable(VariableTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getInitializer(), (State<?>)s), init -> this.maker().VarDef((JCTree.JCModifiers)node.getModifiers(), (Name)node.getName(), (JCTree.JCExpression)node.getType(), (JCTree.JCExpression)init));
    }

    @Override
    public Choice<State<JCTree.JCWhileLoop>> visitWhileLoop(WhileLoopTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getCondition(), (State<?>)s), s -> this.unifyStatement(node.getStatement(), (State<?>)s), this.maker()::WhileLoop);
    }

    @Override
    public Choice<State<JCTree.JCSynchronized>> visitSynchronized(SynchronizedTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), s -> this.unifyStatement(node.getBlock(), (State<?>)s), (expr, block) -> this.maker().Synchronized((JCTree.JCExpression)expr, (JCTree.JCBlock)block));
    }

    @Override
    public Choice<State<JCTree.JCReturn>> visitReturn(ReturnTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), this.maker()::Return);
    }

    @Override
    public Choice<State<JCTree.JCTry>> visitTry(TryTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unify((Iterable<? extends Tree>)node.getResources(), (State<?>)s), s -> this.unifyStatement(node.getBlock(), (State<?>)s), s -> this.unify((Iterable<? extends Tree>)node.getCatches(), (State<?>)s), s -> this.unifyStatement(node.getFinallyBlock(), (State<?>)s), (resources, block, catches, finallyBlock) -> this.maker().Try((List<JCTree>)resources, (JCTree.JCBlock)block, List.convert(JCTree.JCCatch.class, catches), (JCTree.JCBlock)finallyBlock));
    }

    @Override
    public Choice<State<JCTree.JCCatch>> visitCatch(CatchTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyStatement(node.getBlock(), (State<?>)s), block -> this.maker().Catch((JCTree.JCVariableDecl)node.getParameter(), (JCTree.JCBlock)block));
    }

    @Override
    public Choice<State<JCTree.JCSwitch>> visitSwitch(SwitchTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getExpression(), (State<?>)s), s -> this.unify((Iterable<? extends Tree>)node.getCases(), (State<?>)s), (expr, cases) -> this.maker().Switch((JCTree.JCExpression)expr, List.convert(JCTree.JCCase.class, cases)));
    }

    @Override
    public Choice<State<JCTree.JCCase>> visitCase(CaseTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unify((Iterable<? extends Tree>)node.getLabels(), (State<?>)s), s -> this.unifyExpression(node.getGuard(), (State<?>)s), s -> this.unifyStatements((Iterable<? extends StatementTree>)node.getStatements(), (State<?>)s), s -> this.unify(node.getBody(), (State<?>)s), (labels, guard, stmts, body) -> this.maker().Case(node.getCaseKind(), List.convert(JCTree.JCCaseLabel.class, labels), (JCTree.JCExpression)guard, (List<JCTree.JCStatement>)stmts, (JCTree)body));
    }

    @Override
    public Choice<State<JCTree.JCLambda>> visitLambdaExpression(LambdaExpressionTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unify(node.getBody(), (State<?>)s), body -> this.maker().Lambda(List.convert(JCTree.JCVariableDecl.class, (List)node.getParameters()), (JCTree)body));
    }

    @Override
    public Choice<State<JCTree.JCMemberReference>> visitMemberReference(MemberReferenceTree node, State<?> state) {
        return PlaceholderUnificationVisitor.chooseSubtrees(state, s -> this.unifyExpression(node.getQualifierExpression(), (State<?>)s), expr -> this.maker().Reference(node.getMode(), (Name)node.getName(), (JCTree.JCExpression)expr, List.convert(JCTree.JCExpression.class, (List)node.getTypeArguments())));
    }

    record State<R>(List<UVariableDecl> seenParameters, Unifier unifier, @Nullable R result) {
        static <R> State<R> create(List<UVariableDecl> seenParameters, Unifier unifier, @Nullable R result) {
            return new State<R>(seenParameters, unifier, result);
        }

        public <R2> State<R2> withResult(R2 result) {
            return State.create(this.seenParameters(), this.unifier(), result);
        }

        public State<R> fork() {
            return State.create(this.seenParameters(), this.unifier().fork(), this.result());
        }
    }

    @FunctionalInterface
    private static interface TriFunction<T1, T2, T3, R> {
        public R apply(T1 var1, T2 var2, T3 var3);
    }

    @FunctionalInterface
    private static interface QuadFunction<T1, T2, T3, T4, R> {
        public R apply(T1 var1, T2 var2, T3 var3, T4 var4);
    }
}

