/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class Choice<T> {
    private static final Choice<Object> NONE = new Choice<Object>(){

        @Override
        protected Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public <R> Choice<R> flatMap(Function<? super Object, Choice<R>> function) {
            Preconditions.checkNotNull(function);
            return 1.none();
        }

        @Override
        public <R> Choice<R> mapIfPresent(Function<? super Object, Optional<R>> function) {
            Preconditions.checkNotNull(function);
            return 1.none();
        }

        @Override
        public <R> Choice<R> map(Function<? super Object, R> function) {
            Preconditions.checkNotNull(function);
            return 1.none();
        }

        @Override
        public Choice<Object> concat(Choice<Object> other) {
            return (Choice)Preconditions.checkNotNull(other);
        }

        @Override
        @CanIgnoreReturnValue
        public Choice<Object> filter(Predicate<? super Object> predicate) {
            Preconditions.checkNotNull(predicate);
            return this;
        }

        @Override
        public String toString() {
            return "Choice.NONE";
        }
    };

    public static <T> Choice<T> none() {
        return NONE;
    }

    public static <T> Choice<T> of(final T t) {
        Preconditions.checkNotNull(t);
        return new Choice<T>(){

            @Override
            protected Iterator<T> iterator() {
                return Iterators.singletonIterator((Object)t);
            }

            @Override
            public Optional<T> findFirst() {
                return Optional.of(t);
            }

            @Override
            public Choice<T> filter(Predicate<? super T> predicate) {
                return predicate.test(t) ? this : Choice.none();
            }

            @Override
            public <R> Choice<R> flatMap(Function<? super T, Choice<R>> function) {
                return function.apply(t);
            }

            @Override
            public <R> Choice<R> mapIfPresent(Function<? super T, Optional<R>> function) {
                return 2.fromOptional(function.apply(t));
            }

            @Override
            public <R> Choice<R> map(Function<? super T, R> function) {
                return 2.of(function.apply(t));
            }

            @Override
            public String toString() {
                return String.format("Choice.of(%s)", t);
            }
        };
    }

    public static <T> Choice<T> condition(boolean condition, T t) {
        return condition ? Choice.of(t) : Choice.none();
    }

    public static <T> Choice<T> fromOptional(Optional<T> optional) {
        return optional.isPresent() ? Choice.of(optional.get()) : Choice.none();
    }

    public static <T> Choice<T> from(final Collection<T> choices) {
        return switch (choices.size()) {
            case 0 -> Choice.none();
            case 1 -> Choice.of(Iterables.getOnlyElement(choices));
            default -> new Choice<T>(){

                @Override
                protected Iterator<T> iterator() {
                    return choices.iterator();
                }

                @Override
                public String toString() {
                    return String.format("Choice.from(%s)", choices);
                }
            };
        };
    }

    private Choice() {
    }

    @VisibleForTesting
    Iterable<T> asIterable() {
        return this::iterator;
    }

    @ForOverride
    protected abstract Iterator<T> iterator();

    public String toString() {
        return Iterables.toString(this.asIterable());
    }

    public Optional<T> findFirst() {
        Iterator<T> itr = this.iterator();
        return itr.hasNext() ? Optional.of(itr.next()) : Optional.empty();
    }

    public <R> Choice<R> flatMap(final Function<? super T, Choice<R>> function) {
        Preconditions.checkNotNull(function);
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        final Choice thisChoice = this;
        return new Choice<R>(this){

            @Override
            protected Iterator<R> iterator() {
                if (Thread.interrupted()) {
                    throw new RuntimeException(new InterruptedException());
                }
                return Iterators.concat((Iterator)Iterators.transform(thisChoice.iterator(), t -> ((Choice)function.apply(t)).iterator()));
            }
        };
    }

    public <R> Choice<R> mapIfPresent(final Function<? super T, Optional<R>> function) {
        Preconditions.checkNotNull(function);
        final Choice thisChoice = this;
        return new Choice<R>(this){

            @Override
            protected Iterator<R> iterator() {
                return Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.transform(thisChoice.asIterable(), function::apply), Optional::isPresent), Optional::get).iterator();
            }
        };
    }

    public <R> Choice<R> map(final Function<? super T, R> function) {
        Preconditions.checkNotNull(function);
        final Choice thisChoice = this;
        return new Choice<R>(this){

            @Override
            protected Iterator<R> iterator() {
                return Iterators.transform(thisChoice.iterator(), function::apply);
            }
        };
    }

    public Choice<T> concat(final Choice<T> other) {
        Preconditions.checkNotNull(other);
        if (other == Choice.none()) {
            return this;
        }
        final Choice thisChoice = this;
        return new Choice<T>(this){

            @Override
            protected Iterator<T> iterator() {
                return Iterators.concat(thisChoice.iterator(), other.iterator());
            }

            @Override
            public String toString() {
                return String.format("%s.concat(%s)", thisChoice, other);
            }
        };
    }

    public Choice<T> filter(final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        final Choice thisChoice = this;
        return new Choice<T>(this){

            @Override
            protected Iterator<T> iterator() {
                return Iterators.filter(thisChoice.iterator(), predicate::test);
            }

            @Override
            public String toString() {
                return String.format("%s.filter(%s)", thisChoice, predicate);
            }
        };
    }
}

