/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Accessing the current time in a static initialiser captures the time at class loading, which is rarely desirable.")
public final class TimeInStaticInitializer
extends BugChecker
implements BugChecker.BlockTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> TIME_ACCESSORS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass((TypePredicate & Serializable)(t, s) -> {
        Symbol.PackageSymbol pkg = ASTHelpers.enclosingPackage((Symbol)t.tsym);
        return pkg != null && pkg.getQualifiedName().contentEquals("java.time");
    }).named("now"), Matchers.instanceMethod().onDescendantOf("java.time.InstantSource").named("instant"), Matchers.instanceMethod().onDescendantOf("com.google.common.time.TimeSource").named("instant")});
    private static final Supplier<Type> FLAG = VisitorState.memoize((Supplier & Serializable)s -> s.getTypeFromString("com.google.common.flags.Flag"));

    public Description matchBlock(BlockTree tree, VisitorState state) {
        if (tree.isStatic()) {
            this.scanForTimeAccess(state);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (symbol.isStatic() && tree.getInitializer() != null && !ASTHelpers.isSubtype((Type)symbol.type, (Type)((Type)FLAG.get(state)), (VisitorState)state)) {
            this.scanForTimeAccess(state.withPath(new TreePath(state.getPath(), tree.getInitializer())));
        }
        return Description.NO_MATCH;
    }

    private void scanForTimeAccess(VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return;
        }
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            public Void visitMethod(MethodTree node, Void unused) {
                return null;
            }

            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return null;
            }

            public Void visitMemberReference(MemberReferenceTree node, Void unused) {
                return null;
            }

            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                if (TIME_ACCESSORS.matches((Tree)node, this.state)) {
                    this.state.reportMatch(TimeInStaticInitializer.this.describeMatch(node));
                }
                return (Void)super.visitMethodInvocation(node, null);
            }
        }.scan(state.getPath(), null);
    }
}

