/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.ImmutableTypeParameter;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.ThreadSafeTypeParameter;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.AutoBuilder_ThreadSafety_Builder;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafetyKnownTypes;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownThreadSafety;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.ClassTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import org.jspecify.annotations.Nullable;
import org.pcollections.ConsPStack;

public final class ThreadSafety {
    private final VisitorState state;
    private final Purpose purpose;
    private final boolean markerAnnotationInherited;
    private final ThreadSafetyKnownTypes knownTypes;
    private final ImmutableSet<String> markerAnnotations;
    private final ImmutableSet<String> acceptedAnnotations;
    private final ImmutableSet<String> containerOfAnnotation;
    private final ImmutableSet<String> suppressAnnotation;
    private final ImmutableSet<String> typeParameterAnnotation;
    private final ImmutableSet<String> acceptedTypeParameterAnnotation;
    private static final Supplier<Name> CONTAINEROF = VisitorState.memoize((Supplier & Serializable)state -> state.getName("containerOf"));

    public static Builder builder() {
        return new AutoBuilder_ThreadSafety_Builder().acceptedAnnotations((Iterable<String>)ImmutableSet.of()).containerOfAnnotation((Iterable<String>)ImmutableSet.of()).suppressAnnotation((Iterable<String>)ImmutableSet.of()).typeParameterAnnotation((Iterable<String>)ImmutableSet.of()).acceptedTypeParameterAnnotation((Iterable<String>)ImmutableSet.of());
    }

    public static Builder threadSafeBuilder(WellKnownThreadSafety wellKnownThreadSafety) {
        Builder builder = ThreadSafety.builder().purpose(Purpose.FOR_THREAD_SAFE_CHECKER).markerAnnotationInherited(false).knownTypes(wellKnownThreadSafety).markerAnnotations((Iterable<String>)ImmutableSet.of((Object)ThreadSafe.class.getName())).acceptedAnnotations((Iterable<String>)ImmutableSet.of((Object)Immutable.class.getName())).typeParameterAnnotation((Iterable<String>)ImmutableSet.of((Object)ThreadSafeTypeParameter.class.getName())).acceptedTypeParameterAnnotation((Iterable<String>)ImmutableSet.of((Object)ImmutableTypeParameter.class.getName()));
        return builder;
    }

    ThreadSafety(VisitorState visitorState, Purpose purpose, boolean markerAnnotationInherited, ThreadSafetyKnownTypes knownTypes, ImmutableSet<String> markerAnnotations, ImmutableSet<String> acceptedAnnotations, ImmutableSet<String> containerOfAnnotation, ImmutableSet<String> suppressAnnotation, ImmutableSet<String> typeParameterAnnotation, ImmutableSet<String> acceptedTypeParameterAnnotation) {
        this.state = visitorState;
        this.purpose = purpose;
        this.markerAnnotationInherited = markerAnnotationInherited;
        this.knownTypes = knownTypes;
        this.markerAnnotations = markerAnnotations;
        this.acceptedAnnotations = acceptedAnnotations;
        this.containerOfAnnotation = containerOfAnnotation;
        this.suppressAnnotation = suppressAnnotation;
        this.typeParameterAnnotation = typeParameterAnnotation;
        this.acceptedTypeParameterAnnotation = acceptedTypeParameterAnnotation;
    }

    public Violation threadSafeInstantiation(Set<String> containerTypeParameters, AnnotationInfo annotation, Type type) {
        return this.threadSafeInstantiation(containerTypeParameters, annotation, type, new HashSet<Symbol.TypeVariableSymbol>());
    }

    public Violation threadSafeInstantiation(Set<String> containerTypeParameters, AnnotationInfo annotation, Type type, Set<Symbol.TypeVariableSymbol> recursiveThreadSafeTypeParameter) {
        for (int i = 0; i < type.tsym.getTypeParameters().size(); ++i) {
            Violation info;
            Symbol.TypeVariableSymbol typaram = type.tsym.getTypeParameters().get(i);
            boolean immutableTypeParameter = this.hasAcceptedThreadSafeTypeParameterAnnotation(typaram);
            if (!annotation.containerOf().contains(((Name)typaram.getSimpleName()).toString()) && !immutableTypeParameter) continue;
            if (type.getTypeArguments().isEmpty()) {
                return Violation.of(String.format("'%s' required instantiation of '%s' with type parameters, but was raw", this.getPrettyName(type.tsym), typaram));
            }
            Type tyarg = type.getTypeArguments().get(i);
            if (immutableTypeParameter && tyarg instanceof Type.WildcardType || this.suppressAnnotation != null && tyarg.getAnnotationMirrors().stream().anyMatch(a -> this.suppressAnnotation.contains((Object)((Symbol.ClassSymbol)a.getAnnotationType().asElement()).flatName().toString())) || !(info = this.isThreadSafeTypeInternal(!immutableTypeParameter, containerTypeParameters, tyarg, recursiveThreadSafeTypeParameter)).isPresent()) continue;
            return info.plus(String.format("'%s' was instantiated with %s type for '%s'", this.getPrettyName(type.tsym), this.purpose.mutableOrNonThreadSafe(), typaram.getSimpleName()));
        }
        return Violation.absent();
    }

    public Violation checkSuperInstantiation(Set<String> containerTypeParameters, AnnotationInfo annotation, Type type) {
        Violation info = this.threadSafeInstantiation(containerTypeParameters, annotation, type);
        if (info.isPresent()) {
            return info;
        }
        return Streams.zip(type.asElement().getTypeParameters().stream(), type.getTypeArguments().stream(), (typaram, argument) -> {
            if (this.containerOfSubtyping(containerTypeParameters, annotation, (Symbol.TypeVariableSymbol)typaram, (Type)argument)) {
                return Violation.of(String.format("'%s' is not a container of '%s'", annotation.typeName(), typaram));
            }
            return Violation.absent();
        }).filter(Violation::isPresent).findFirst().orElse(Violation.absent());
    }

    private boolean containerOfSubtyping(Set<String> containerTypeParameters, AnnotationInfo annotation, Symbol.TypeVariableSymbol typaram, Type tyargument) {
        if (!tyargument.hasTag(TypeTag.TYPEVAR)) {
            return false;
        }
        if (!containerTypeParameters.contains(((Name)tyargument.asElement().getSimpleName()).toString()) || this.isTypeParameterThreadSafe((Symbol.TypeVariableSymbol)tyargument.asElement(), containerTypeParameters)) {
            return false;
        }
        return !annotation.containerOf().contains(((Name)typaram.getSimpleName()).toString());
    }

    public Violation isThreadSafeType(boolean allowContainerTypeParameters, Set<String> containerTypeParameters, Type type) {
        return this.isThreadSafeTypeInternal(allowContainerTypeParameters, containerTypeParameters, type, new HashSet<Symbol.TypeVariableSymbol>());
    }

    private Violation isThreadSafeTypeInternal(boolean allowContainerTypeParameters, Set<String> containerTypeParameters, Type type, Set<Symbol.TypeVariableSymbol> recursiveThreadSafeTypeParameter) {
        return type.accept(new ThreadSafeTypeVisitor(allowContainerTypeParameters, containerTypeParameters, recursiveThreadSafeTypeParameter), null);
    }

    public boolean hasThreadSafeTypeParameterAnnotation(Symbol.TypeVariableSymbol symbol) {
        return symbol.getAnnotationMirrors().stream().anyMatch(t -> this.typeParameterAnnotation.contains((Object)t.type.tsym.flatName().toString()));
    }

    public boolean hasAcceptedThreadSafeTypeParameterAnnotation(Symbol.TypeVariableSymbol symbol) {
        Sets.SetView annotations = Sets.union(this.typeParameterAnnotation, this.acceptedTypeParameterAnnotation);
        return symbol.getAnnotationMirrors().stream().anyMatch(arg_0 -> ThreadSafety.lambda$hasAcceptedThreadSafeTypeParameterAnnotation$0((Set)annotations, arg_0));
    }

    public boolean hasThreadSafeElementAnnotation(Symbol.TypeVariableSymbol symbol) {
        return symbol.getAnnotationMirrors().stream().anyMatch(t -> this.containerOfAnnotation.contains((Object)t.type.tsym.flatName().toString()));
    }

    private boolean isTypeParameterThreadSafe(Symbol.TypeVariableSymbol symbol, Set<String> containerTypeParameters) {
        return this.isTypeParameterThreadSafe(symbol, containerTypeParameters, new HashSet<Symbol.TypeVariableSymbol>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTypeParameterThreadSafe(Symbol.TypeVariableSymbol symbol, Set<String> containerTypeParameters, Set<Symbol.TypeVariableSymbol> recursiveThreadSafeTypeParameter) {
        if (!recursiveThreadSafeTypeParameter.add(symbol)) {
            return true;
        }
        try {
            for (Type bound : symbol.getBounds()) {
                if (this.isThreadSafeTypeInternal(true, containerTypeParameters, bound, recursiveThreadSafeTypeParameter).isPresent()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = this.hasAcceptedThreadSafeTypeParameterAnnotation(symbol);
            return bl;
        }
        finally {
            recursiveThreadSafeTypeParameter.remove(symbol);
        }
    }

    public AnnotationInfo getMarkerOrAcceptedAnnotation(Symbol sym, VisitorState state) {
        String nameStr = sym.flatName().toString();
        AnnotationInfo known = (AnnotationInfo)this.knownTypes.getKnownSafeClasses().get((Object)nameStr);
        if (known != null) {
            return known;
        }
        return this.getAnnotation(sym, (ImmutableSet<String>)ImmutableSet.copyOf((Collection)Sets.union(this.markerAnnotations, this.acceptedAnnotations)), state);
    }

    public @Nullable Type mutableEnclosingInstance(Optional<ClassTree> tree, Type.ClassType type) {
        if (tree.isPresent() && !CanBeStaticAnalyzer.referencesOuter(tree.get(), ASTHelpers.getSymbol((ClassTree)tree.get()), this.state)) {
            return null;
        }
        Type enclosing = type.getEnclosingType();
        while (!enclosing.getKind().equals((Object)TypeKind.NONE)) {
            if (this.getMarkerOrAcceptedAnnotation(enclosing.tsym, this.state) == null && this.isThreadSafeType(false, (Set<String>)ImmutableSet.of(), enclosing).isPresent()) {
                return enclosing;
            }
            enclosing = enclosing.getEnclosingType();
        }
        return null;
    }

    public Set<String> threadSafeTypeParametersInScope(Symbol sym) {
        if (sym == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        Symbol s = sym;
        block4: while (s.owner != null) {
            switch (s.getKind()) {
                case INSTANCE_INIT: {
                    break;
                }
                case PACKAGE: {
                    break block4;
                }
                default: {
                    AnnotationInfo annotation = this.getMarkerOrAcceptedAnnotation(s, this.state);
                    if (annotation == null) break;
                    for (Symbol.TypeVariableSymbol typaram : s.getTypeParameters()) {
                        String name = ((Name)typaram.getSimpleName()).toString();
                        if (!annotation.containerOf().contains(name)) continue;
                        result.add((Object)name);
                    }
                    if (ASTHelpers.isStatic((Symbol)s)) break block4;
                }
            }
            s = s.owner;
        }
        return result.build();
    }

    private @Nullable AnnotationInfo getAnnotation(Symbol sym, ImmutableSet<String> annotationsToCheck, VisitorState state) {
        if (sym == null) {
            return null;
        }
        Optional<Attribute.Compound> attr = sym.getRawAttributes().stream().filter(a -> annotationsToCheck.contains((Object)a.type.tsym.getQualifiedName().toString())).findAny();
        if (attr.isPresent()) {
            ImmutableList containerElements = ThreadSafety.containerOf(state, attr.get());
            if (!this.containerOfAnnotation.isEmpty() && containerElements.isEmpty()) {
                containerElements = (ImmutableList)sym.getTypeParameters().stream().filter(p -> p.getAnnotationMirrors().stream().anyMatch(a -> this.containerOfAnnotation.contains((Object)a.type.tsym.flatName().toString()))).map(p -> ((Name)p.getSimpleName()).toString()).collect(ImmutableList.toImmutableList());
            }
            return AnnotationInfo.create(sym.getQualifiedName().toString(), containerElements);
        }
        if (!(sym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)sym;
        ImmutableSet superclasses = this.markerAnnotationInherited ? (ImmutableSet)state.getTypes().closure(classSymbol.type).stream().filter(c -> !c.tsym.equals(classSymbol)).collect(ImmutableSet.toImmutableSet()) : ImmutableSet.of((Object)classSymbol.getSuperclass());
        for (Type superClass : superclasses) {
            AnnotationInfo superAnnotation = this.getInheritedAnnotation(superClass.asElement(), state);
            if (superAnnotation == null) continue;
            ImmutableList.Builder containerOf = ImmutableList.builder();
            for (int i = 0; i < superClass.getTypeArguments().size(); ++i) {
                Type arg = superClass.getTypeArguments().get(i);
                Symbol.TypeVariableSymbol formal = superClass.asElement().getTypeParameters().get(i);
                if (!arg.hasTag(TypeTag.TYPEVAR)) continue;
                Symbol.TypeSymbol argSym = arg.asElement();
                if (argSym.owner != sym || !superAnnotation.containerOf().contains(((Name)formal.getSimpleName()).toString())) continue;
                containerOf.add((Object)((Name)argSym.getSimpleName()).toString());
            }
            return AnnotationInfo.create(superAnnotation.typeName(), (Iterable<String>)containerOf.build());
        }
        return null;
    }

    public AnnotationInfo getInheritedAnnotation(Symbol sym, VisitorState state) {
        return this.getAnnotation(sym, this.markerAnnotations, state);
    }

    private static ImmutableList<String> containerOf(VisitorState state, Attribute.Compound attr) {
        Attribute m = attr.member((Name)CONTAINEROF.get(state));
        if (m == null) {
            return ImmutableList.of();
        }
        return (ImmutableList)MoreAnnotations.asStrings((AnnotationValue)m).collect(ImmutableList.toImmutableList());
    }

    public String getPrettyName(Symbol sym) {
        if (!sym.getSimpleName().isEmpty()) {
            return sym.getSimpleName().toString();
        }
        if (sym.getKind() == ElementKind.ENUM) {
            return sym.owner.getSimpleName().toString();
        }
        Type superType = this.state.getTypes().supertype(sym.type);
        if (this.state.getTypes().isSameType(superType, this.state.getSymtab().objectType)) {
            superType = (Type)Iterables.getFirst(this.state.getTypes().interfaces(sym.type), (Object)superType);
        }
        return ((Name)superType.tsym.getSimpleName()).toString();
    }

    public Violation checkInstantiation(Collection<Symbol.TypeVariableSymbol> typeParameters, Collection<Type> typeArguments) {
        return Streams.zip(typeParameters.stream(), typeArguments.stream(), (sym, type) -> this.checkInstantiation((Symbol.TypeVariableSymbol)sym, (Collection<Type>)ImmutableList.of((Object)type))).filter(Violation::isPresent).findFirst().orElse(Violation.absent());
    }

    public Violation checkInstantiation(Symbol.TypeVariableSymbol typeParameter, Collection<Type> instantiations) {
        if (!this.hasThreadSafeTypeParameterAnnotation(typeParameter)) {
            return Violation.absent();
        }
        for (Type instantiation : instantiations) {
            Violation info = this.isThreadSafeType(true, (Set<String>)ImmutableSet.of(), instantiation);
            if (!info.isPresent()) continue;
            return info.plus(String.format("instantiation of '%s' is %s", typeParameter, this.purpose.mutableOrNotThreadSafe()));
        }
        return Violation.absent();
    }

    public Violation checkInvocation(Type methodType, Symbol symbol) {
        if (methodType == null) {
            return Violation.absent();
        }
        List<Symbol.TypeVariableSymbol> typeParameters = symbol.getTypeParameters();
        if (typeParameters.stream().noneMatch(this::hasThreadSafeTypeParameterAnnotation)) {
            return Violation.absent();
        }
        ImmutableListMultimap instantiation = ASTHelpers.getTypeSubstitution((Type)methodType, (Symbol)symbol);
        for (Symbol.TypeVariableSymbol typeParameter : typeParameters) {
            Violation violation = this.checkInstantiation(typeParameter, (Collection<Type>)instantiation.get((Object)typeParameter));
            if (!violation.isPresent()) continue;
            return violation;
        }
        return Violation.absent();
    }

    private static /* synthetic */ boolean lambda$hasAcceptedThreadSafeTypeParameterAnnotation$0(Set annotations, Attribute.Compound t) {
        return annotations.contains(t.type.tsym.flatName().toString());
    }

    @AutoBuilder(ofClass=ThreadSafety.class)
    public static abstract class Builder {
        public abstract Builder purpose(Purpose var1);

        public abstract Builder markerAnnotationInherited(boolean var1);

        public abstract Builder knownTypes(ThreadSafetyKnownTypes var1);

        public abstract Builder markerAnnotations(Iterable<String> var1);

        public abstract Builder acceptedAnnotations(Iterable<String> var1);

        public abstract Builder containerOfAnnotation(Iterable<String> var1);

        public abstract Builder suppressAnnotation(Iterable<String> var1);

        public abstract Builder typeParameterAnnotation(Iterable<String> var1);

        public abstract Builder acceptedTypeParameterAnnotation(Iterable<String> var1);

        abstract Builder visitorState(VisitorState var1);

        public final ThreadSafety build(VisitorState state) {
            return this.visitorState(state).build();
        }

        abstract ThreadSafety build();
    }

    public static enum Purpose {
        FOR_IMMUTABLE_CHECKER{

            @Override
            String mutableOrNonThreadSafe() {
                return "mutable";
            }

            @Override
            String mutableOrNotThreadSafe() {
                return "mutable";
            }
        }
        ,
        FOR_THREAD_SAFE_CHECKER{

            @Override
            String mutableOrNonThreadSafe() {
                return "non-thread-safe";
            }

            @Override
            String mutableOrNotThreadSafe() {
                return "not thread-safe";
            }
        };


        abstract String mutableOrNonThreadSafe();

        abstract String mutableOrNotThreadSafe();
    }

    public record Violation(ConsPStack<String> path) {
        public static Violation create(ConsPStack<String> path) {
            return new Violation(path);
        }

        public boolean isPresent() {
            return !this.path().isEmpty();
        }

        public String message() {
            return Joiner.on((String)", ").join(this.path());
        }

        public Violation plus(String edge) {
            return Violation.create((ConsPStack<String>)this.path().plus((Object)edge));
        }

        public static Violation of(String reason) {
            return Violation.create((ConsPStack<String>)ConsPStack.singleton((Object)reason));
        }

        public static Violation absent() {
            return Violation.create((ConsPStack<String>)ConsPStack.empty());
        }
    }

    private class ThreadSafeTypeVisitor
    extends Types.SimpleVisitor<Violation, Void> {
        private final boolean allowContainerTypeParameters;
        private final Set<String> containerTypeParameters;
        private final Set<Symbol.TypeVariableSymbol> recursiveThreadSafeTypeParameter;

        private ThreadSafeTypeVisitor(boolean allowContainerTypeParameters, Set<String> containerTypeParameters, Set<Symbol.TypeVariableSymbol> recursiveThreadSafeTypeParameter) {
            this.allowContainerTypeParameters = allowContainerTypeParameters;
            this.recursiveThreadSafeTypeParameter = recursiveThreadSafeTypeParameter;
            this.containerTypeParameters = !allowContainerTypeParameters ? ImmutableSet.of() : containerTypeParameters;
        }

        @Override
        public Violation visitWildcardType(Type.WildcardType type, Void s) {
            return ThreadSafety.this.state.getTypes().wildUpperBound(type).accept(this, null);
        }

        @Override
        public Violation visitArrayType(Type.ArrayType t, Void s) {
            return Violation.of(String.format("arrays are %s", ThreadSafety.this.purpose.mutableOrNotThreadSafe()));
        }

        @Override
        public Violation visitTypeVar(Type.TypeVar type, Void s) {
            Symbol.TypeVariableSymbol tyvar = (Symbol.TypeVariableSymbol)type.tsym;
            if (this.containerTypeParameters.contains(((Name)tyvar.getSimpleName()).toString())) {
                return Violation.absent();
            }
            if (ThreadSafety.this.isTypeParameterThreadSafe(tyvar, this.containerTypeParameters, this.recursiveThreadSafeTypeParameter)) {
                return Violation.absent();
            }
            String message = !this.allowContainerTypeParameters ? String.format("'%s' is not annotated @ImmutableTypeParameter", tyvar.getSimpleName()) : (!this.containerTypeParameters.isEmpty() ? String.format("'%s' is a %s type variable (not in '%s')", tyvar.getSimpleName(), ThreadSafety.this.purpose.mutableOrNonThreadSafe(), Joiner.on((String)", ").join(this.containerTypeParameters)) : String.format("'%s' is a %s type variable", tyvar.getSimpleName(), ThreadSafety.this.purpose.mutableOrNonThreadSafe()));
            return Violation.of(message);
        }

        @Override
        public Violation visitType(Type type, Void s) {
            switch (type.tsym.getKind()) {
                case ANNOTATION_TYPE: {
                    return Violation.absent();
                }
                case ENUM: {
                    return Violation.absent();
                }
                case INTERFACE: 
                case CLASS: 
                case RECORD: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unexpected type kind %s", new Object[]{type.tsym.getKind()}));
                }
            }
            if (WellKnownMutability.isAnnotation(ThreadSafety.this.state, type)) {
                return Violation.absent();
            }
            AnnotationInfo annotation = ThreadSafety.this.getMarkerOrAcceptedAnnotation(type.tsym, ThreadSafety.this.state);
            if (annotation != null) {
                return ThreadSafety.this.threadSafeInstantiation(this.containerTypeParameters, annotation, type, this.recursiveThreadSafeTypeParameter);
            }
            String nameStr = type.tsym.flatName().toString();
            if (ThreadSafety.this.knownTypes.getKnownUnsafeClasses().contains((Object)nameStr)) {
                return Violation.of(String.format("'%s' is %s", type.tsym.getSimpleName(), ThreadSafety.this.purpose.mutableOrNotThreadSafe()));
            }
            if (WellKnownMutability.isProto2MessageClass(ThreadSafety.this.state, type)) {
                if (WellKnownMutability.isProto2MutableMessageClass(ThreadSafety.this.state, type)) {
                    return Violation.of(String.format("'%s' is a mutable proto message", type.tsym.getSimpleName()));
                }
                return Violation.absent();
            }
            if (WellKnownMutability.isProtoEnum(ThreadSafety.this.state, type)) {
                return Violation.absent();
            }
            return Violation.of(String.format("the declaration of type '%s' is not annotated with %s", type, Streams.concat((Stream[])new Stream[]{ThreadSafety.this.markerAnnotations.stream(), ThreadSafety.this.acceptedAnnotations.stream()}).map(a -> "@" + a).collect(Collectors.joining(" or "))));
        }
    }
}

