/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnalysis;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import org.jspecify.annotations.Nullable;

@BugPattern(name="Immutable", summary="Type declaration annotated with @Immutable is not immutable", severity=BugPattern.SeverityLevel.ERROR, documentSuppression=false)
public class ImmutableChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.LambdaExpressionTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private final ImmutableAnalysis.Factory immutableAnalysisFactory;
    private final WellKnownMutability wellKnownMutability;
    private final ImmutableSet<String> immutableAnnotations;

    @Inject
    ImmutableChecker(ImmutableAnalysis.Factory immutableAnalysisFactory, WellKnownMutability wellKnownMutability) {
        this(immutableAnalysisFactory, wellKnownMutability, (ImmutableSet<String>)ImmutableSet.of((Object)Immutable.class.getName()));
    }

    ImmutableChecker(ImmutableAnalysis.Factory immutableAnalysisFactory, WellKnownMutability wellKnownMutability, ImmutableSet<String> immutableAnnotations) {
        this.immutableAnalysisFactory = immutableAnalysisFactory;
        this.wellKnownMutability = wellKnownMutability;
        this.immutableAnnotations = immutableAnnotations;
    }

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        Symbol.TypeSymbol lambdaType = ASTHelpers.getType((Tree)tree).tsym;
        ImmutableAnalysis analysis = this.createImmutableAnalysis(state);
        ThreadSafety.Violation info = analysis.checkInstantiation(lambdaType.getTypeParameters(), ASTHelpers.getType((Tree)tree).getTypeArguments());
        if (info.isPresent()) {
            state.reportMatch(this.buildDescription(tree).setMessage(info.message()).build());
        }
        if (!this.typeOrSuperHasImmutableAnnotation(lambdaType, state)) {
            return Description.NO_MATCH;
        }
        this.checkClosedTypes(tree, state, lambdaType, analysis);
        return Description.NO_MATCH;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        this.checkInvocation(tree, ASTHelpers.getSymbol((MemberReferenceTree)tree), ((JCTree.JCMemberReference)tree).referentType, state);
        ImmutableAnalysis analysis = this.createImmutableAnalysis(state);
        Symbol.TypeSymbol memberReferenceType = TargetType.targetType((VisitorState)state).type().tsym;
        ThreadSafety.Violation info = analysis.checkInstantiation(memberReferenceType.getTypeParameters(), ASTHelpers.getType((Tree)tree).getTypeArguments());
        if (info.isPresent()) {
            state.reportMatch(this.buildDescription(tree).setMessage(info.message()).build());
        }
        if (!this.typeOrSuperHasImmutableAnnotation(memberReferenceType, state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)) instanceof Symbol.ClassSymbol) {
            return Description.NO_MATCH;
        }
        Type receiverType = ASTHelpers.getReceiverType((ExpressionTree)tree);
        ImmutableSet<String> typarams = ImmutableChecker.immutableTypeParametersInScope(ASTHelpers.getSymbol((MemberReferenceTree)tree), state, analysis);
        ThreadSafety.Violation violation = analysis.isThreadSafeType(true, (Set<String>)typarams, receiverType);
        if (violation.isPresent()) {
            return this.buildDescription(tree).setMessage("This method reference implements @Immutable interface " + String.valueOf(memberReferenceType.getSimpleName()) + ", but " + violation.message()).build();
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        this.checkInvocation(tree, ASTHelpers.getSymbol((MethodInvocationTree)tree), ASTHelpers.getType((Tree)tree.getMethodSelect()), state);
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        this.checkInvocation(tree, ASTHelpers.getSymbol((NewClassTree)tree), ((JCTree.JCNewClass)tree).constructorType, state);
        this.checkInstantiation(tree, state, ASTHelpers.getSymbol((Tree)tree.getIdentifier()).getTypeParameters(), ASTHelpers.getType((Tree)tree).getTypeArguments());
        ClassTree classBody = tree.getClassBody();
        if (classBody != null) {
            this.checkClassTreeInstantiation(classBody, state, this.createImmutableAnalysis(state));
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        this.checkInstantiation(tree, state, ASTHelpers.getSymbol((MethodTree)tree).getTypeParameters(), ASTHelpers.getType((Tree)tree).getTypeArguments());
        return Description.NO_MATCH;
    }

    private ImmutableAnalysis createImmutableAnalysis(VisitorState state) {
        return this.immutableAnalysisFactory.create((arg_0, arg_1) -> ((ImmutableChecker)this).isSuppressed(arg_0, arg_1), state, this.immutableAnnotations);
    }

    private void checkInvocation(Tree tree, Symbol.MethodSymbol symbol, Type methodType, VisitorState state) {
        ImmutableAnalysis analysis = this.createImmutableAnalysis(state);
        ThreadSafety.Violation info = analysis.checkInvocation(methodType, symbol);
        if (info.isPresent()) {
            state.reportMatch(this.buildDescription(tree).setMessage(info.message()).build());
        }
    }

    private void checkInstantiation(Tree tree, VisitorState state, ImmutableAnalysis analysis, Collection<Symbol.TypeVariableSymbol> typeParameters, Collection<Type> typeArguments) {
        ThreadSafety.Violation info = analysis.checkInstantiation(typeParameters, typeArguments);
        if (info.isPresent()) {
            state.reportMatch(this.buildDescription(tree).setMessage(info.message()).build());
        }
    }

    private void checkInstantiation(Tree tree, VisitorState state, Collection<Symbol.TypeVariableSymbol> typeParameters, Collection<Type> typeArguments) {
        this.checkInstantiation(tree, state, this.createImmutableAnalysis(state), typeParameters, typeArguments);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableAnalysis analysis = this.createImmutableAnalysis(state);
        this.checkClassTreeInstantiation(tree, state, analysis);
        if (tree.getSimpleName().length() == 0) {
            return this.handleAnonymousClass(tree, state, analysis);
        }
        AnnotationInfo annotation = this.getImmutableAnnotation(analysis, tree, state);
        if (annotation == null) {
            return Description.NO_MATCH;
        }
        if (this.wellKnownMutability.getKnownImmutableClasses().containsValue((Object)annotation)) {
            return Description.NO_MATCH;
        }
        HashMap<String, Symbol.TypeVariableSymbol> typarams = new HashMap<String, Symbol.TypeVariableSymbol>();
        for (TypeParameterTree typeParameterTree : tree.getTypeParameters()) {
            typarams.put(typeParameterTree.getName().toString(), (Symbol.TypeVariableSymbol)ASTHelpers.getSymbol((Tree)typeParameterTree));
        }
        Sets.SetView difference = Sets.difference(annotation.containerOf(), typarams.keySet());
        if (!difference.isEmpty()) {
            return this.buildDescription(tree).setMessage(String.format("could not find type(s) referenced by containerOf: %s", Joiner.on((String)"', '").join((Iterable)difference))).build();
        }
        ImmutableSet immutableSet = (ImmutableSet)typarams.entrySet().stream().filter(e -> annotation.containerOf().contains(e.getKey()) && analysis.hasThreadSafeTypeParameterAnnotation((Symbol.TypeVariableSymbol)e.getValue())).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        if (!immutableSet.isEmpty()) {
            return this.buildDescription(tree).setMessage(String.format("using both @ImmutableTypeParameter and containerOf is redundant: %s", Joiner.on((String)"', '").join((Iterable)immutableSet))).build();
        }
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        ThreadSafety.Violation info = analysis.checkForImmutability(Optional.of(tree), ImmutableChecker.immutableTypeParametersInScope(ASTHelpers.getSymbol((ClassTree)tree), state, analysis), ASTHelpers.getType((ClassTree)tree), (matched, violation) -> this.describeClass(matched, sym, annotation, violation));
        Type superType = this.immutableSupertype(sym, state);
        if (superType != null && sym.isDirectlyOrIndirectlyLocal()) {
            this.checkClosedTypes(tree, state, superType.tsym, analysis);
        }
        if (!info.isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describeClass(tree, sym, annotation, info).build();
    }

    private void checkClassTreeInstantiation(ClassTree tree, VisitorState state, ImmutableAnalysis analysis) {
        for (Tree tree2 : tree.getImplementsClause()) {
            this.checkInstantiation(tree, state, analysis, ASTHelpers.getSymbol((Tree)tree2).getTypeParameters(), ASTHelpers.getType((Tree)tree2).getTypeArguments());
        }
        Tree extendsClause = tree.getExtendsClause();
        if (extendsClause != null) {
            this.checkInstantiation(tree, state, analysis, ASTHelpers.getSymbol((Tree)extendsClause).getTypeParameters(), ASTHelpers.getType((Tree)extendsClause).getTypeArguments());
        }
    }

    private Description.Builder describeClass(Tree tree, Symbol.ClassSymbol sym, AnnotationInfo annotation, ThreadSafety.Violation info) {
        Object message = sym.getQualifiedName().contentEquals(annotation.typeName()) ? "type annotated with @Immutable could not be proven immutable: " + info.message() : String.format("Class extends @Immutable type %s, but is not immutable: %s", annotation.typeName(), info.message());
        return this.buildDescription(tree).setMessage((String)message);
    }

    private Description handleAnonymousClass(ClassTree tree, VisitorState state, ImmutableAnalysis analysis) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        Type superType = this.immutableSupertype(sym, state);
        if (superType == null) {
            return Description.NO_MATCH;
        }
        this.checkClosedTypes(tree, state, superType.tsym, analysis);
        ImmutableSet<String> typarams = ImmutableChecker.immutableTypeParametersInScope(sym, state, analysis);
        ThreadSafety.Violation info = analysis.areFieldsImmutable(Optional.of(tree), typarams, ASTHelpers.getType((ClassTree)tree), (t, i) -> this.describeAnonymous(t, superType, i));
        if (!info.isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describeAnonymous(tree, superType, info).build();
    }

    private void checkClosedTypes(final Tree lambdaOrAnonymousClass, final VisitorState state, Symbol.TypeSymbol lambdaType, ImmutableAnalysis analysis) {
        HashSet variablesClosed = new HashSet();
        LinkedHashMultimap typesClosed = LinkedHashMultimap.create();
        final HashSet variablesOwnedByLambda = new HashSet();
        new TreePathScanner<Void, Void>(this, (SetMultimap)typesClosed, variablesClosed){
            final /* synthetic */ SetMultimap val$typesClosed;
            final /* synthetic */ Set val$variablesClosed;
            {
                this.val$typesClosed = setMultimap;
                this.val$variablesClosed = set2;
            }

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
                variablesOwnedByLambda.add(symbol);
                return (Void)super.visitVariable(tree, null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                Symbol.MethodSymbol symbol;
                if (ASTHelpers.getReceiver((ExpressionTree)tree) == null && !(symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree)).isStatic() && !symbol.isConstructor()) {
                    ImmutableChecker.effectiveTypeOfThis(symbol, this.getCurrentPath(), state).filter(t -> !ASTHelpers.isSameType((Type)t.type, (Type)ASTHelpers.getType((Tree)lambdaOrAnonymousClass), (VisitorState)state)).ifPresent(t -> this.val$typesClosed.put(t, (Object)symbol));
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                ExpressionTree expressionTree = tree.getExpression();
                if (expressionTree instanceof IdentifierTree) {
                    IdentifierTree identifierTree = (IdentifierTree)expressionTree;
                    if (ASTHelpers.getSymbol((Tree)tree) instanceof Symbol.VarSymbol && identifierTree.getName().contentEquals("this")) {
                        this.handleIdentifier(ASTHelpers.getSymbol((Tree)tree));
                        return null;
                    }
                }
                return (Void)super.visitMemberSelect(tree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                this.handleIdentifier(ASTHelpers.getSymbol((Tree)tree));
                return (Void)super.visitIdentifier(tree, null);
            }

            private void handleIdentifier(Symbol symbol) {
                if (symbol instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                    if (!variablesOwnedByLambda.contains(symbol) && !ASTHelpers.isStatic((Symbol)symbol)) {
                        this.val$variablesClosed.add(varSymbol);
                    }
                }
            }
        }.scan(state.getPath(), (Void)null);
        ImmutableSet<String> typarams = ImmutableChecker.immutableTypeParametersInScope(ASTHelpers.getSymbol((Tree)lambdaOrAnonymousClass), state, analysis);
        for (Symbol.VarSymbol varSymbol : variablesClosed) {
            ThreadSafety.Violation v = this.checkClosedVariable(varSymbol, lambdaOrAnonymousClass, typarams, analysis);
            if (!v.isPresent()) continue;
            String message = String.format("%s, but closes over '%s', which is not @Immutable because %s", ImmutableChecker.formAnonymousReason(lambdaOrAnonymousClass, lambdaType), varSymbol, v.message());
            state.reportMatch(this.buildDescription(lambdaOrAnonymousClass).setMessage(message).build());
        }
        for (Map.Entry entry : typesClosed.asMap().entrySet()) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)entry.getKey();
            Collection methods = (Collection)entry.getValue();
            if (this.typeOrSuperHasImmutableAnnotation(classSymbol.type.tsym, state)) continue;
            String message = String.format("%s, but accesses instance method(s) '%s' on '%s' which is not @Immutable.", ImmutableChecker.formAnonymousReason(lambdaOrAnonymousClass, lambdaType), methods.stream().map(Symbol::getSimpleName).collect(Collectors.joining(", ")), classSymbol.getSimpleName());
            state.reportMatch(this.buildDescription(lambdaOrAnonymousClass).setMessage(message).build());
        }
    }

    private static Optional<Symbol.ClassSymbol> effectiveTypeOfThis(Symbol.MethodSymbol symbol, TreePath currentPath, VisitorState state) {
        return Streams.stream(currentPath.iterator()).filter(ClassTree.class::isInstance).map(t -> ASTHelpers.getSymbol((ClassTree)((ClassTree)t))).filter(c -> ASTHelpers.isSubtype((Type)c.type, (Type)symbol.owner.type, (VisitorState)state)).findFirst();
    }

    private ThreadSafety.Violation checkClosedVariable(Symbol.VarSymbol closedVariable, Tree tree, ImmutableSet<String> typarams, ImmutableAnalysis analysis) {
        if (!closedVariable.getKind().equals((Object)ElementKind.FIELD)) {
            return analysis.isThreadSafeType(false, (Set<String>)typarams, closedVariable.type);
        }
        return analysis.isFieldImmutable(Optional.empty(), typarams, (Symbol.ClassSymbol)closedVariable.owner, (Type.ClassType)closedVariable.owner.type, closedVariable, (t, v) -> this.buildDescription(tree));
    }

    private static String formAnonymousReason(Tree tree, Symbol.TypeSymbol typeSymbol) {
        return "This " + (tree instanceof LambdaExpressionTree ? "lambda" : "anonymous class") + " implements @Immutable interface '" + String.valueOf(typeSymbol.getSimpleName()) + "'";
    }

    private Description.Builder describeAnonymous(Tree tree, Type superType, ThreadSafety.Violation info) {
        String message = String.format("Class extends @Immutable type %s, but is not immutable: %s", superType, info.message());
        return this.buildDescription(tree).setMessage(message);
    }

    private @Nullable AnnotationInfo getImmutableAnnotation(ImmutableAnalysis analysis, ClassTree tree, VisitorState state) {
        AnnotationInfo annotation = analysis.getImmutableAnnotation(tree, state);
        if (annotation != null) {
            return annotation;
        }
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        Type superType = this.immutableSupertype(sym, state);
        if (superType != null) {
            return analysis.getImmutableAnnotation(superType.tsym, state);
        }
        return null;
    }

    private @Nullable Type immutableSupertype(Symbol sym, VisitorState state) {
        for (Type superType : state.getTypes().closure(sym.type)) {
            if (superType.tsym.equals(sym.type.tsym) || !this.hasImmutableAnnotation(superType.tsym, state)) continue;
            return superType;
        }
        return null;
    }

    private boolean hasImmutableAnnotation(Symbol.TypeSymbol tsym, VisitorState state) {
        return this.immutableAnnotations.stream().anyMatch(annotation -> ASTHelpers.hasAnnotation((Symbol)tsym, (String)annotation, (VisitorState)state));
    }

    private boolean typeOrSuperHasImmutableAnnotation(Symbol.TypeSymbol tsym, VisitorState state) {
        return this.hasImmutableAnnotation(tsym, state) || this.immutableSupertype(tsym, state) != null;
    }

    private static ImmutableSet<String> immutableTypeParametersInScope(Symbol sym, VisitorState state, ImmutableAnalysis analysis) {
        if (sym == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        Symbol s = sym;
        block4: while (s.owner != null) {
            switch (s.getKind()) {
                case INSTANCE_INIT: {
                    break;
                }
                case PACKAGE: {
                    break block4;
                }
                default: {
                    AnnotationInfo annotation = analysis.getImmutableAnnotation(s, state);
                    if (annotation == null) break;
                    for (Symbol.TypeVariableSymbol typaram : s.getTypeParameters()) {
                        String name = ((Name)typaram.getSimpleName()).toString();
                        if (!annotation.containerOf().contains(name)) continue;
                        result.add((Object)name);
                    }
                    if (ASTHelpers.isStatic((Symbol)s)) break block4;
                }
            }
            s = s.owner;
        }
        return result.build();
    }
}

