/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Joiner;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByUtils;
import com.google.errorprone.bugpatterns.threadsafety.HeldLockAnalyzer;
import com.google.errorprone.bugpatterns.threadsafety.HeldLockSet;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import javax.inject.Inject;
import org.jspecify.annotations.Nullable;

@BugPattern(name="GuardedBy", altNames={"GuardedByChecker"}, summary="Checks for unguarded accesses to fields and methods with @GuardedBy annotations", severity=BugPattern.SeverityLevel.ERROR)
public class GuardedByChecker
extends BugChecker
implements BugChecker.VariableTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.LambdaExpressionTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final String JUC_READ_WRITE_LOCK = "java.util.concurrent.locks.ReadWriteLock";
    private static final Supplier<Symbol> JAVA_UTIL_CONCURRENT_LOCKS_READWRITELOCK = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString(JUC_READ_WRITE_LOCK));

    @Inject
    GuardedByChecker() {
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (ASTHelpers.getSymbol((MethodTree)tree).isConstructor()) {
            return Description.NO_MATCH;
        }
        this.analyze(state);
        return this.validate(tree, state);
    }

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        MethodInvocationTree methodInvocationTree;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof MethodInvocationTree && HeldLockAnalyzer.INVOKES_LAMBDAS_IMMEDIATELY.matches((Tree)(methodInvocationTree = (MethodInvocationTree)parent), state)) {
            return Description.NO_MATCH;
        }
        this.analyze(state.withPath(new TreePath(state.getPath(), tree.getBody())));
        return Description.NO_MATCH;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        MethodInvocationTree methodInvocationTree;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof MethodInvocationTree && HeldLockAnalyzer.INVOKES_LAMBDAS_IMMEDIATELY.matches((Tree)(methodInvocationTree = (MethodInvocationTree)parent), state)) {
            return Description.NO_MATCH;
        }
        this.analyze(state);
        return Description.NO_MATCH;
    }

    private void analyze(VisitorState state) {
        HeldLockAnalyzer.analyze(state, (tree, guard, live) -> GuardedByChecker.report(this.checkGuardedAccess(tree, guard, live, state), state), tree -> this.isSuppressed((Tree)tree, state));
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.validate(tree, state);
    }

    protected Description checkGuardedAccess(Tree tree, GuardedByExpression guard, HeldLockSet locks, VisitorState state) {
        if (GuardedByChecker.isRwLock(guard, state)) {
            return Description.NO_MATCH;
        }
        if (locks.allLocks().contains(guard)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(GuardedByChecker.buildMessage(guard, locks)).build();
    }

    private static String buildMessage(GuardedByExpression guard, HeldLockSet locks) {
        int heldLocks = locks.allLocks().size();
        StringBuilder message = new StringBuilder();
        GuardedByExpression.Select enclosing = GuardedByChecker.findOuterInstance(guard);
        if (enclosing != null && !GuardedByChecker.enclosingInstance(guard)) {
            if (guard == enclosing) {
                message.append(String.format("Access should be guarded by enclosing instance '%s' of '%s', which is not accessible in this scope", enclosing.sym().owner, enclosing.base()));
            } else {
                message.append(String.format("Access should be guarded by '%s' in enclosing instance '%s' of '%s', which is not accessible in this scope", guard.sym(), enclosing.sym().owner, enclosing.base()));
            }
            if (heldLocks > 0) {
                message.append(String.format("; instead found: '%s'", Joiner.on((String)"', '").join(locks.allLocks())));
            }
            return message.toString();
        }
        message.append(String.format("This access should be guarded by '%s'", guard));
        if (guard.kind() == GuardedByExpression.Kind.ERROR) {
            message.append(", which could not be resolved");
            return message.toString();
        }
        if (heldLocks == 0) {
            message.append(", which is not currently held");
        } else {
            message.append(String.format("; instead found: '%s'", Joiner.on((String)"', '").join(locks.allLocks())));
        }
        return message.toString();
    }

    private static @Nullable GuardedByExpression.Select findOuterInstance(GuardedByExpression expr) {
        while (expr.kind() == GuardedByExpression.Kind.SELECT) {
            GuardedByExpression.Select select = (GuardedByExpression.Select)expr;
            if (select.sym().name.contentEquals("outer$")) {
                return select;
            }
            expr = select.base();
        }
        return null;
    }

    private static boolean enclosingInstance(GuardedByExpression expr) {
        while (expr.kind() == GuardedByExpression.Kind.SELECT) {
            if ((expr = ((GuardedByExpression.Select)expr).base()).kind() != GuardedByExpression.Kind.THIS) continue;
            return true;
        }
        return false;
    }

    private static boolean isRwLock(GuardedByExpression guard, VisitorState state) {
        Type guardType = guard.type();
        if (guardType == null) {
            return false;
        }
        Symbol rwLockSymbol = (Symbol)JAVA_UTIL_CONCURRENT_LOCKS_READWRITELOCK.get(state);
        if (rwLockSymbol == null) {
            return false;
        }
        return state.getTypes().isSubtype(guardType, rwLockSymbol.type);
    }

    private static void report(Description description, VisitorState state) {
        if (description == null || description == Description.NO_MATCH) {
            return;
        }
        state.reportMatch(description);
    }

    private Description validate(Tree tree, VisitorState state) {
        GuardedByUtils.GuardedByValidationResult result = GuardedByUtils.isGuardedByValid(tree, state);
        if (result.isValid()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Invalid @GuardedBy expression: %s", result.message())).build();
    }
}

