/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

@BugPattern(summary="@Nullable type annotations should not be used for primitive types since they cannot be null", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class NullablePrimitiveArray
extends BugChecker
implements BugChecker.VariableTreeMatcher,
BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.check(tree.getReturnType(), tree.getModifiers().getAnnotations(), state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.check(tree.getType(), tree.getModifiers().getAnnotations(), state);
    }

    private Description check(Tree typeTree, List<? extends AnnotationTree> allTreeAnnos, VisitorState state) {
        AnnotatedTypeTree annotatedTypeTree;
        boolean hasTypeNullnessAnnoOnArray;
        Type type = ASTHelpers.getType((Tree)typeTree);
        if (type == null) {
            return Description.NO_MATCH;
        }
        if (!type.getKind().equals((Object)TypeKind.ARRAY)) {
            return Description.NO_MATCH;
        }
        while (type.getKind().equals((Object)TypeKind.ARRAY)) {
            type = state.getTypes().elemtype(type);
        }
        if (!type.isPrimitive()) {
            return Description.NO_MATCH;
        }
        ImmutableList treeNullnessAnnos = NullnessAnnotations.annotationsRelevantToNullness(allTreeAnnos);
        if (treeNullnessAnnos.isEmpty()) {
            return Description.NO_MATCH;
        }
        Symbol.TypeSymbol target = state.getSymtab().annotationTargetType.tsym;
        ImmutableList typeNullnessAnnos = (ImmutableList)treeNullnessAnnos.stream().filter(annotation -> NullablePrimitiveArray.isTypeAnnotation(ASTHelpers.getSymbol((Tree)annotation).attribute(target))).collect(ImmutableList.toImmutableList());
        if (typeNullnessAnnos.isEmpty()) {
            return Description.NO_MATCH;
        }
        Tree dims = typeTree;
        while (dims instanceof ArrayTypeTree) {
            dims = ((ArrayTypeTree)dims).getType();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        typeNullnessAnnos.forEach(arg_0 -> ((SuggestedFix.Builder)fix).delete(arg_0));
        boolean hasDeclarationNullnessAnno = typeNullnessAnnos.size() < treeNullnessAnnos.size();
        boolean bl = hasTypeNullnessAnnoOnArray = dims instanceof AnnotatedTypeTree && !NullnessAnnotations.annotationsRelevantToNullness((annotatedTypeTree = (AnnotatedTypeTree)dims).getAnnotations()).isEmpty();
        if (!hasDeclarationNullnessAnno && !hasTypeNullnessAnnoOnArray) {
            fix.postfixWith(dims, typeNullnessAnnos.stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(" ", " ", " ")));
        }
        return this.describeMatch((Tree)typeNullnessAnnos.getFirst(), (Fix)fix.build());
    }

    private static boolean isTypeAnnotation(Attribute.Compound attribute) {
        if (attribute == null) {
            return false;
        }
        final HashSet targets = new HashSet();
        Optional value = MoreAnnotations.getValue((Attribute.Compound)attribute, (String)"value");
        if (value.isEmpty()) {
            return false;
        }
        new SimpleAnnotationValueVisitor8<Void, Void>(){

            @Override
            public Void visitEnumConstant(VariableElement c, Void unused) {
                targets.add(c.getSimpleName().toString());
                return null;
            }

            @Override
            public Void visitArray(List<? extends AnnotationValue> list, Void unused) {
                list.forEach(x -> x.accept(this, null));
                return null;
            }
        }.visit((AnnotationValue)value.get(), null);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            String target;
            switch (target = (String)iterator.next()) {
                case "METHOD": 
                case "FIELD": 
                case "LOCAL_VARIABLE": 
                case "PARAMETER": {
                    return false;
                }
            }
        }
        return targets.contains("TYPE_USE");
    }
}

