/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@BugPattern(summary="Null is not permitted for this parameter.", severity=BugPattern.SeverityLevel.ERROR)
public final class NullArgumentForNonNullParameter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Supplier<Type> JAVA_OPTIONAL_TYPE = Suppliers.typeFromString((String)"java.util.Optional");
    private static final Supplier<Type> ARGUMENT_CAPTOR_CLASS = Suppliers.typeFromString((String)"org.mockito.ArgumentCaptor");
    private static final Supplier<Name> OF_NAME = VisitorState.memoize((Supplier & Serializable)state -> state.getName("of"));
    private static final Supplier<Name> FOR_CLASS_NAME = VisitorState.memoize((Supplier & Serializable)state -> state.getName("forClass"));
    private static final Supplier<Name> PROTO_NONNULL_API_NAME = VisitorState.memoize((Supplier & Serializable)state -> state.getName("com.google.protobuf.Internal$ProtoNonnullApi"));
    private static final Supplier<Name> NULL_MARKED_NAME = VisitorState.memoize((Supplier & Serializable)state -> state.getName("org.jspecify.annotations.NullMarked"));
    private static final Supplier<Name> NULL_UNMARKED_NAME = VisitorState.memoize((Supplier & Serializable)state -> state.getName("org.jspecify.annotations.NullUnmarked"));
    private static final Supplier<ImmutableSet<Name>> NULL_MARKED_PACKAGES_WE_TRUST = VisitorState.memoize((Supplier & Serializable)state -> (ImmutableSet)Arrays.stream(new String[]{"com.google.common"}).map(arg_0 -> ((VisitorState)state).getName(arg_0)).collect(ImmutableSet.toImmutableSet()));
    private final boolean beingConservative;

    @Inject
    NullArgumentForNonNullParameter(ErrorProneFlags flags) {
        this.beingConservative = NullnessUtils.nullnessChecksShouldBeConservative(flags);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.match(ASTHelpers.getSymbol((MethodInvocationTree)tree), tree.getArguments(), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.match(ASTHelpers.getSymbol((NewClassTree)tree), tree.getArguments(), state);
    }

    private Description match(Symbol.MethodSymbol methodSymbol, List<? extends ExpressionTree> args, VisitorState state) {
        if (NullnessUtils.hasExtraParameterForEnclosingInstance(methodSymbol)) {
            return Description.NO_MATCH;
        }
        if (methodSymbol.isVarArgs()) {
            return Description.NO_MATCH;
        }
        Streams.forEachPair(args.stream(), methodSymbol.getParameters().stream(), (argTree, paramSymbol) -> {
            if (!NullnessUtils.hasDefinitelyNullBranch(argTree, (Set<Symbol.VarSymbol>)ImmutableSet.of(), (ImmutableSet<javax.lang.model.element.Name>)ImmutableSet.of(), state)) {
                return;
            }
            if (!this.argumentMustBeNonNull((Symbol.VarSymbol)paramSymbol, state)) {
                return;
            }
            state.reportMatch(this.describeMatch((Tree)argTree));
        });
        return Description.NO_MATCH;
    }

    private boolean argumentMustBeNonNull(Symbol.VarSymbol sym, VisitorState state) {
        if (sym.owner.name.equals(FOR_CLASS_NAME.get(state)) && NullArgumentForNonNullParameter.isParameterOfMethodOnType(sym, ARGUMENT_CAPTOR_CLASS, state)) {
            return true;
        }
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return false;
        }
        if (((Type)sym.asType()).isPrimitive()) {
            return true;
        }
        if (sym.owner.name.equals(OF_NAME.get(state)) && NullArgumentForNonNullParameter.isParameterOfMethodOnType(sym, JAVA_OPTIONAL_TYPE, state)) {
            return true;
        }
        Nullness nullness = NullnessAnnotations.fromAnnotationsOn((Symbol)sym).orElse(null);
        if (nullness == Nullness.NONNULL && !this.beingConservative) {
            return true;
        }
        if (nullness == Nullness.NULLABLE) {
            return false;
        }
        if (((Type)sym.asType()).getKind() == TypeKind.TYPEVAR) {
            return this.isNonNull(sym.asType(), sym, state);
        }
        return this.enclosingAnnotationDefaultsNonTypeVariablesToNonNull(sym, state);
    }

    private boolean isNonNull(TypeMirror type, Symbol typeUseSite, VisitorState state) {
        Optional nullness = NullnessAnnotations.fromAnnotationsOn((TypeMirror)type);
        if (nullness.isPresent()) {
            return ((Nullness)nullness.get()).equals((Object)Nullness.NONNULL);
        }
        if (type instanceof Type.TypeVar) {
            Stream<Type> stream;
            Type.TypeVar typeVar = (Type.TypeVar)type;
            Type upperBound = typeVar.getUpperBound();
            if (upperBound instanceof Type.IntersectionClassType) {
                Type.IntersectionClassType intersectionType = (Type.IntersectionClassType)upperBound;
                stream = intersectionType.getBounds().stream();
            } else {
                stream = Stream.of(upperBound);
            }
            return stream.anyMatch(t -> this.isNonNull((TypeMirror)t, typeVar.tsym, state));
        }
        return this.enclosingAnnotationDefaultsNonTypeVariablesToNonNull(typeUseSite, state);
    }

    private static boolean isParameterOfMethodOnType(Symbol.VarSymbol sym, Supplier<Type> typeSupplier, VisitorState state) {
        Type target = (Type)typeSupplier.get(state);
        return target != null && state.getTypes().isSameType(ASTHelpers.enclosingClass((Symbol)sym).type, target);
    }

    private boolean enclosingAnnotationDefaultsNonTypeVariablesToNonNull(Symbol sym, VisitorState state) {
        while (sym != null) {
            if (NullArgumentForNonNullParameter.hasDirectAnnotation(sym, (Name)PROTO_NONNULL_API_NAME.get(state))) {
                return true;
            }
            boolean marked = NullArgumentForNonNullParameter.hasDirectAnnotation(sym, (Name)NULL_MARKED_NAME.get(state));
            boolean unmarked = NullArgumentForNonNullParameter.hasDirectAnnotation(sym, (Name)NULL_UNMARKED_NAME.get(state));
            if (marked && !unmarked && this.weTrustNullMarkedOn(sym, state)) {
                return true;
            }
            if (unmarked && !marked) {
                return false;
            }
            sym = sym.getEnclosingElement();
        }
        return false;
    }

    private static boolean hasDirectAnnotation(Symbol sym, Name name) {
        return sym.getAnnotationMirrors().stream().anyMatch(a -> ((Symbol)a.getAnnotationType().asElement()).getQualifiedName().equals(name));
    }

    private boolean weTrustNullMarkedOn(Symbol sym, VisitorState state) {
        if (!this.beingConservative) {
            return true;
        }
        ImmutableSet packagesWeTrust = (ImmutableSet)NULL_MARKED_PACKAGES_WE_TRUST.get(state);
        sym = ASTHelpers.enclosingPackage((Symbol)sym);
        while (sym != null) {
            if (packagesWeTrust.contains((Object)sym.getQualifiedName())) {
                return true;
            }
            sym = sym.owner;
        }
        return false;
    }
}

