/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.Futures;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Name;

abstract class AbstractAsyncTypeReturnsNull
extends BugChecker
implements BugChecker.ReturnTreeMatcher,
BugChecker.LambdaExpressionTreeMatcher {
    private final Class<?> asyncClass;

    AbstractAsyncTypeReturnsNull(Class<?> asyncClass) {
        this.asyncClass = asyncClass;
    }

    public final Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        ExpressionTree body;
        Tree tree2 = tree.getBody();
        if (!(tree2 instanceof ExpressionTree) || !NullnessUtils.hasDefinitelyNullBranch(body = (ExpressionTree)tree2, (Set<Symbol.VarSymbol>)ImmutableSet.of(), (ImmutableSet<Name>)ImmutableSet.of(), state)) {
            return Description.NO_MATCH;
        }
        Type functionalInterfaceType = ASTHelpers.getType((Tree)tree);
        if (functionalInterfaceType == null) {
            return Description.NO_MATCH;
        }
        if (!this.lambdaOverridesAsyncMethod(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)this.provideFix(body));
    }

    public final Description matchReturn(ReturnTree tree, VisitorState state) {
        if (tree.getExpression() == null || !NullnessUtils.hasDefinitelyNullBranch(tree.getExpression(), (Set<Symbol.VarSymbol>)ImmutableSet.of(), (ImmutableSet<Name>)ImmutableSet.of(), state)) {
            return Description.NO_MATCH;
        }
        Type asyncType = state.getTypeFromString(this.asyncClass.getName());
        boolean matches = Streams.stream((Iterable)state.getPath()).map(t -> {
            Tree tree = t;
            Objects.requireNonNull(tree);
            Tree selector0$temp = tree;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodTree.class, LambdaExpressionTree.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    MethodTree methodTree = (MethodTree)selector0$temp;
                    yield ASTHelpers.findSuperMethods((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)methodTree), (Types)state.getTypes()).stream().anyMatch(superMethod -> superMethod.owner != null && ASTHelpers.isSameType((Type)superMethod.owner.type, (Type)asyncType, (VisitorState)state));
                }
                case 1 -> {
                    LambdaExpressionTree lambdaTree = (LambdaExpressionTree)selector0$temp;
                    yield this.lambdaOverridesAsyncMethod(lambdaTree, state);
                }
                default -> null;
            };
        }).filter(match -> match != null).findFirst().orElse(false);
        return matches ? this.describeMatch(tree, (Fix)this.provideFix(tree.getExpression())) : Description.NO_MATCH;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean lambdaOverridesAsyncMethod(LambdaExpressionTree lambdaTree, VisitorState state) {
        Type functionalInterfaceType = ASTHelpers.getType((Tree)lambdaTree);
        if (functionalInterfaceType == null) {
            return false;
        }
        Symbol descriptorSymbol = state.getTypes().findDescriptorSymbol(functionalInterfaceType.tsym);
        Type asyncType = state.getTypeFromString(this.asyncClass.getName());
        if (!(descriptorSymbol instanceof Symbol.MethodSymbol)) return false;
        Symbol.MethodSymbol ms = (Symbol.MethodSymbol)descriptorSymbol;
        if (!Streams.concat((Stream[])new Stream[]{Stream.of(ms), ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)((Symbol.MethodSymbol)descriptorSymbol), (Types)state.getTypes())}).anyMatch(superMethod -> superMethod.owner != null && ASTHelpers.isSameType((Type)superMethod.owner.type, (Type)asyncType, (VisitorState)state))) return false;
        return true;
    }

    protected SuggestedFix provideFix(ExpressionTree tree) {
        return tree.getKind() == Tree.Kind.NULL_LITERAL ? SuggestedFix.builder().replace((Tree)tree, "immediateFuture(null)").addStaticImport(Futures.class.getName() + ".immediateFuture").build() : SuggestedFix.emptyFix();
    }
}

