/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This Javadoc tag wasn't recognised by the parser. Is it malformed somehow, perhaps with mismatched braces?", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class UnrecognisedJavadocTag
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Pattern TAG = Pattern.compile("\\{@(code|link)");

    public Description matchClass(ClassTree classTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    private Description handle(@Nullable DocTreePath path, VisitorState state) {
        if (path == null) {
            return Description.NO_MATCH;
        }
        ImmutableSet<Integer> recognisedTags = this.findRecognisedTags(path, state);
        ImmutableSet<Integer> tagStrings = UnrecognisedJavadocTag.findTags(((DCTree.DCDocComment)path.getDocComment()).comment);
        UnmodifiableIterator unmodifiableIterator = Sets.difference(tagStrings, recognisedTags).iterator();
        while (unmodifiableIterator.hasNext()) {
            int pos = (Integer)unmodifiableIterator.next();
            state.reportMatch(this.buildDescription(Utils.getDiagnosticPosition(pos, path.getTreePath().getLeaf())).build());
        }
        return Description.NO_MATCH;
    }

    private ImmutableSet<Integer> findRecognisedTags(DocTreePath path, final VisitorState state) {
        final ImmutableSet.Builder tags = ImmutableSet.builder();
        new DocTreePathScanner<Void, Void>(this){

            @Override
            public Void visitLink(LinkTree linkTree, Void unused) {
                tags.add((Object)Utils.getStartPosition(linkTree, state));
                return (Void)super.visitLink(linkTree, null);
            }

            @Override
            public Void visitLiteral(LiteralTree literalTree, Void unused) {
                if (literalTree.getKind().equals((Object)DocTree.Kind.CODE)) {
                    tags.add((Object)Utils.getStartPosition(literalTree, state));
                }
                return (Void)super.visitLiteral(literalTree, null);
            }
        }.scan(path, (Void)null);
        return tags.build();
    }

    private static ImmutableSet<Integer> findTags(Tokens.Comment comment) {
        Matcher matcher = TAG.matcher(comment.getText());
        ImmutableSet.Builder tags = ImmutableSet.builder();
        while (matcher.find()) {
            tags.add((Object)comment.getSourcePos(matcher.start()));
        }
        return tags.build();
    }
}

