/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.util.Context;

@BugPattern(summary="Avoid using `/**` for comments which aren't actually Javadoc.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class NotJavadoc
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableMap<Integer, TreePath> javadocableTrees = Utils.getJavadoccableTrees(tree);
        ImmutableSet<Integer> seeminglyJavadocableTrees = NotJavadoc.getSeeminglyJavadocableTrees(tree);
        ImmutableRangeSet suppressedRegions = this.suppressedRegions(state);
        for (ErrorProneToken token : ErrorProneTokens.getTokens((String)state.getSourceCode().toString(), (Context)state.context)) {
            for (ErrorProneComment comment : token.comments()) {
                if (!comment.getStyle().equals((Object)ErrorProneComment.ErrorProneCommentStyle.JAVADOC_BLOCK) || comment.getText().equals("/**/") || javadocableTrees.containsKey((Object)token.pos()) || suppressedRegions.intersects(Range.closed((Comparable)Integer.valueOf(comment.getSourcePos(0)), (Comparable)Integer.valueOf(comment.getSourcePos(comment.getText().length() - 1))))) continue;
                int endPos = 2;
                while (comment.getText().charAt(endPos) == '*') {
                    ++endPos;
                }
                String message = seeminglyJavadocableTrees.contains((Object)token.pos()) ? "This comment seems to be attached to a method or class, but methods and classes nested within methods cannot be documented with Javadoc." : this.message();
                state.reportMatch(this.buildDescription(Utils.getDiagnosticPosition(comment.getSourcePos(0), tree)).setMessage(message).addFix((Fix)SuggestedFix.replace((int)comment.getSourcePos(1), (int)comment.getSourcePos(endPos - 1), (String)"")).build());
            }
        }
        return Description.NO_MATCH;
    }

    private static ImmutableSet<Integer> getSeeminglyJavadocableTrees(CompilationUnitTree tree) {
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        tree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void unused) {
                if (tree instanceof MethodTree || tree instanceof ClassTree) {
                    builder.add((Object)ASTHelpers.getStartPosition((Tree)tree));
                }
                return (Void)super.scan(tree, null);
            }
        }, null);
        return builder.build();
    }
}

